#!/usr/bin/env python
#*********************************************************************
#  MaeFlight for Maemo5
#  Copyright (C) 2010 Sanjeev Visvanatha <svisvanatha@gmail.com>
#  This program is NOT free software.
#  You are not allowed to redistribute it and/or modify it.
#  Dissembly of binaries is striclty prohibited.
#
#  THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
#  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
#  OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#**********************************************************************
import sys
import dbus

#import maeflight_utils
from maeflight_utils import *

#import Date and time functions
import time
import datetime
import string
global link
global today
global date
today=True
date = datetime.date.today()

#Now we include our maeflight_ui.py generated from pyuic4.
from maeflight_ui import *

# We instantiate a QApplication passing the arguments of the script to it:
app = QtGui.QApplication(sys.argv)
MainWindow = QtGui.QMainWindow()
ui = Ui_MaeFlight()
ui.setupUi(MainWindow)

#configure the resultsBrowser and TodayButton objects
ui.resultsBrowser.setReadOnly(True)
ui.resultsBrowser.setOpenExternalLinks(True)

#setup the numeric validators for the Flight Number
numval = QtGui.QIntValidator(0,999999,ui.FlightNumberlineEdit)
ui.FlightNumberlineEdit.setValidator(numval)

#Put plug for FlightStats in the results window upon loading the MaeFlight application.
ui.resultsBrowser.setText('MaeFlight is powered by <a href="http://www.flightstats.com">FlightStats.com</a>')

# This function executes a search of the flight given the entry of airline and flight number from the user
def on_search_clicked():
	global link
	global date
	# Define the Flight search parameters	
	Airline=ui.AirlineEdit.displayText()
	Airline=Airline.toUpper()
	FlightNumber = ui.FlightNumberlineEdit.displayText()
        
	#Create the SOAP Client
	url = 'file:///opt/maeflight/FlightHistoryService.wsdl'
	client = Client(url, cache=None)      
		
	#Create parameters for the FlightHistoryGetHistoryInfo service
	service=client.factory.create('ns0:FlightHistoryGetHistoryInfo')
	service.SpecificationFlight.Airline._AirlineCode=Airline
	service.SpecificationFlight._FlightNumber=FlightNumber
	service.SpecificationFlight._SearchCodeshares='true'
	service.SpecificationDateRange._DepartureDateTimeMin='%sT00:00' % (date)
	service.SpecificationDateRange._DepartureDateTimeMax='%sT23:59' % (date)

	#Get the response back from the server
	result=GetFlightHistory(client,service)
	#verify if the flight is valid or not	
	if not len(result):
		#flight is not valid		
		ui.resultsBrowser.setText('Either the Airline or Flight Number is incorrect - please try again')
	else:
		#flight is valid - Print the Specified Results for each FlightHistory record (to account for multi-leg flights)
		ui.resultsBrowser.setText('')
		FlightHistory=result.FlightHistory		
		for FlightHistoryRecord in FlightHistory:
			DepartureAirport=FlightHistoryRecord.Origin._AirportCode
			ArrivalAirport=FlightHistoryRecord.Destination._AirportCode
			Status=FlightHistoryRecord._Status
			PublishedDepartureDate=FlightHistoryRecord._PublishedDepartureDate	#published departure
			PublishedArrivalDate=FlightHistoryRecord._PublishedArrivalDate	  	#published departure
			AirlineName=FlightHistoryRecord.Airline._Name
			AirlineFlightNumber=FlightHistoryRecord._FlightNumber
			FlightHistoryId=FlightHistoryRecord._FlightHistoryId

			#configure the resultsBrowser object
			ui.resultsBrowser.append('%s %s \n\
From:	(%s)	%s\n\
To:	(%s)	%s\n\
Current Status:	%s\n'\
 		% (AirlineName, AirlineFlightNumber, DepartureAirport, PublishedDepartureDate.strftime("%a. %d %b, %Y - %I:%M%p"),  ArrivalAirport, PublishedArrivalDate.strftime("%a. %d %b, %Y - %I:%M%p"), Status))
	
		ui.resultsBrowser.append('Data courtesy of: <a href="http://www.flightstats.com">www.flightstats.com</a>')

		#show the detailed status button now
		ui.detailedStatusButton.setEnabled(True)
		link="http://www.flightstats.com/go/Mobile/flightStatusByFlightProcess.do?id=%s&airlineCode=%s&flightNumber=%s" \
% (str(FlightHistoryId),Airline,AirlineFlightNumber)


# This function opens the browser to the flightstats.com detailed status
def on_detailed_status_clicked():
	# Note: this method of opening browser is per: http://lists.maemo.org/pipermail/maemo-developers/2007-October/011935.html
	# Launch browser DBUS service
        bus = dbus.SessionBus()
        proxy_obj = bus.get_object('com.nokia.osso_browser','/com/nokia/osso_browser')
        dbus_iface = dbus.Interface(proxy_obj, 'com.nokia.osso_browser')
        # Make browser use correct url
        dbus_iface.open_new_window(str(link))


# This function toggles the search date between today's date and tomorrow's date
def on_today_clicked():
	global date
	global today
	today=not(today)
	if (today):
		ui.TodayButton.setText('Today')
		date=datetime.date.today()	
	else:
		ui.TodayButton.setText('Tomorrow')
		diff=datetime.timedelta(days=1)
		date=date+diff

	
#connect signal from search box
QtCore.QObject.connect(ui.searchButton, QtCore.SIGNAL("clicked()"), on_search_clicked)

#connect signal from the Detailed Flight Status button
QtCore.QObject.connect(ui.detailedStatusButton, QtCore.SIGNAL("clicked()"), on_detailed_status_clicked)

#connect signal from the Today button
QtCore.QObject.connect(ui.TodayButton, QtCore.SIGNAL("clicked()"), on_today_clicked)


MainWindow.show()

# Now we can start it.
sys.exit(app.exec_())



