/*
 * resource_utils.c
 *
 *  Created on: 2009-12-18
 *      Author: marcin
 */

#include "resource_utils.h"

GtkWidget* resource_get_image(const gchar* name) {
	gchar* filepath = g_strdup_printf("%s/%s", RESPREFIX, name);
	GtkWidget* image = gtk_image_new_from_file(filepath);
	g_free(filepath);
	return image;
}

GdkPixbuf* resource_get_pixbuf_at_scale(const gchar* name, int width, int height) {
	gchar* filepath = g_strdup_printf("%s/%s", RESPREFIX, name);
	GdkPixbuf* pixbuf = gdk_pixbuf_new_from_file_at_scale(filepath, width, height, TRUE, NULL);
	g_free(filepath);
	return pixbuf;
}
