#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QThread>
#include <QDirModel>
#include <QGridLayout>
#include <QWidget>
#include <QTabWidget>
#include <QScrollArea>
#include "codeeditor.h"
#include "gdbthread.h"
#include "gdboutput.h"
#include "scanfthread.h"
#include "highlighter.h"
#include "flags.h"
#include "codeeditor.h"
#include "Terminal/outputthread.h"
#include "Terminal/terminal.h"
#include "Common.h"
#include "rceventhandler.h"

#define MAXTAB 10
namespace Ui
{
    class MainWindow;
}
class MyThread;
class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    MainWindow(int argc,char *argv[],QWidget *parent = 0);
    ~MainWindow();
    void init();

public slots:
    void debug();
    bool maybeSave(int i=-1);
    bool fileSave();
    bool fileSaveAs();
    void fileNew();
    void open(QString fname="");
    void closeEvent(QCloseEvent *event);
    void run();
    void compile();
    void highlightDebuggingLine(int linenum,int color=0);
    void addBreakPoint();
    void showAbout();
    void updateLineNumber(QString str);
    void stopDebug();
    void updateDisplay(QString str);
    void showScanDialog(QString str);
    void terminalExiting();
    void showFullScreenSlot();
public:
    GdbThread gdbThread;
    Terminal *t;
    Ui::MainWindow *ui;

    QString outputString;
    Flags flags;
    QDirModel model;
    ScanfThread scanfThread;
    GdbOutput gdbOutput;
    OutputThread outputThread;
    QPushButton *m_dbButton;
    const QIcon m_fsIcon;

    QList <QWidget *> tab;
    QList <Highlighter *> highlighter;
    QList <QGridLayout *> gridLayout;
    QList <QGridLayout *> gridLayout2;
    QList <CodeEditor *> displayArea;
    QList <QScrollArea *> scrollArea;
    QList <QString > fileName;
    QList <QWidget *> scrollAreaWidgetContents;

    int compiledTab;
    int currentFileTab;
    RCEventHandler *listEvHandler;

    QMenu *watchMenu;
    QAction *actionNewWatch;
    QAction *actionDeleteWatch;

    QStringList watchVariablesList;

private slots:
    void documentModified();
    void closeTab(int index);
    void textUndo();
    void textRedo();
    void insertKeyword();
    void cancelButtonClicked();
    void keywordSelected(QModelIndex index);
    void upPushButtonSlot();
    void downPushButtonSlot();
    void deleteKeywordList();
    void addKeywordList();
    void enableDebugingMode();

    void textCopy();
    void textCut();
    void textPaste();
    void rightButtonClicked(const QPoint &p);
    void setWatchWindowVisible();
    void addWatchItem();
    void deleteWatchItem();
    void shareOnlineSlot();
};
#endif // MAINWINDOW_H
