#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2011 Boris Pohler <boris@pohlers-web.de>

# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.


# Importe
import sip
sip.setapi('QDate', 2)
import sys
import os
import csv
import pickle
import shutil
import dbus
from collections import defaultdict
from PyQt4.uic import loadUi
from PyQt4.QtGui import QMainWindow, QApplication, QInputDialog, QMenu, \
                        QCursor, QMessageBox, QDialog
from PyQt4.QtCore import QObject, QString, QTimer, QTime, Qt, QDate
from PyQt4.QtMaemo5 import *
reload(sys)
sys.setdefaultencoding('utf-8')


# veraltet, ursprünglicher Entwurf sah nur Gesamtzeit vor
class Zeitkonto():
    def __init__(self, name = "Projekt"):
        self.name = name
        self.zeit = 0

#neue, aktuelle Klasse
class Zeitkonto1():
    def __init__(self, name = QString("Projekt")):
        self.name = QString(name)
        self.gesamtzeit = 0
        self.zeiten = defaultdict(list)

    def setze_zeit(self,datum,anfangszeit,endzeit):
        if datum in self.zeiten:
            self.zeiten[datum].append([anfangszeit,endzeit])
        else:
            self.zeiten[datum]= [[anfangszeit,endzeit]]

class Dialog_Zeit(QDialog):
    def __init__(self,parent):
        QDialog.__init__(self,parent=None)
        self.ui = loadUi("dialog_zeit.ui")
        #self.ui.show()

class Fenster_Zeitkonto(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self)
        # Oberfläche abbilden     
        self.ui = loadUi("zeitkonto.ui")
        self.ui.show()
 
        self.zeitkonten_liste= [Zeitkonto1()]
       
        if os.path.isfile("/home/user/MyDocs/.zeitkonto/zeitkonten.db"):
           self.erster_start = False
        else:
           os.makedirs("/home/user/MyDocs/.zeitkonto")
           self.erster_start = True
           self.liste_speichern()

        self.liste_laden()
        self.anzeige_aktualisieren()

        if os.path.isfile("/home/user/MyDocs/.zeitkonto/warnung_gezeigt") or self.erster_start:
            pass
        else:
            warnung_gezeigt = open("/home/user/MyDocs/.zeitkonto/warnung_gezeigt","w")
            warnung_gezeigt.close()
            # Sicherheitskopie, falls doch was schief geht
            shutil.copyfile("/home/user/MyDocs/.zeitkonto/zeitkonten.db",
                            "/home/user/MyDocs/.zeitkonto/zeitkonten.db.bak")
            # Konvertierung der alten Liste in die neue
            neue_liste = []
            for konto in self.zeitkonten_liste:
                neues_konto = Zeitkonto1(konto.name)
                neues_konto.gesamtzeit = konto.zeit
                neue_liste.append(neues_konto)
            self.zeitkonten_liste = neue_liste
            self.liste_speichern()
            nachricht="Auf mehrfachen Wunsch werden nun die Start- und Stopp-Zeiten\
 gespeichert. Über eine Export-Funktion kann man sich nun diese Zeiten als csv-Datei ausgeben\
 lassen. Dazu mussten allerdings die alten Daten konvertiert werden.\
 Sollten dabei Problem aufgetreten sein, nehmt bitte Kontakt mit mir auf.\
 Eine Backup-Datei eurer Daten findet ihr in /Mydocs/.zeitkonto/"
            self.show_notification_dialog(nachricht,"multiline")
            
        # zum Anzeigen aktualisieren
        self.timer = QTimer()
        self.timer.setInterval(500)
        # um die Zeit zu stoppen
        self.zeit = QTime()
        # um das Datum eintragen zu können
        self.datum = QDate()

        self.zeit0 = 0

        self.ui.listWidget.setContextMenuPolicy(Qt.CustomContextMenu)
	self.ui.listWidget.currentRowChanged.connect(self.auswahl_geaendert)
        self.ui.listWidget.customContextMenuRequested.connect(self.zeigeKontextMenu)
        self.ui.knopf_start.clicked.connect(self.timer_starten)
        self.ui.knopf_stopp.clicked.connect(self.timer_stoppen)
        self.timer.timeout.connect(self.zeitanzeige_aktualisieren)
        self.ui.action_ueber.triggered.connect(self.zeige_ueber)       


    def zeigeKontextMenu(self):
        menu = QMenu()
        menu.addAction(u'Konto hinzufügen')
        menu.addAction(u'Konto löschen')
        menu.addAction(u'Zeit bearbeiten')
        menu.addAction(u'Kontoname bearbeiten')
        menu.addAction(u'CSV-Export')
	pos = QCursor.pos()
        id = menu.exec_(pos)
  
        if id and id.text() == u'Konto hinzufügen':
            self.zeitkonto_anlegen()
        if id and id.text() == u'Konto löschen':
            self.zeitkonto_loeschen()
        if id and id.text() == u'Kontoname bearbeiten':
            self.konto_name_bearbeiten()
        if id and id.text() == u'Zeit bearbeiten':
            self.konto_zeit_bearbeiten()
        if id and id.text() == u'CSV-Export':
            self.csv_exportieren()

    def timer_starten(self):
        self.ui.listWidget.hide()
        self.ui.label_2.hide()
        self.zeit.start()
        self.startzeit=self.zeit.currentTime()
        self.timer.start()
        self.ui.knopf_start.setEnabled(False)

    def timer_stoppen(self):
        self.ui.listWidget.show()
        self.ui.label_2.show()
        timestring = self.ui.label_zeit.text().split(QString(':'))
        zeit0 = int(timestring[0])*3600000 \
              + int(timestring[1])*60000 \
              + int(timestring[2])*1000
        self.konto.gesamtzeit = zeit0
        self.konto.setze_zeit(self.datum.currentDate(),
                              self.startzeit,
                              self.zeit.currentTime())
        self.ui.knopf_start.setEnabled(True)
        self.timer.stop()
        self.liste_speichern()

    def msec_to_h_min_sec(self,zeit):
        msecs=zeit
	msecs /= 1000
        sec = msecs % 60
        msecs /= 60
        min = msecs % 60
        msecs /= 60
        hours = msecs
        return hours,min,sec
    
    def zeitanzeige_aktualisieren(self):
        msecs = self.konto.gesamtzeit + self.zeit.elapsed()
        hours, min, sec = self.msec_to_h_min_sec(msecs)
        timestring = '%02d:%02d:%02d' % (hours, min, sec)
        self.ui.label_zeit.setText(timestring)

    def anzeige_aktualisieren(self):
        self.ui.listWidget.clear()
        for konto in self.zeitkonten_liste:
            self.ui.listWidget.addItem(konto.name)

    def auswahl_geaendert(self, zeile):
        if self.zeitkonten_liste:
            self.zeile = zeile
            self.konto = self.zeitkonten_liste[zeile]
            self.zeit0 = self.konto.gesamtzeit
            hours, min, sec = self.msec_to_h_min_sec(self.zeit0)
            timestring = '%02d:%02d:%02d' % (hours, min, sec)
            self.ui.label_zeit.setText(timestring)
            self.ui.label_name.setText(self.konto.name)
        else:
            self.ui.label_zeit.setText("00:00:00")
            self.ui.label_name.setText("")
        
    def zeitkonto_anlegen(self):
        text, ok = QInputDialog.getText(self, u'Zeitkonto anlegen', 
                                              u'Gib dem Konto einen Namen:')
        if ok:
            konto = Zeitkonto1(text)
            self.zeitkonten_liste.append(konto)
            self.anzeige_aktualisieren()
            self.liste_speichern()

    def zeitkonto_loeschen(self):
        reply = QMessageBox.question(self, u"Achtung!",
                                           u"Wollen sie das Konto wirklich löschen?",
                                           QMessageBox.No | QMessageBox.Yes)
        if reply == QMessageBox.Yes:
            del self.zeitkonten_liste[self.zeile]
            self.anzeige_aktualisieren()
            self.liste_speichern()

    def konto_name_bearbeiten(self):
        text, ok = QInputDialog.getText(self, u'Name ändern', 
                                              u'Gib den neuen Namen ein:')
        if ok:
            self.zeitkonten_liste[self.zeile].name = text
            self.anzeige_aktualisieren()
            self.liste_speichern()

    def konto_zeit_bearbeiten(self):
        self.dialog = QDialog(self)
        self.dialog.ui = loadUi("dialog_zeit.ui") 
	if self.dialog.ui.exec_() == 1:
           stunden = self.dialog.ui.stunden.value()
           minuten = self.dialog.ui.minuten.value()
           sekunden = self.dialog.ui.sekunden.value()
           self.konto.gesamtzeit = stunden * 3600000 \
                           + minuten * 60000 \
                           + sekunden * 1000
           self.zeit0 = self.konto.gesamtzeit
           hours, min, sec = self.msec_to_h_min_sec(self.zeit0)
           timestring = '%02d:%02d:%02d' % (hours, min, sec)
           self.ui.label_zeit.setText(timestring)
           self.liste_speichern()

    def csv_exportieren(self):
        # Ausgabedatei öffnen
        #print type(self.konto.name), self.konto.name 
        datei_aus = csv.writer(open('/home/user/MyDocs/'+ self.konto.name +'.csv', 'wb'), delimiter=';')
        datei_aus.writerow([self.konto.name])
        datei_aus.writerow('')
        hours, min, sec = self.msec_to_h_min_sec(self.konto.gesamtzeit)
        datei_aus.writerow(['Gesamtzeit','%02d:%02d:%02d' % (hours, min, sec)])
        
        for tag in sorted(self.konto.zeiten.keys()):
            datei_aus.writerow('')
            datei_aus.writerow([tag.toString('dd.MM.yyyy'),'Startzeit','Endzeit','Zeitdifferenz'])
            for zeiten in self.konto.zeiten[tag]:
                differenz = int(round(zeiten[0].msecsTo(zeiten[1]),-3))
                print zeiten[0],zeiten[1], differenz
                if differenz < 0:
                    differenz = 24*60*60*1000 + differenz
                hours, min, sec = self.msec_to_h_min_sec(differenz)
                datei_aus.writerow(['',zeiten[0].toString('hh:mm:ss'),
                                       zeiten[1].toString('hh:mm:ss'),
                                       '%02d:%02d:%02d' % (hours, min, sec)])
        self.show_notification_dialog("Daten von %s nach '%s.csv' in MyDocs exportiert" 
                                  % (self.konto.name,self.konto.name),"multiline")
                      

    def liste_laden(self):
        f = open("/home/user/MyDocs/.zeitkonto/zeitkonten.db",'r')
   	self.zeitkonten_liste = pickle.load(f)
        f.close()
    
    def liste_speichern(self):
        f = open("/home/user/MyDocs/.zeitkonto/zeitkonten.db",'w')
   	pickle.dump(self.zeitkonten_liste,f)
        f.close()

    def zeige_ueber(self):
        QMessageBox.about(self, 
                          u"Über das Programm",u"""<b>Zeitkonten</b>
                          <p>Das Programm bietet die Möglichkeit, Zeitkonten für
                             verschiedene Aufgaben anzulegen und die verwendete Zeit
                             dafür zu stoppen + einer Exportfunktion.
                          <p>Mit einem langen Druck auf die Liste öffnet sich ein Menü.
                          <p> Lob/Kritik/Spendenanfragen ;) an:
                          <p>boris@pohlers-web.de""")

    def show_notification_dialog(self, message, mode="single"):
        '''
        provides notification dialog
        '''
        bus = dbus.SystemBus()
        iface = dbus.Interface(bus.get_object('org.freedesktop.Notifications',
                                        '/org/freedesktop/Notifications'),
                                        'org.freedesktop.Notifications')
        if mode == "single":
            iface.SystemNoteInfoprint(message)
        elif mode == "multiline":
            iface.SystemNoteDialog(str(message), dbus.UInt32(0), 'Ok')

# Starten des Programms
if __name__=="__main__":
    # Qt-Umgebung erzeugen
    app=QApplication(sys.argv)
    # ein Objekt mit dem Namen fenster aus unserer Klasse
    # Minimalbeispiel erzeugen
    fenster=Fenster_Zeitkonto()
    # Programmende
    sys.exit(app.exec_())


