# -.- coding: utf-8 -.-

# Zeitgeist - Geolocation Extension
#
# Copyright © 2010 Markus Korn <thekorn@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import location
import gobject
from _geolocation_base import GeolocationBaseClass

def start_location(control):
    print "START GEO LOCATION GPS"
    control.start()
    return False

class Geolocation(GeolocationBaseClass):
    """
    Implementation of the Geolocation extension for systems with liblocation installed
    """

    def __init__ (self, engine):
        GeolocationBaseClass.__init__(self, engine)
        
        self.control = location.GPSDControl.get_default()
        self.device = location.GPSDevice()
        self.control.set_properties(
            preferred_method=location.METHOD_USER_SELECTED,
            preferred_interval=location.INTERVAL_DEFAULT)
            
        self.device.connect("changed", self.on_changed, self.control)
        gobject.idle_add(start_location, self.control)
        
    def on_changed(self, device, data):
        if not device:
            return
        if device.fix:
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                print "lat = %f, long = %f" % device.fix[4:6]
                self._position = device.fix[4:6]
