# -.- coding: utf-8 -.-

# Zeitgeist - Geolocation Extension
#
# Copyright © 2010 Seif Lotfy <seif@lotfy.com>
# Copyright © 2010 Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
# Copyright © 2010 Markus Korn <thekorn@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import Geoclue
from _geolocation_base import GeolocationBaseClass

class Geolocation(GeolocationBaseClass):
    """
    Implementation of the geolocation extension using geoclue
    """

    def __init__ (self, engine):
        GeolocationBaseClass.__init__(self, engine)

        self._location = Geoclue.DiscoverLocation()
        self._location.init()
        self._location.connect(self._position_changed_cb)
        
        # Choose a working provider
        # FIXME: Use the Master provider once it is released
        for provider in [provider["name"] for provider in self._location.get_available_providers()]:
            if self._location.set_position_provider(provider) and self._get_position():
                break
    
    def _get_position(self):
        position = self._location.get_location_info()
        if "longitude" in position and "latitude" in position and \
        position["longitude"] != 0 and position["latitude"] != 0:
            return (position["longitude"], position["latitude"])
        return None
    
    def _position_changed_cb(self):
        self._position = self._get_position()
