/*
 * xrick/data/dat_tiles.c
 *
 * Copyright (C) 1998-2002 BigOrno (bigorno@bigorno.net). All rights reserved.
 *
 * The use and distribution terms for this software are contained in the file
 * named README, which can be found in the root of this distribution. By
 * using this software in any fashion, you are agreeing to be bound by the
 * terms of this license.
 *
 * You must not remove this notice, or any other, from this software.
 */

#include "config.h"

#ifdef GFXST

#include "system.h"
#include "tiles.h"

tile_t tiles_data[TILES_NBR_BANKS][0x100] = {
  { /* BANK 0 */
    { /* 0x11 */
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
    },
    { /* 0x0a */
      0x000cdc00,
      0x000dfd00,
      0x000dfd00,
      0x000dfd00,
      0x000dfd00,
      0x000cec00,
      0x000dfd00,
      0000000000,
    },
    { /* 0x0b */
      0x000cd000,
      0x0091b190,
      0x00ab3ba0,
      0x0091b190,
      0x0091b190,
      0x00ab3ba0,
      0x0091b190,
      0000000000,
    },
    { /* 0x0c */
      0x009aba90,
      0x0aaaaaaa,
      0x003afa30,
      0x09a333a9,
      0x0a9cdc9a,
      0x039a9a93,
      0x0ced0dec,
      0000000000,
    },
    { /* 0x0d */
      0xcc0000cc,
      0xcc0000cc,
      0xcc4004cc,
      0xcccccccc,
      0xcccccccc,
      0xcc4004cc,
      0xcc0000cc,
      0xcc0000cc,
    },
    { /* 0x10 */
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0xcccccccc,
      0xcccccccc,
      0xcccccccc,
    },
    { /* 0x0f */
      0xcccccccc,
      0xcccccccc,
      0xcccccccc,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
    },
    { /* 0x12 */
      0x44444444,
      0x46f666ff,
      0x4666f66f,
      0x466666ff,
      0x4f6fffff,
      0x4666f6f6,
      0x466f6fff,
      0x466666f6,
    },
    { /* 0x13 */
      0x44444444,
      0xfffffff6,
      0x6fff6fff,
      0xfff6ff6f,
      0xfffffff6,
      0xffffffff,
      0xff6ff6ff,
      0xffffff6f,
    },
    { /* 0x14 */
      0x44444444,
      0x66666666,
      0xffff6f6f,
      0x6f66f666,
      0xf6666666,
      0x6ff6f666,
      0xf66f6666,
      0x66666666,
    },
    { /* 0x15 */
      0x44444444,
      0x66666666,
      0x66666666,
      0x66666666,
      0x66644444,
      0x664deddd,
      0x66444404,
      0x66cecc00,
    },
    { /* 0x16 */
      0x44444444,
      0x66666666,
      0x66666666,
      0x66666666,
      0x44446666,
      0xddcc4666,
      0x44444566,
      0x4cecc566,
    },
    { /* 0x17 */
      0x44444444,
      0x66666664,
      0x66666664,
      0x6666f6f4,
      0xf6fffff4,
      0x6666f6f4,
      0x66666664,
      0x66666664,
    },
    { /* 0x18 */
      0x46666666,
      0x4666666f,
      0x46566656,
      0x45656565,
      0x46544455,
      0x45477747,
      0x4577cc74,
      0x4477c777,
    },
    { /* 0x19 */
      0x666ff666,
      0x6f666666,
      0x56656565,
      0x65665cc5,
      0x5555cdc4,
      0x5544cddc,
      0x477774cc,
      0x4c774c44,
    },
    { /* 0x1a */
      0x66666666,
      0x66666664,
      0x6565654d,
      0x565664ed,
      0x556444dc,
      0x444ff847,
      0x48f84788,
      0x74788478,
    },
    { /* 0x1b */
      0x44444444,
      0xeedddddd,
      0xcccccccc,
      0xdddddddd,
      0xcccccccc,
      0x4ddddddd,
      0x7ccccccc,
      0x4d4444dd,
    },
    { /* 0x1c */
      0x44444445,
      0xddddddc4,
      0xcccccc40,
      0xdddddddc,
      0xcccccc44,
      0xdddddddc,
      0xcccc4444,
      0xddddd4f8,
    },
    { /* 0x1d */
      0x66666664,
      0x56666664,
      0x45565654,
      0xc4444464,
      0x04848f44,
      0x48787884,
      0x8f878f74,
      0x78777874,
    },
    { /* 0x1e */
      0x44447474,
      0x48844777,
      0x4cc88477,
      0x488c8844,
      0x4877c444,
      0x478878f8,
      0x4ff87778,
      0x48778f87,
    },
    { /* 0x1f */
      0x77774474,
      0x74477744,
      0x4474747c,
      0xc4744744,
      0x447884cf,
      0x4444f878,
      0x84848777,
      0x8488777f,
    },
    { /* 0x20 */
      0x77448884,
      0x44887784,
      0x48f77f88,
      0x4787f877,
      0xf778f788,
      0x84777c77,
      0x787c7874,
      0x874c7744,
    },
    { /* 0x21 */
      0xc48884cc,
      0x48f74cc4,
      0x78744447,
      0x778f8478,
      0x78777848,
      0x77878444,
      0x47787787,
      0x44878778,
    },
    { /* 0x22 */
      0x4ccc4787,
      0x74cc4844,
      0x87444440,
      0x77474074,
      0x44447474,
      0x74774c47,
      0x44447777,
      0x74844748,
    },
    { /* 0x23 */
      0x878788c4,
      0x48f87c84,
      0x44878874,
      0x77478784,
      0x74487774,
      0x47448784,
      0x87747784,
      0x78788774,
    },
    { /* 0x24 */
      0x47f87788,
      0x47877878,
      0x48778f77,
      0x47887f77,
      0x4877787c,
      0x48878787,
      0x48788788,
      0x47778778,
    },
    { /* 0x25 */
      0x48778f87,
      0x78887878,
      0x77878777,
      0xc8787788,
      0x87887887,
      0x777f7878,
      0x77887787,
      0x87878c88,
    },
    { /* 0x26 */
      0x788878f7,
      0x88778787,
      0x87787878,
      0x788787f8,
      0x77878787,
      0x88787878,
      0x87787787,
      0x78778878,
    },
    { /* 0x27 */
      0x48787877,
      0x87788788,
      0x78777777,
      0x77787877,
      0x788f8778,
      0x877877f8,
      0x87878787,
      0x78787777,
    },
    { /* 0x28 */
      0x78788477,
      0x77778788,
      0x78877878,
      0x87887887,
      0x78778778,
      0x87787878,
      0x87887887,
      0x87877778,
    },
    { /* 0x29 */
      0x87877874,
      0x78788784,
      0x78787874,
      0x87887784,
      0x78778874,
      0x77788784,
      0x87777874,
      0x97888774,
    },
    { /* 0x2a */
      0x48787887,
      0x47887878,
      0x48778787,
      0x47878887,
      0x48787787,
      0x47888877,
      0x47787774,
      0x44099044,
    },
    { /* 0x2b */
      0x88787887,
      0x77888778,
      0x88887777,
      0x78774eed,
      0x8774cfee,
      0x7774cfee,
      0x4774cefe,
      0x7404cdee,
    },
    { /* 0x2c */
      0x87887788,
      0x87887878,
      0x78879887,
      0xd4777977,
      0xdd477978,
      0xdd477777,
      0xdd474797,
      0xec444744,
    },
    { /* 0x2d */
      0x87878887,
      0x4c478778,
      0xced47887,
      0x4fed7778,
      0x74edd478,
      0x7cdced47,
      0x4dcec4c4,
      0xccecdc47,
    },
    { /* 0x2e */
      0x78777878,
      0x87878887,
      0x78777789,
      0x87987777,
      0x7997777a,
      0x77974789,
      0x49997474,
      0x87447979,
    },
    { /* 0x2f */
      0x89877884,
      0x88788784,
      0x77448474,
      0x47774784,
      0x77488844,
      0x47847784,
      0x79797794,
      0x79977904,
    },
    { /* 0x30 */
      0x47040407,
      0x47090707,
      0x47090707,
      0x47000707,
      0x49adcdec,
      0x4aba9cce,
      0x499aa9aa,
      0x44444444,
    },
    { /* 0x31 */
      0x4480cdfe,
      0x780cdfee,
      0xc8ceefee,
      0xeced99ee,
      0xce99aaa9,
      0xe9aabbaa,
      0x994b449a,
      0x44444444,
    },
    { /* 0x32 */
      0xec4474cc,
      0xec409cdd,
      0xec40cdef,
      0xc44ddefe,
      0x40de40ed,
      0xa0dd00dc,
      0xa94449aa,
      0x44444444,
    },
    { /* 0x33 */
      0xddcdc477,
      0xfddc4999,
      0xedc44444,
      0xdc490994,
      0xc4907090,
      0x47007007,
      0x9944749a,
      0x44444444,
    },
    { /* 0x34 */
      0x99094994,
      0x70709904,
      0x90707070,
      0x40709070,
      0x00709070,
      0x70700070,
      0xa94449aa,
      0x44444444,
    },
    { /* 0x35 */
      0x47449074,
      0x49749074,
      0x47990074,
      0x49007074,
      0x44707074,
      0x00707074,
      0xa94449a4,
      0x44444444,
    },
    { /* 0x0e */
      0xcccccccc,
      0xcc4004cc,
      0xcc0000cc,
      0xcc0000cc,
      0xcc0000cc,
      0xcc0000cc,
      0xcc4004cc,
      0xcccccccc,
    },
{ /* 0x5b */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0x000ff000,
  0x000fe000,
  0x00fec000,
},
{ /* 0x5e */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x5c */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0x00ffd000,
  0x00ffc000,
  0000000000,
},
{ /* 0x5f */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
    { /* 0000 */
      0x0ceffec0,
      0x0ef00fe0,
      0x0ff00ff0,
      0x0ff00ff0,
      0x0ff00ff0,
      0x0ef00fe0,
      0x0ceffec0,
      0000000000,
    },
    { /* 0x01 */
      0x00cff000,
      0x00eff000,
      0x000ff000,
      0x000ff000,
      0x000ff000,
      0x000ff000,
      0x00effe00,
      0000000000,
    },
    { /* 0x02 */
      0x0ceffec0,
      0x0efc0fe0,
      0x0000cfe0,
      0x000cfec0,
      0x00cfec00,
      0x0cfec0e0,
      0x0ffffff0,
      0000000000,
    },
    { /* 0x03 */
      0x0ceffec0,
      0x0efc0fe0,
      0x00000fe0,
      0x000effc0,
      0x00000fe0,
      0x0efc0fe0,
      0x0ceffec0,
      0000000000,
    },
    { /* 0x04 */
      0x00cfff00,
      0x0cffff00,
      0xcfe0ff00,
      0xff00ff00,
      0xffffffe0,
      0x0000ff00,
      0x000effe0,
      0000000000,
    },
    { /* 0x05 */
      0x0ffffff0,
      0x0ff00ce0,
      0x0ff00000,
      0x0fffffc0,
      0x00000fe0,
      0x0efc0fe0,
      0x0ceffec0,
      0000000000,
    },
    { /* 0x06 */
      0x00cefe00,
      0x0cefc000,
      0x0efc0000,
      0x0ffffec0,
      0x0ff00fe0,
      0x0ef00fe0,
      0x0ceffec0,
      0000000000,
    },
    { /* 0x07 */
      0x0ffffff0,
      0x0ec0cff0,
      0x000cefc0,
      0x000efc00,
      0x000ff000,
      0x000ff000,
      0x00effe00,
      0000000000,
    },
    { /* 0x08 */
      0x0ceffec0,
      0x0ef00fe0,
      0x0ef00fe0,
      0x0cffffc0,
      0x0ef00fe0,
      0x0ef00fe0,
      0x0ceffec0,
      0000000000,
    },
    { /* 0x09 */
      0x0ceffec0,
      0x0ef00fe0,
      0x0ef00ff0,
      0x0ceffff0,
      0x0000cfe0,
      0x000cfec0,
      0x00efec00,
      0000000000,
    },
    { /* 0x38 */
      0xeffffffe,
      0xcddddddc,
      0x04444440,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
    },
    { /* 0x39 */
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0x91111119,
      0000000000,
    },

    { /* 0x36 */
      0x004d0000,
      0x04df0000,
      0x4dfffff0,
      0xdffffff0,
      0x4dfffff0,
      0x04df0000,
      0x004d0000,
      0000000000,
    },
    { /* 0x3c */
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0x00019000,
      0x00019000,
      0000000000,
    },
    { /* 0x3d */
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
    },
{ /* 0x5d */
  0x0ceffec0,
  0x0efc0fe0,
  0x0000cfe0,
  0x000cfec0,
  0x000efc00,
  0000000000,
  0x000ffc00,
  0000000000,
},
    { /* 0x40 */
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
    },
    { /* 0x41 */
      0x000efe00,
      0x00cfffc0,
      0x00ef0fe0,
      0x00ff0ff0,
      0x0cfffffc,
      0x0ef000fe,
      0x0ff000ff,
      0000000000,
    },
    { /* 0x42 */
      0x0ffffec0,
      0x0ff00fe0,
      0x0ff00fe0,
      0x0fffffc0,
      0x0ff00fe0,
      0x0ff00fe0,
      0x0ffffec0,
      0000000000,
    },
    { /* 0x43 */
      0x0ceffec0,
      0x0efc0fe0,
      0x0ff00000,
      0x0ff00000,
      0x0ff00000,
      0x0efc0fe0,
      0x0ceffec0,
      0000000000,
    },
    { /* 0x44 */
      0x0ffffec0,
      0x0ff0cfe0,
      0x0ff00ff0,
      0x0ff00ff0,
      0x0ff00ff0,
      0x0ff0cfe0,
      0x0ffffec0,
      0000000000,
    },
    { /* 0x45 */
      0x0ffffff0,
  0x0ff00ce0,
  0x0ff00000,
  0x0ffffe00,
  0x0ff00000,
  0x0ff00ce0,
  0x0ffffff0,
  0000000000,
},
{ /* 0x46 */
  0x0ffffff0,
  0x0ff00ce0,
  0x0ff00000,
  0x0ffffe00,
  0x0ff00000,
  0x0ff00000,
  0x0ff00000,
  0000000000,
},
{ /* 0x47 */
  0x0ceffec0,
  0x0efc0fe0,
  0x0ff00000,
  0x0ff00000,
  0x0ff0eff0,
  0x0efc0fe0,
  0x0ceffec0,
  0000000000,
},
{ /* 0x48 */
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ffffff0,
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ff00ff0,
  0000000000,
},
{ /* 0x49 */
  0x00effe00,
  0x000ff000,
  0x000ff000,
  0x000ff000,
  0x000ff000,
  0x000ff000,
  0x00effe00,
  0000000000,
},
{ /* 0x4a */
  0x00effe00,
  0x000ff000,
  0x000ff000,
  0x000ff000,
  0x000ff000,
  0x00cfe000,
  0x0dfec000,
  0000000000,
},
{ /* 0x4b */
  0x0ff0dffc,
  0x0ffdffc0,
  0x0ffffc00,
  0x0fffc000,
  0x0ffffc00,
  0x0ffdffc0,
  0x0ff0dffc,
  0000000000,
},
{ /* 0x4c */
  0x0ffe0000,
  0x0ffc0000,
  0x0ff00000,
  0x0ff00000,
  0x0ff00000,
  0x0ff00ce0,
  0x0ffffff0,
  0000000000,
},
{ /* 0x4d */
  0x0fec0cef,
  0x0ffeceff,
  0x0fffefff,
  0x0ffcfcff,
  0x0ff0c0ff,
  0x0ff000ff,
  0x0ff000ff,
  0000000000,
},
{ /* 0x4e */
  0x0fd00ef0,
  0x0ffd0ff0,
  0x0fffdff0,
  0x0ffffff0,
  0x0ffdfff0,
  0x0ff0dff0,
  0x0fe00df0,
  0000000000,
},
{ /* 0x4f */
  0x0ceffec0,
  0x0ef00fe0,
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ef00fe0,
  0x0ceffec0,
  0000000000,
},
{ /* 0x50 */
  0x0ffffec0,
  0x0ff00fe0,
  0x0ff00fe0,
  0x0fffffc0,
  0x0ff00000,
  0x0ff00000,
  0x0ff00000,
  0000000000,
},
{ /* 0x51 */
  0x0ceffec0,
  0x0ef00fe0,
  0x0ff00ff0,
  0x0ff0dff0,
  0x0ff0fdf0,
  0x0ef0cfc0,
  0x0ceffcf0,
  0000000000,
},
{ /* 0x52 */
  0x0ffffec0,
  0x0ff00fe0,
  0x0ff00fe0,
  0x0fffffc0,
  0x0ffffc00,
  0x0ffdffc0,
  0x0ff0dffc,
  0000000000,
},
{ /* 0x53 */
  0x0ceffec0,
  0x0ef00fe0,
  0x0efc0000,
  0x0ceffec0,
  0x0000cfe0,
  0x0ef00fe0,
  0x0ceffec0,
  0000000000,
},
{ /* 0x54 */
  0x0ffffff0,
  0x0ecffce0,
  0x000ff000,
  0x000ff000,
  0x000ff000,
  0x000ff000,
  0x00effe00,
  0000000000,
},
{ /* 0x55 */
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ff00ff0,
  0x0ef00fe0,
  0x0ceffec0,
  0000000000,
},
{ /* 0x56 */
  0x0ff000ff,
  0x0ff000ff,
  0x0ef000fe,
  0x0cff0ffc,
  0x00ef0fe0,
  0x00cfffc0,
  0x000efe00,
  0000000000,
},
{ /* 0x57 */
  0x0ff000ff,
  0x0ff000ff,
  0x0ff0c0ff,
  0x0ffcfcff,
  0x0fffefff,
  0x0ffeceff,
  0x0fec0cef,
  0000000000,
},
{ /* 0x58 */
  0x0ff00ff0,
  0x0efccfe0,
  0x0cfeefc0,
  0x00cffc00,
  0x0cfeefc0,
  0x0efccfe0,
  0x0ff00ff0,
  0000000000,
},
{ /* 0x59 */
  0x0fe00ef0,
  0x0ef00fe0,
  0x0cffffc0,
  0x00cffc00,
  0x000ff000,
  0x000ff000,
  0x00effe00,
  0000000000,
},
{ /* 0x5a */
  0x0ffffff0,
  0x0ec0cff0,
  0x000cffc0,
  0x00cffc00,
  0x0cffc000,
  0x0ffc0ce0,
  0x0ffffff0,
  0000000000,
},
{ /* 0x60 */
  0x44444444,
  0x46666666,
  0x466f6fff,
  0x46666666,
  0x46666666,
  0x46666666,
  0x4f6fffff,
  0x4ffff6f6,
},
{ /* 0x61 */
  0x44444444,
  0x6666f6f6,
  0xffff6fff,
  0xf6ffffff,
  0x666f6fff,
  0x66666666,
  0xff6fff66,
  0x66666666,
},
{ /* 0x62 */
  0x44444444,
  0x666f6f66,
  0xfff6f6f6,
  0xffffffff,
  0xffff6f6f,
  0x66666666,
  0x66666666,
  0x66666666,
},
{ /* 0x63 */
  0x44444444,
  0x66666666,
  0x66666666,
  0xf6ff6f66,
  0x66666666,
  0x66666666,
  0x66666666,
  0x66666ff6,
},
{ /* 0x64 */
  0x44444444,
  0x6666666f,
  0x66666666,
  0x66666666,
  0x66666666,
  0x66633333,
  0x6663bbbb,
  0xffffa999,
},
{ /* 0x65 */
  0x44444444,
  0xfffffff4,
  0x66fff664,
  0x66666664,
  0x66666664,
  0x33333334,
  0xbbbbbbb4,
  0x99999994,
},
{ /* 0x66 */
  0x46666666,
  0x46666666,
  0x46666666,
  0x46666666,
  0x46666669,
  0x4565659a,
  0x465659a3,
  0x45659b9a,
},
{ /* 0x67 */
  0x66666666,
  0x66666666,
  0x69966666,
  0x9a996666,
  0x3ba99966,
  0xbaaa9996,
  0xb999a999,
  0xb9aa9a9a,
},
{ /* 0x68 */
  0x666666aa,
  0x66666a33,
  0x6666af3a,
  0x666a3aaa,
  0x66af3333,
  0x6afabaaa,
  0xa33a3aaa,
  0x33bbb33b,
},
{ /* 0x69 */
  0x66666666,
  0xa6666666,
  0xba966666,
  0xaaa96666,
  0xbbba9666,
  0xabbba956,
  0xaaaaaa95,
  0xbbabbba9,
},
{ /* 0x6a */
  0x66fff6ba,
  0x666666ba,
  0x66666666,
  0x66666666,
  0x66666666,
  0x56565556,
  0x65656555,
  0x95555555,
},
{ /* 0x6b */
  0xaaaa22a4,
  0xa22aaa24,
  0x99999994,
  0xbaaaaaa4,
  0xbaaaaaa4,
  0x59999994,
  0x65ba9aa4,
  0x553a9ba4,
},
{ /* 0x6c */
  0x4659a3b9,
  0x459abbbb,
  0x4939999a,
  0x4abaabba,
  0x499b9999,
  0x4bbbaaaa,
  0x49999999,
  0x4aaaaa9a,
},
{ /* 0x6d */
  0x9999a9af,
  0xaaaa9a3a,
  0x99a9abf3,
  0xaa9af3a3,
  0xa9a3aaaa,
  0x9af33abb,
  0xa3ba3b3a,
  0xaaaab3ff,
},
{ /* 0x6e */
  0x3b3aabab,
  0xaaa3aaaa,
  0x3ab3b3bb,
  0xab333aba,
  0xbabab3aa,
  0xabaaabbb,
  0x33bbabab,
  0x3baab3aa,
},
{ /* 0x6f */
  0xaabbabba,
  0xaaaaaaab,
  0xabbbbaba,
  0xaababaaa,
  0xaabaaaaa,
  0xbbbbbabb,
  0xaabbabba,
  0xbaaaaaaa,
},
{ /* 0x70 */
  0x99655f87,
  0xa9958788,
  0xba99787a,
  0xaba9975b,
  0xaaba999a,
  0xaaaba999,
  0xbbabba9b,
  0xaaaaabab,
},
{ /* 0x71 */
  0x853a9ba4,
  0x77a99994,
  0x85baaaa4,
  0x573aaaa4,
  0x55baaaa4,
  0x55a99994,
  0xbb3a9ba4,
  0xaa3a9ba4,
},
{ /* 0x72 */
  0x4ff3ff3f,
  0x433f33ff,
  0x43333333,
  0x4b3b3b3b,
  0x43b3bbb3,
  0x4bbbbbbb,
  0x4bbbbbbb,
  0x4babbabb,
},
{ /* 0x73 */
  0x333fff33,
  0xffff333f,
  0x3f333333,
  0x33b333bb,
  0xbb3b3b33,
  0xbbbbbbbb,
  0xbbbbbbbb,
  0xbbbabbbb,
},
{ /* 0x74 */
  0x3f3f3fff,
  0x33333333,
  0x3333fff3,
  0x3bb333bb,
  0xb3bb333b,
  0xbbbbbbbb,
  0xbbbbbbbb,
  0xbbbbaaba,
},
{ /* 0x75 */
  0xfffff3ff,
  0x33333f33,
  0x3f33f333,
  0x3333b3bb,
  0x3bbb3b3b,
  0xbbb3bbbb,
  0xbbbbbbbb,
  0xabbaabba,
},
{ /* 0x76 */
  0xff33fffb,
  0xf3f3333a,
  0x3333333f,
  0x3b3b3bbb,
  0x3333b333,
  0xbbbbbbbb,
  0xbbbbbbbb,
  0xbbbbbbab,
},
{ /* 0x77 */
  0xaaba9aa4,
  0x99a99994,
  0xa9baaaa4,
  0x393aaaa4,
  0x39baaaa4,
  0x39a99994,
  0x393a9bb4,
  0x393a9ba4,
},
{ /* 0x78 */
  0x4ababbbb,
  0x4aaaaaaa,
  0x4aaaaaaa,
  0x4aaaaaaa,
  0x4aa9a99a,
  0x4a9a9aa9,
  0x49999999,
  0x49999999,
},
{ /* 0x79 */
  0xabababab,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x9aaa9a9a,
  0xa9a9aaa9,
  0xa99999aa,
  0x99999999,
  0x99999999,
},
{ /* 0x7a */
  0xaabaabab,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0xaa9a9aaa,
  0xa9aaaa9a,
  0x99999999,
  0x99999999,
},
{ /* 0x7b */
  0xbabbabab,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0xa9aaa9a9,
  0x9a9a9aaa,
  0xaaa9a9a9,
  0x999999a9,
  0x9999993b,
},
{ /* 0x7c */
  0xbbabbabb,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x9aaaaaa9,
  0xaaaaa993,
  0xaa99b3b9,
  0x933b999a,
  0xb9999aaa,
},
{ /* 0x7d */
  0x393a9aa4,
  0x39a94994,
  0x393aaaa4,
  0x393aaaa4,
  0xbbbaaaa4,
  0x99a99994,
  0xa9ba9ba4,
  0x9aba9aa4,
},
{ /* 0x7e */
  0x49999999,
  0x49999999,
  0x4a999999,
  0x4bbaa999,
  0x43bbbbbb,
  0x4bbbbbbb,
  0x4aaaaaaa,
  0x44444444,
},
{ /* 0x7f */
  0x99999999,
  0x99999999,
  0x99999999,
  0x99999aaa,
  0xaa9aabb3,
  0xbbbbb3bb,
  0xaaaaaaaa,
  0x44444444,
},
{ /* 0x80 */
  0x9999b333,
  0x9999aaaa,
  0x99999994,
  0xa99999aa,
  0xbbaa999a,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0x44444444,
},
{ /* 0x81 */
  0x3bb3333b,
  0xaaaaaaaa,
  0x44499449,
  0xaaaaaabb,
  0xaabbb333,
  0xbbb333bb,
  0xaaaaaaaa,
  0x44444444,
},
{ /* 0x82 */
  0x33b33bbb,
  0xaaaaaaaa,
  0x94449499,
  0xbbbaa94a,
  0x3b3bbba9,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0x44444444,
},
{ /* 0x83 */
  0x3bb3bbb4,
  0xaaaaaaa4,
  0x44944494,
  0xaaaaaaa4,
  0x99aa9aa4,
  0xbbbbbbb4,
  0xaaaaaaa4,
  0x44444444,
},
{ /* 0x84 */
  0x44444444,
  0x44efffff,
  0x44efffff,
  0x44efffff,
  0x44cfffff,
  0x444effff,
  0x444cefff,
  0x4444ceff,
},
{ /* 0x85 */
  0x44444444,
  0xffffffff,
  0xffffffff,
  0xffffffff,
  0xffffffff,
  0xfffffffe,
  0xffffffec,
  0xfffffec4,
},
{ /* 0x86 */
  0x44444444,
  0xe4444444,
  0xe4444444,
  0xe4444444,
  0xc4444444,
  0x44444444,
  0x44444444,
  0x44444444,
},
{ /* 0x87 */
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44d44444,
  0x44d44444,
},
{ /* 0x88 */
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x4444444e,
  0x44444444,
  0x44444444,
},
{ /* 0x89 */
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
},
{ /* 0x8a */
  0x444444ce,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444440,
},
{ /* 0x8b */
  0xeeeec444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
},
{ /* 0x8c */
  0x44444444,
  0x44444444,
  0x44444c44,
  0x44444c04,
  0x44444d04,
  0x4444dec4,
  0x44444d04,
  0x4444c20c,
},
{ /* 0x8d */
  0x44c44444,
  0xc4d44444,
  0xd4d4c4c4,
  0xd4d0d4c0,
  0x440404d0,
  0xc2cc4dec,
  0x444444d0,
  0xc2dc4c20,
},
{ /* 0x8e */
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x4c444444,
  0x4c444444,
},
{ /* 0x8f */
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
},
{ /* 0x90 */
  0x44444000,
  0x44440040,
  0x44400400,
  0x40000000,
  0x40000000,
  0x40000000,
  0x40000000,
  0x40000000,
},
{ /* 0x91 */
  0x04444400,
  0x00044000,
  0000000000,
  0000000000,
  0x00000004,
  0x00000004,
  0x0000044c,
  0x00044c4c,
},
{ /* 0x92 */
  0x04c4cd44,
  0x00d4cdc0,
  0x0ccc4400,
  0x4440dccc,
  0x4ccdddd4,
  0xcccd4dcc,
  0xcdd4c4c4,
  0xdc4c4c4c,
},
{ /* 0x93 */
  0xcd4c4cd4,
  0xcd4c4cdc,
  0x44444444,
  0x4ccc0044,
  0x4cc00000,
  0x444cc000,
  0xc4c40444,
  0x44444440,
},
{ /* 0x94 */
  0x4c444444,
  0x0c444444,
  0x4c404440,
  0x40c00004,
  0x04400000,
  0x00044000,
  0x00000400,
  0x00000004,
},
{ /* 0x95 */
  0x44444444,
  0x40004444,
  0x04400444,
  0x40000044,
  0x40000004,
  0x00000004,
  0x00000004,
  0x00000004,
},
{ /* 0x96 */
  0x40000000,
  0x40000000,
  0x44004404,
  0x4c040000,
  0x4e4ccccc,
  0x4d000000,
  0x4c044444,
  0x4c044440,
},
{ /* 0x97 */
  0x0044cc4c,
  0x44ccddc4,
  0xcccdcccc,
  0x4c004c40,
  0xcccccccc,
  0000000000,
  0x44444444,
  0x44044000,
},
{ /* 0x98 */
  0xc4cd4444,
  0x4cdc4404,
  0x44c40444,
  0xc0044000,
  0xe4cccccc,
  0xd0000000,
  0xc0444444,
  0xc0400400,
},
{ /* 0x99 */
  0x40444400,
  0x44444404,
  0x00040040,
  0000000000,
  0xcccccccc,
  0000000000,
  0x44444440,
  0000000000,
},
{ /* 0x9a */
  0000000000,
  0000000000,
  0x40000000,
  0xc0000000,
  0xe4cccccc,
  0xd0000000,
  0xc0444444,
  0xc0400000,
},
{ /* 0x9b */
  0x40000004,
  0x00400004,
  0x00040004,
  0x00004444,
  0xccccccc4,
  0x00000004,
  0x44444444,
  0x04000004,
},
{ /* 0x9c */
  0x4c044444,
  0x4c000444,
  0x4c044444,
  0x4c004400,
  0x4c044444,
  0x4c000444,
  0x4c044444,
  0x4c000000,
},
{ /* 0x9d */
  0x44444444,
  0x00044400,
  0x44444444,
  0000000000,
  0x44444440,
  0000000000,
  0x44444440,
  0000000000,
},
{ /* 0x9e */
  0xc0444444,
  0xc0040000,
  0xc0444444,
  0xc0000000,
  0xc0444444,
  0xc0000000,
  0xc0444444,
  0xc0000004,
},
{ /* 0x9f */
  0x44444444,
  0x00000040,
  0x44444440,
  0x00004040,
  0x44444440,
  0x04000000,
  0x44444440,
  0000000000,
},
{ /* 0xa0 */
  0xc0444444,
  0xc0404400,
  0xc0444444,
  0xc0400044,
  0xc0444444,
  0xc0000000,
  0xc0444444,
  0xc0000000,
},
{ /* 0xa1 */
  0x44444444,
  0x00000004,
  0x44444444,
  0x44000004,
  0x44444444,
  0x00000004,
  0x44444444,
  0x00000004,
},
{ /* 0xa2 */
  0x4c044444,
  0x4c000000,
  0x4c044444,
  0x4c000000,
  0x44440404,
  0x4ddcc940,
  0x4cc99cc9,
  0x44444444,
},
{ /* 0xa3 */
  0x44444440,
  0000000000,
  0x44444440,
  0000000000,
  0000000000,
  0x4c44c949,
  0xcccdcddc,
  0x44444444,
},
{ /* 0xa4 */
  0xc0444444,
  0xc0000400,
  0xc0444444,
  0xc0400000,
  0x00040004,
  0xc4494c90,
  0x9c4cc944,
  0x44444444,
},
{ /* 0xa5 */
  0x44444444,
  0000000000,
  0x44444440,
  0000000000,
  0x40000044,
  0x044449dc,
  0xc4c9dcc9,
  0x44444444,
},
{ /* 0xa6 */
  0xc0444444,
  0xc0000000,
  0xc0440000,
  0xc00044cd,
  0x40d4dcdc,
  0x4cdccdcc,
  0x94cdcdd9,
  0x44444444,
},
{ /* 0xa7 */
  0x44444444,
  0x00000004,
  0x4c400004,
  0xcc440004,
  0xccd4c404,
  0xd9cc4cc4,
  0x44c94cc4,
  0x44444444,
},
{ /* 0xa8 */
  0x44444444,
  0x40005500,
  0x40005500,
  0x4cc455cc,
  0x40005500,
  0x40006600,
  0x4665ff66,
  0x45544455,
},
{ /* 0xa9 */
  0x44444444,
  0x0c000c00,
  0x0c000c00,
  0x4ccc4ccc,
  0x01000400,
  0x00000c00,
  0x66666666,
  0x55555555,
},
{ /* 0xaa */
  0x44444444,
  0x00005500,
  0x00005500,
  0xccc455cc,
  0x01005500,
  0x00006600,
  0x6665ff66,
  0x55544455,
},
{ /* 0xab */
  0x44444444,
  0x044cdec4,
  0x0004ccde,
  0x440c44cc,
  0x000ccc44,
  0x000ccccc,
  0x650ccccc,
  0x540ccc44,
},
{ /* 0xac */
  0x44444444,
  0x44444444,
  0xc4444444,
  0xdec44444,
  0xccdec444,
  0x44ccdec4,
  0xcc444cde,
  0xcdc44444,
},
{ /* 0xad */
  0x44444444,
  0x44444444,
  0x4444c444,
  0x444cec44,
  0x4444c444,
  0x44444444,
  0xc4444444,
  0x44444444,
},
{ /* 0xae */
  0x45546655,
  0x4ccc55cc,
  0x44444444,
  0x4c444444,
  0x4c444444,
  0x4ccccccc,
  0x4ccccccc,
  0x44444444,
},
{ /* 0xaf */
  0x55555555,
  0xcccccccc,
  0x44444444,
  0x44444444,
  0x44444444,
  0xcccccccc,
  0xcccccccc,
  0x44444444,
},
{ /* 0xb0 */
  0x55546655,
  0xcccc55cc,
  0x44444444,
  0xcc444444,
  0xcc444444,
  0xcccccccc,
  0xcccccccc,
  0x44444444,
},
{ /* 0xb1 */
  0x540ccd44,
  0xc40ccddc,
  0x000ccccc,
  0xc40ccccd,
  0xc40cccdd,
  0xc40cdddd,
  0xc4444400,
  0xcccccc00,
},
{ /* 0xb2 */
  0xcdd44444,
  0xdde44444,
  0xdde4444c,
  0xdde4444c,
  0xdde444cc,
  0xdfe444cc,
  0x00044c44,
  0x40c0c440,
},
{ /* 0xb3 */
  0x44444444,
  0x44444444,
  0x44444444,
  0xc4444444,
  0xd4444444,
  0xdc444444,
  0xcdd44444,
  0xdddc4444,
},
{ /* 0xb4 */
  0x44444444,
  0x4ccccccc,
  0x49999999,
  0x49aaaaaa,
  0x49aaaaaa,
  0x49999999,
  0x44444444,
  0x40000000,
},
{ /* 0xb5 */
  0x44444444,
  0xcccccccc,
  0x99999999,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x99999999,
  0x44444444,
  0000000000,
},
{ /* 0xb6 */
  0x44444444,
  0xcccccccc,
  0x99999999,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x99999999,
  0x44444444,
  0000000000,
},
{ /* 0xb7 */
  0x44444400,
  0xcccccc00,
  0x99999900,
  0xaaaaaa00,
  0xaaaaaa00,
  0x99999900,
  0x44440000,
  0000000000,
},
{ /* 0xb8 */
  0x40c0c00c,
  0xc4d004c4,
  0xc4d0440c,
  0xc4d044cd,
  0xdce0c44c,
  0xdce94c4c,
  0xdcec90cc,
  0xdce7ccc4,
},
{ /* 0xb9 */
  0xd0dccc44,
  0xcd0cddc4,
  0xdcdc0c44,
  0x0ddddcc4,
  0xcdcdddc4,
  0xcdccdcc4,
  0xc0dddcc4,
  0xcccccc74,
},
{ /* 0xba */
  0x44cccccc,
  0x44444444,
  0x44444444,
  0x40000000,
  0x4ccccccc,
  0x44444444,
  0x44444444,
  0x40000000,
},
{ /* 0xbb */
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0xbc */
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0xbd */
  0xccccc400,
  0x44440000,
  0x44440000,
  0000000000,
  0xccccc400,
  0x44440000,
  0x44440000,
  0000000000,
},
{ /* 0xbe */
  0xdce97c7c,
  0xdce77977,
  0xdce777c7,
  0xdce97779,
  0xdce97797,
  0xdce79977,
  0xdce9979c,
  0xdce77777,
},
{ /* 0xbf */
  0xcc409994,
  0x999c7974,
  0x7979cc94,
  0xc77c7774,
  0xc77779c4,
  0x977c7774,
  0x97777794,
  0xc79c7c74,
},
{ /* 0xc0 */
  0x44cccccc,
  0x44444444,
  0x44444444,
  0x40000000,
  0x4dddcddc,
  0x4eeedefe,
  0x4edeeeee,
  0x4ddddddd,
},
{ /* 0xc1 */
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
  0xccdddddc,
  0xdeeeeeed,
  0xeeeedeee,
  0xddcccddd,
},
{ /* 0xc2 */
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
  0xcddddddd,
  0xeeeeeeef,
  0xedeeedee,
  0xddddccdc,
},
{ /* 0xc3 */
  0xccccc400,
  0x44440000,
  0x44440000,
  0000000000,
  0xdddddcdd,
  0xfeefedee,
  0xedeefeee,
  0xcccddddd,
},
{ /* 0xc4 */
  0xdce77c77,
  0xdce77777,
  0xdce77777,
  0xdce77777,
  0xdddddddd,
  0xeeefffee,
  0xdeeeeeed,
  0xddcddddd,
},
{ /* 0xc5 */
  0x77777774,
  0x77777774,
  0x77777774,
  0x77777774,
  0xdcddddd4,
  0xeeeeeee4,
  0xeeeeffe4,
  0xddddddd4,
},
{ /* 0xc6 */
  0x4ccccccc,
  0x40000000,
  0x40440004,
  0x40004404,
  0x45500004,
  0x46655000,
  0x45566665,
  0x44444444,
},
{ /* 0xc7 */
  0xcccccccc,
  0000000000,
  0x00044444,
  0x04000000,
  0x04000005,
  0x00055556,
  0x55566555,
  0x44444444,
},
{ /* 0xc8 */
  0xcccccccc,
  0000000000,
  0x40044444,
  0x00000040,
  0x56650000,
  0x65666555,
  0x55555665,
  0x44444444,
},
{ /* 0xc9 */
  0xcccccccc,
  0000000000,
  0x40444440,
  0000000000,
  0x04440000,
  0x00000055,
  0x55665556,
  0x44444444,
},
{ /* 0xca */
  0xcccccccc,
  0000000000,
  0x04044444,
  0x44000000,
  0x00556665,
  0x55565666,
  0x55555555,
  0x44444444,
},
{ /* 0xcb */
  0xccccccc4,
  0x00000004,
  0x00444404,
  0x00000404,
  0x50000404,
  0x66650004,
  0x56666554,
  0x44444444,
},
{ /* 0xcc */
  0x44444444,
  0x45555555,
  0x45555555,
  0x45555555,
  0x45555555,
  0x45dee6ff,
  0x45555555,
  0x45555e5d,
},
{ /* 0xcd */
  0x44444444,
  0x55555555,
  0x55555555,
  0x555ee555,
  0x5dffffef,
  0x6fffffff,
  0x556fffef,
  0xeffffffe,
},
{ /* 0xce */
  0x44444444,
  0x55555555,
  0x55555555,
  0xeee55555,
  0xedefeef5,
  0xfffffffe,
  0xffffefef,
  0xfffeffff,
},
{ /* 0xcf */
  0x44444444,
  0x55555555,
  0x55555555,
  0x55555555,
  0x55555e5e,
  0xffee5555,
  0xfefefffe,
  0xffffff66,
},
{ /* 0xd0 */
  0x44444444,
  0x55555c45,
  0x55554dc4,
  0x55555445,
  0x55554dc4,
  0x5555dccc,
  0xd554dccc,
  0x555dcccc,
},
{ /* 0xd1 */
  0x44444444,
  0x55555554,
  0x55555554,
  0x55555554,
  0x55555554,
  0x55555554,
  0x45555554,
  0xc5555554,
},
{ /* 0xd2 */
  0x45555555,
  0x45555555,
  0x45555555,
  0x45555555,
  0x46666666,
  0x45555555,
  0x45555555,
  0x46666666,
},
{ /* 0xd3 */
  0x555eeeee,
  0x55555555,
  0x55555555,
  0x55555555,
  0x66666666,
  0x55555555,
  0x55555555,
  0x66666666,
},
{ /* 0xd4 */
  0xddefffef,
  0x5555ee55,
  0x55555555,
  0x55555555,
  0x66666666,
  0x55555555,
  0x55555555,
  0x66666666,
},
{ /* 0xd5 */
  0xffed5555,
  0x55555555,
  0x55555555,
  0x55555555,
  0x66666666,
  0x55555555,
  0x55555555,
  0x66666666,
},
{ /* 0xd6 */
  0x54cddddd,
  0xc44c4c4c,
  0xdc4ddddd,
  0xdc4cde4d,
  0xdc4cee4e,
  0xdc4ce4de,
  0xdc4cdeed,
  0xdc4ccccc,
},
{ /* 0xd7 */
  0xdc455554,
  0x444c5554,
  0xd4dc5554,
  0xc4dc5554,
  0xc4dc6664,
  0xc4dc5554,
  0xc4dc5554,
  0xc4dc6664,
},
{ /* 0xd8 */
  0x45555555,
  0x46666666,
  0x45555555,
  0x46666666,
  0x46666666,
  0x45555555,
  0x46666666,
  0x46646666,
},
{ /* 0xd9 */
  0x55555555,
  0x66666666,
  0x55555555,
  0x66666666,
  0x66666666,
  0x55555555,
  0x66666666,
  0x46666666,
},
{ /* 0xda */
  0x55555555,
  0x66666666,
  0x55555555,
  0x66666666,
  0x66666666,
  0x55555555,
  0x66666666,
  0x66666646,
},
{ /* 0xdb */
  0x5555555c,
  0x66666666,
  0x55555555,
  0x66666666,
  0x66666666,
  0x55555555,
  0x66666666,
  0x66646666,
},
{ /* 0xdc */
  0xeddddddd,
  0xdc4c4cc4,
  0x54404444,
  0x6dc4cdcd,
  0x6dc4cdcd,
  0x5dc4cdcd,
  0x6c444c4c,
  0x6ed4cdcd,
},
{ /* 0xdd */
  0xddedc554,
  0xc4dc6664,
  0x44455554,
  0xcdc66664,
  0xcdc66664,
  0xcdc55554,
  0x4c466664,
  0xced66664,
},
{ /* 0xde */
  0x466c6666,
  0x464c6666,
  0x44cc6666,
  0x44dc4ddc,
  0x44dccddd,
  0x44dc4ccc,
  0x44dc4444,
  0x44dc44c4,
},
{ /* 0xdf */
  0xc6666666,
  0xc4666666,
  0xcc666666,
  0xdc555455,
  0xdc555c55,
  0xdc646c64,
  0xdccdd444,
  0xdc4c49aa,
},
{ /* 0xe0 */
  0x666666c6,
  0x666664c6,
  0x66666cc6,
  0x55444444,
  0x49aba9ab,
  0x4aabbabb,
  0x9222222b,
  0xaaaaaaaa,
},
{ /* 0xe1 */
  0x666c6666,
  0x666c4666,
  0x666cc666,
  0x45cdc555,
  0xa94dc555,
  0xaa4dc666,
  0x32944455,
  0xaaaaa945,
},
{ /* 0xe2 */
  0x6c444c4c,
  0x6dc4cdcd,
  0x6dc4cdcd,
  0x5dc4cdcd,
  0x5c444c4c,
  0x6ed4cdcd,
  0x5c444c4c,
  0x5dc4cdcd,
},
{ /* 0xe3 */
  0x4c466664,
  0xcdc66664,
  0xcdc66664,
  0xcdc55554,
  0x4c455554,
  0xced66664,
  0x4c455554,
  0xcdc55454,
},
{ /* 0xe4 */
  0x44dc44cc,
  0x44dc4ccc,
  0x44dc4444,
  0x44c444c4,
  0x44dc44c5,
  0x44dc4ccc,
  0x44dc4444,
  0x44c444c4,
},
{ /* 0xe5 */
  0xdc444444,
  0xdc4ccc44,
  0xdc4c4d44,
  0xc44c4449,
  0xdc4cc49a,
  0xdc4c44ab,
  0xdc4c49ab,
  0xc44c49aa,
},
{ /* 0xe6 */
  0x99999999,
  0x2a3a333a,
  0x33c2aaa2,
  0x23cdfffd,
  0x233c232c,
  0x42333333,
  0x99233233,
  0x4444cec4,
},
{ /* 0xe7 */
  0x999444cd,
  0x3a24c4cc,
  0xc3344444,
  0xc32944cc,
  0x332a94c4,
  0x324ba444,
  0x299ba94c,
  0x444aa944,
},
{ /* 0xe8 */
  0x4dc4cdcd,
  0xcdc4cdcd,
  0x4c444c4c,
  0x4ed4cdcd,
  0x4c444c4c,
  0x4dc4cdcd,
  0x4dc4cdcd,
  0x4dc4c4c4,
},
{ /* 0xe9 */
  0xcdc04cd4,
  0xcdc04dc4,
  0x4c404444,
  0xced04dc4,
  0x4c404dc4,
  0xcdc04dc4,
  0xcdc04dc4,
  0xcdc04dc4,
},
{ /* 0xea */
  0x44dc44cc,
  0x44dc4ccc,
  0x44874444,
  0x44787ccc,
  0x4878774c,
  0x47878748,
  0x47777777,
  0x44444444,
},
{ /* 0xeb */
  0xdc4c4333,
  0xdc4c4b33,
  0xdc4c44b3,
  0xc44c4444,
  0xdc474d44,
  0xdc787744,
  0x77777744,
  0x44444444,
},
{ /* 0xec */
  0x399aaaaa,
  0x39aaa9aa,
  0x299a949a,
  0x4ccec4ce,
  0x4cfec4ce,
  0xcfecc4cc,
  0xccccc4cc,
  0x44444444,
},
{ /* 0xed */
  0x99333344,
  0xa9333b4c,
  0x9923b4c4,
  0xcc4444c4,
  0xfc44c4cc,
  0xefc4c4cc,
  0xccc44778,
  0x44444444,
},
{ /* 0xee */
  0x4dc4c4c4,
  0x4dc4cdcd,
  0x4dc4cc4c,
  0xdcc4c404,
  0xdcc4c004,
  0x7cc7c044,
  0x77777777,
  0x44444444,
},
{ /* 0xef */
  0xcdc04dc4,
  0xcdc04dc4,
  0xcdc04dc4,
  0xcedc0cc4,
  0xcedc0cc4,
  0xcedc0cc4,
  0x77777774,
  0x44444444,
},
{ /* 0xf0 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf1 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf2 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf3 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf4 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf5 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf6 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf7 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf8 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xf9 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xfa */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xfb */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xfc */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xfd */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xfe */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0xff */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
    { /* 0x37 */
      0000000000,
      0x000000ff,
      0x000000fc,
      0x000000ff,
      0x000000fc,
      0x000000ff,
      0x000000cc,
      0000000000,
    },
    { /* 0x3a */
      0000000000,
      0xfe0fd0f0,
      0xcc0ff0f0,
      0xe00feff0,
      0xc00f0ef0,
      0xfe0f00f0,
      0xcc0c00c0,
      0000000000,
    },
    { /* 0x3b */
      0000000000,
      0xeffd0000,
      0xcfcf0000,
      0x0f0f0000,
      0x0f0f0000,
      0xeffd0000,
      0xccc00000,
      0000000000,
    },
    { /* 0x3e */
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
    },
    { /* 0x3f */
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
      0000000000,
    },
  },

    /* BANK 1 HAS BEEN REMOVED AS IT WAS AN EXACT COPY OF BANK 0 */

{ /* BANK 2 */
{ /* 0x328 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x329 */
  0x99999999,
  0xaa900000,
  0xaaaa22ba,
  0xaaaaaaa9,
  0xaaa9a999,
  0xaa9a99a9,
  0xa9a9a999,
  0x99999999,
},
{ /* 0x32a */
  0x00baa900,
  0x00999900,
  0xbbbbeebb,
  0xada3aaad,
  0xaaaa9ada,
  0x99999999,
  0000000000,
  0x00a9c900,
},
{ /* 0x32b */
  0x00bda900,
  0x00eaa900,
  0xb9baac0a,
  0xa9b3a909,
  0xa9ba990c,
  0x99ead909,
  0x00eadc00,
  0x00baa900,
},
{ /* 0x32c */
  0xaaaaaaa9,
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0xa9999990,
},
{ /* 0x32d */
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0xa9999990,
  0x90000000,
},
{ /* 0x32e */
  0xaaaaaaaa,
  0xa999999a,
  0xa9999991,
  0xa999999b,
  0xa999991b,
  0xa9999913,
  0xa99999b3,
  0xa9999a3f,
},
{ /* 0x32f */
  0xaaaaaaa9,
  0x99999990,
  0x99999990,
  0x99999990,
  0xa9999990,
  0x19999990,
  0xba999990,
  0x31999990,
},
{ /* 0x330 */
  0x99999009,
  0x9999099b,
  0x99909559,
  0x9909b965,
  0x99093a96,
  0x90999ba9,
  0x90956999,
  0x00999b39,
},
{ /* 0x331 */
  0x95666659,
  0xa96ff69b,
  0x3a96693a,
  0x9b9559b9,
  0x9a9999a9,
  0x996ff699,
  0x56a22a65,
  0xa553355a,
},
{ /* 0x332 */
  0x90099990,
  0xa9909990,
  0x96590990,
  0x659a9090,
  0x593a9090,
  0x9ba99900,
  0x99956900,
  0x93b99900,
},
{ /* 0x333 */
  0x09ab93a9,
  0x09999a39,
  0x956656a9,
  0x99999565,
  0x9aaa9999,
  0x9aba9a9a,
  0x9b3ba9a9,
  0x9b3ba9a9,
},
{ /* 0x334 */
  0x29833892,
  0x3333a333,
  0x23333332,
  0x93333339,
  0x992aa299,
  0xaa9339aa,
  0x569ba965,
  0xaa9659aa,
},
{ /* 0x335 */
  0x9a39ba90,
  0x93a99990,
  0x9a665659,
  0x56599999,
  0x9999aaa9,
  0xa9a9aba9,
  0x9a9ab3b9,
  0x999ab3b9,
},
{ /* 0x336 */
  0x9b33ba99,
  0x9ab3ba9a,
  0x09abaa99,
  0x09aaa9ab,
  0x099abab3,
  0xa099aaaa,
  0xa09a9999,
  0x909aa2a2,
},
{ /* 0x337 */
  0x569ba969,
  0x9a96599a,
  0x99999aab,
  0x33bbbaba,
  0x3baaaa99,
  0xaaa9999a,
  0x9a92a9a9,
  0x3f9659f3,
},
{ /* 0x338 */
  0x9a99aba9,
  0x3ba9aba9,
  0xbaa9aa90,
  0xa99aba90,
  0x99aba990,
  0xaaaa9900,
  0x9999a909,
  0x2a2aa900,
},
{ /* 0x339 */
  0xa09aa2a2,
  0x9909a2a2,
  0x900992a2,
  0x9909a9a2,
  0x9009ba99,
  0x0909933a,
  0x9009a99b,
  0x09099aba,
},
{ /* 0x33a */
  0x3f9ba9f3,
  0x3f9659f3,
  0x3f9ba9f3,
  0x3f9659f3,
  0x3f9ba9f3,
  0x99965999,
  0xba9339ab,
  0x993ff399,
},
{ /* 0x33b */
  0x2a2aa909,
  0x2a2a9090,
  0x2a299000,
  0x2a9a9090,
  0x99ab9000,
  0xa3399090,
  0xb99a9000,
  0xaba99090,
},
{ /* 0x33c */
  0x9009a999,
  0x09009a23,
  0x90909999,
  0x09009ab2,
  0x90909992,
  0x0909ba59,
  0x9093a6ba,
  0x009b5aa6,
},
{ /* 0x33d */
  0x33ffff33,
  0x3ffffff3,
  0x33333333,
  0x99999999,
  0xbb3ff3bb,
  0x99999999,
  0x5a5aa5a5,
  0xab63b6ba,
},
{ /* 0x33e */
  0x999a9000,
  0x32a90090,
  0x99990900,
  0x2ba90090,
  0x29990900,
  0x95ab9090,
  0xab6ab900,
  0x6aa5a900,
},
{ /* 0x33f */
  0000000000,
  0000000000,
  0x99000009,
  0xab90000b,
  0xfab9a9a3,
  0x00ab633b,
  0x000a3bba,
  0x000b3ba9,
},
{ /* 0x340 */
  0000000000,
  0x09abba90,
  0xab333bb9,
  0x3aa99aba,
  0xaa00093b,
  0xa900093b,
  0x90009aba,
  0x0000aba9,
},
{ /* 0x341 */
  0x99999999,
  0x99000000,
  0x90000009,
  0x90999009,
  0x90900009,
  0x90900009,
  0x90000000,
  0x90000000,
},
{ /* 0x342 */
  0x99999990,
  0000000000,
  0000000000,
  0x00099000,
  0000000000,
  0x00099900,
  0000000000,
  0000000000,
},
{ /* 0x343 */
  0x90090009,
  0x90909090,
  0x90000900,
  0x90000000,
  0x90090090,
  0x90090090,
  0x90000000,
  0000000000,
},
{ /* 0x344 */
  0x00090000,
  0x00900000,
  0x09000900,
  0000000000,
  0x09000900,
  0x09099900,
  0000000000,
  0000000000,
},
{ /* 0x345 */
  0x99999909,
  0x90000000,
  0x90000000,
  0x90000000,
  0x90000000,
  0x90000000,
  0000000000,
  0x90000000,
},
{ /* 0x346 */
  0x90090900,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x347 */
  0x90000000,
  0x90000000,
  0000000000,
  0x90000000,
  0000000000,
  0x90000000,
  0000000000,
  0000000000,
},
{ /* 0x348 */
  0xaaaaaaaa,
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0xa9999999,
},
{ /* 0x349 */
  0x00b3ba90,
  0xfbba9000,
  0xba900000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x34a */
  0xaaaaaaa9,
  0x99999990,
  0x99999990,
  0x99999990,
  0x99999990,
  0x99999990,
  0x99999990,
  0x99999990,
},
{ /* 0x34b */
  0x0009ba90,
  0x000a3900,
  0x000a3000,
  0x0009b900,
  0x0000ba00,
  0x00009b90,
  0x000009a0,
  0x000000a9,
},
{ /* 0x34c */
  0000000000,
  0x09abba90,
  0x9bb333ba,
  0xaba99aa3,
  0xb39000aa,
  0xb390009a,
  0xaba90009,
  0x9aba0000,
},
{ /* 0x34d */
  0000000000,
  0000000000,
  0x90000099,
  0xb00009ba,
  0x3a9a9baf,
  0xb336ba00,
  0xabb3a000,
  0x9ab3b000,
},
{ /* 0x34e */
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0xa9999999,
  0x90000000,
},
{ /* 0x34f */
  0x09ab9000,
  0x0093a000,
  0x0003a000,
  0x009b9000,
  0x00ab0000,
  0x09b90000,
  0x0a900000,
  0x9a000000,
},
{ /* 0x350 */
  0x99999990,
  0x99999990,
  0x99999990,
  0x99999990,
  0x99999990,
  0x99999990,
  0x99999990,
  0000000000,
},
{ /* 0x351 */
  0xaaaaaaaa,
  0xaa999999,
  0xa9999990,
  0xa909990a,
  0xa900000a,
  0xa9aaaaa9,
  0xa9999999,
  0xa9909990,
},
{ /* 0x352 */
  0xaaaaaaa9,
  0x99999990,
  0x09999990,
  0xa0999090,
  0x90000090,
  0x9aaaaa90,
  0x99999990,
  0x99909990,
},
{ /* 0x353 */
  0xa90a090a,
  0xa9a9a0a9,
  0xa9999a99,
  0xa9999999,
  0xa90a90a9,
  0xa90a90a9,
  0xa9999999,
  0x90000000,
},
{ /* 0x354 */
  0x090a0990,
  0x90a99090,
  0x9a999a90,
  0x99999990,
  0x0a900a90,
  0x0a9aaa90,
  0x99999990,
  0000000000,
},
{ /* 0x355 */
  0xaaaaaaaa,
  0xaa999999,
  0xa9000000,
  0xa9a00000,
  0xa99a000a,
  0xa90aaaa9,
  0xa9000a99,
  0xa900000a,
},
{ /* 0x356 */
  0xaaaaaaa9,
  0x99999990,
  0x0a900a90,
  0xa990a990,
  0x9990a990,
  0x999a9990,
  0x99000a90,
  0x99aa0a90,
},
{ /* 0x357 */
  0xa90a000a,
  0xa90aa00a,
  0xa90a9aaa,
  0xa900a999,
  0xa900a900,
  0xa900a9aa,
  0xa9999999,
  0x90000000,
},
{ /* 0x358 */
  0x99990a90,
  0x99000a90,
  0x990aa990,
  0x990a9990,
  0x09000a90,
  0xa9aa0a90,
  0x99999990,
  0000000000,
},
{ /* 0x359 */
  0xaaaaaaaa,
  0xaa999999,
  0xa9999999,
  0xa9999900,
  0xa9990090,
  0xa9909909,
  0xa99a0090,
  0xa999aa00,
},
{ /* 0x35a */
  0xaaaaaaa9,
  0x99999990,
  0x99999990,
  0x00a99990,
  0x0a00a990,
  0x00a90a90,
  0x0a00a990,
  0x00aa9990,
},
{ /* 0x35b */
  0xa99999aa,
  0xa9999999,
  0xa9999990,
  0xa999000a,
  0xa900aaa9,
  0xa9aa9999,
  0xa9999999,
  0x90000000,
},
{ /* 0x35c */
  0xaa999990,
  0x990000a0,
  0x00aaaa90,
  0xa00000a0,
  0x9a000a90,
  0x99aaa990,
  0x99999990,
  0000000000,
},
{ /* 0x35d */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0x00ccc000,
  0x0cdddc00,
  0xcdeedc0c,
  0xceddc0cd,
},
{ /* 0x35e */
  0000000000,
  0000000000,
  0000000000,
  0x0c000000,
  0x0d000000,
  0xcdc00cc0,
  0xdec0cddc,
  0xedccdedc,
},
{ /* 0x35f */
  0xcccefcc0,
  0x00deedc0,
  0x00cdfdc0,
  0x00cdedc0,
  0x000cdc00,
  0x000cec00,
  0x0000c000,
  0000000000,
},
{ /* 0x360 */
  0x000cdc00,
  0x00cdedc0,
  0x000cdc00,
  0x000cec00,
  0x0000c000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x361 */
  0xc9900000,
  0x99000090,
  0x90000990,
  0x99000c90,
  0x90000900,
  0x90009c90,
  0x9000cd90,
  0x00009c90,
},
{ /* 0x362 */
  0x000c9900,
  0x000c9009,
  0x00090009,
  0x00090000,
  0x00090000,
  0x00000090,
  0x00900090,
  0x00c00000,
},
{ /* 0x363 */
  0x90000000,
  0x00000900,
  0x00000c00,
  0x00000c90,
  0x000009c9,
  0x00000099,
  0x00000009,
  0x00900009,
},
{ /* 0x364 */
  0x9000009c,
  0x09000099,
  0x00000009,
  0x09000009,
  0x99000009,
  0x09000009,
  0x00000099,
  0x0000009c,
},
{ /* 0x365 */
  0x00000c00,
  0x00000900,
  0x90000900,
  0x90000900,
  0xc9000000,
  0xc9000000,
  0x90000000,
  0x90000000,
},
{ /* 0x366 */
  0x00c00000,
  0x00900000,
  0x09000000,
  0x09000000,
  0x90900000,
  0xc9000000,
  0xc9900000,
  0xc9000000,
},
{ /* 0x367 */
  0x09c00009,
  0x0c900000,
  0x0c900000,
  0x09c90009,
  0x0099000c,
  0x0990000c,
  0x99000009,
  0xc0000009,
},
{ /* 0x368 */
  0x9000009c,
  0x9000009c,
  0x90000099,
  0x90000009,
  0x00000009,
  0x00000009,
  0x00090009,
  0x00090000,
},
{ /* 0x369 */
  0x00000090,
  0x00000090,
  0x00000900,
  0x00009900,
  0x0000c900,
  0x0009c900,
  0x0009c990,
  0x90009900,
},
{ /* 0x36a */
  0x90900000,
  0x09000000,
  0x90000009,
  0x0900009c,
  0x000000cc,
  0x090000cd,
  0x000000cd,
  0x0000009c,
},
{ /* 0x36b */
  0xc0000090,
  0x90000000,
  0x90000900,
  0x90000000,
  0x90009000,
  0xc9009000,
  0xc9000000,
  0xc9000000,
},
{ /* 0x36c */
  0x00900000,
  0x00900000,
  0x09900000,
  0x0c990000,
  0x9cc99000,
  0xcc990000,
  0xdc900000,
  0xcc990000,
},
{ /* 0x36d */
  0x90000990,
  0x90000990,
  0x90000090,
  0x90000000,
  0x99000900,
  0xc9000900,
  0xc9000900,
  0xc9900000,
},
{ /* 0x36e */
  0x00000009,
  0x00900000,
  0x00900000,
  0x00900900,
  0x09c00000,
  0x0cc90090,
  0x09c90000,
  0x009c9000,
},
{ /* 0x36f */
  0xc9000000,
  0x9c900000,
  0x0c900000,
  0x09900000,
  0x00900000,
  0x00900000,
  0x00900000,
  0x00000009,
},
{ /* 0x370 */
  0x9c900009,
  0x09000009,
  0x0090000c,
  0x0090009d,
  0x000000cd,
  0x0090009c,
  0x9000000c,
  0x90090009,
},
{ /* 0x371 */
  0xaaaaaaab,
  0x9999cdef,
  0x9999cdef,
  0x9999999a,
  0x999999ab,
  0x999999ab,
  0x9999999a,
  0x99999990,
},
{ /* 0x372 */
  0xa9aaaaaa,
  0xed0cc999,
  0xed0cc999,
  0x99009999,
  0xa9009999,
  0xa9009999,
  0x90099999,
  0xa9999999,
},
{ /* 0x373 */
  0xa99991b3,
  0xa99993a3,
  0xa9999a1b,
  0xa99999a1,
  0xa99999ad,
  0xa99999ab,
  0xa99999ab,
  0x900000ab,
},
{ /* 0x374 */
  0xb1999990,
  0x11999990,
  0xba999990,
  0xa9999990,
  0xa9999990,
  0xa9099990,
  0xa9099990,
  0xa9000000,
},
{ /* 0x375 */
  0xaaaaaaaa,
  0xa9999999,
  0xa9999999,
  0xa9000000,
  0xa9aaaaaa,
  0xa9999999,
  0xa9999999,
  0xa9000009,
},
{ /* 0x376 */
  0xaaaaaaa9,
  0x99999990,
  0x99999990,
  0x00000090,
  0xaaaaaa90,
  0x99999990,
  0x99999990,
  0x90000090,
},
{ /* 0x377 */
  0xa9aaaaa9,
  0xa9999999,
  0xa9999999,
  0xa9000000,
  0xa9aaaaaa,
  0xa9999999,
  0xa9999999,
  0x90000000,
},
{ /* 0x378 */
  0x9aaaaa90,
  0x99999990,
  0x99999990,
  0x00000090,
  0xaaaaaa90,
  0x99999990,
  0x99999990,
  0000000000,
},
{ /* 0x379 */
  0x9a399990,
  0xbaba3abb,
  0xa3a3a333,
  0xab3abbbb,
  0xababaaaa,
  0x99a99999,
  0x9ab9bbba,
  0x9ba99990,
},
{ /* 0x37a */
  0x999993b9,
  0xbbba3aba,
  0x3333a3a3,
  0xbbbbba3b,
  0xaaaaabaa,
  0x99999a99,
  0x3bbb9ba9,
  0xa9999a39,
},
{ /* 0x37b */
  0x9a390000,
  0xbaba3abb,
  0xa3a3a333,
  0xab3abbbb,
  0xababaaaa,
  0x99a99999,
  0x9ab90000,
  0x9ba90000,
},
{ /* 0x37c */
  0x000003b9,
  0xbbba3aba,
  0x3333a3a3,
  0xbbbbba3b,
  0xaaaaabaa,
  0x99999a99,
  0x00009ba9,
  0x00009a39,
},
{ /* 0x37d */
  0x09ab3b00,
  0x0009abbf,
  0x000009ab,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x37e */
  0x00000dcc,
  0x000cdc0d,
  0x0cdfc010,
  0x0efedd0e,
  0x0ded0ced,
  0x0cc0cddd,
  0x0ceedcde,
  0x000cedef,
},
{ /* 0x37f */
  0x0ccceded,
  0xcdeedcdd,
  0x000ccded,
  0x00cefedd,
  0x00cdeddc,
  0x000cccc0,
  0000000000,
  0000000000,
},
{ /* 0x380 */
  0xccd00000,
  0xd0cdc000,
  0x010cfdc0,
  0xe0ddefe0,
  0xdec0ded0,
  0xdddc0cc0,
  0xedcdeec0,
  0xfedec000,
},
{ /* 0x381 */
  0x000c9900,
  0x090c9009,
  0x00099999,
  0x09090000,
  0x09090000,
  0x09009999,
  0x09900090,
  0x00c90000,
},
{ /* 0x382 */
  0x00000c00,
  0x00000909,
  0x90999900,
  0x00000909,
  0x00000099,
  0x99099009,
  0x90000090,
  0x90000900,
},
{ /* 0x383 */
  0000000000,
  0000000000,
  0x00009aaa,
  0x9aaabbbb,
  0x000999aa,
  0x00000999,
  0000000000,
  0000000000,
},
{ /* 0x384 */
  0x00090000,
  0x000a0000,
  0x000a0000,
  0x000a9000,
  0x009b9000,
  0x00ab9900,
  0x00aba900,
  0x00aba900,
},
{ /* 0x385 */
  0xed700cdc,
  0xded70cfd,
  0xcdecccde,
  0x0dcdcefe,
  0xcdedcefb,
  0xdedc0de2,
  0xeac9ddee,
  0xdc0deeff,
},
{ /* 0x386 */
  0x00aba900,
  0x00aba900,
  0x00ab9900,
  0x009b9000,
  0x000a9000,
  0x000a0000,
  0x000a0000,
  0x00090000,
},
{ /* 0x387 */
  0xcdcc00cd,
  0xcaec0cde,
  0xded02cef,
  0xedeccdcf,
  0xeae29cef,
  0xbed909de,
  0xbedc009d,
  0xeeeed90c,
},
{ /* 0x388 */
  0xcdeefffd,
  0xceffeeff,
  0xccdeedef,
  0xdfcddcce,
  0xeddcccdd,
  0xcccdeeee,
  0xdddeddde,
  0x0ee00ccc,
},
{ /* 0x389 */
  0xeeddeedc,
  0xfeeedeed,
  0xeedeeecd,
  0xeccddcff,
  0xddcccdde,
  0xeedddccc,
  0xddeeeddd,
  0xccc00ee0,
},
{ /* 0x38a */
  0x0ce000ce,
  0x0000000c,
  0000000000,
  0x0000cddc,
  0x000cdeee,
  0xeddcdeee,
  0xccccccde,
  0xdddddccd,
},
{ /* 0x38b */
  0xec000ec0,
  0xc0000000,
  0x0000000c,
  0xcddc00cc,
  0xededc000,
  0xeeedcdde,
  0xedcccccc,
  0xdccddddd,
},
{ /* 0x38c */
  0x0cddcdee,
  0x00edcdee,
  0x00cdcedd,
  0x00cdcded,
  0x0cddcddd,
  0xddccdedc,
  0xccddeddc,
  0xdddeedc0,
},
{ /* 0x38d */
  0xdedeccc0,
  0xddcdeedc,
  0xdedcc000,
  0xddefec00,
  0xcddedc00,
  0x0cccc000,
  0000000000,
  0000000000,
},
{ /* 0x38e */
  0xab3f3ba9,
  0xab3f3ba9,
  0xab3f3ba9,
  0x9ab3ba90,
  0x0ab3ba90,
  0x099a9990,
  0xab333ba9,
  0x099a9900,
},
{ /* 0x38f */
  0x099a9900,
  0xab333ba9,
  0x099a9990,
  0x0ab3ba90,
  0x9ab3ba90,
  0xab3f3ba9,
  0xab3f3ba9,
  0xab3f3ba9,
},
{ /* 0x390 */
  0x00aba950,
  0x00aba950,
  0x00ab6500,
  0x00f69900,
  0x069aa900,
  0x05aba900,
  0x00aba900,
  0x00aba900,
},
{ /* 0x391 */
  0xa3aa99aa,
  0x9baa9a9a,
  0x0000b9aa,
  0xabbbaaaa,
  0xbaaaaaa9,
  0x3a9aaaaa,
  0xbaaaaaaa,
  0xa9999999,
},
{ /* 0x392 */
  0xaba92222,
  0xaba922aa,
  0xaba92aaa,
  0xaba9233a,
  0xaba9222a,
  0xaba92222,
  0xaba92223,
  0xaba92222,
},
{ /* 0x393 */
  0x2222aba9,
  0x3222aba9,
  0xa322aba9,
  0xaa32aba9,
  0xaaa3aba9,
  0xa322aba9,
  0x3322aba9,
  0x2222aba9,
},
{ /* 0x394 */
  0xaba92aaa,
  0xaba92333,
  0xaba92222,
  0xaba922aa,
  0xaba92aa2,
  0xaba92a29,
  0xaba92a23,
  0x9999a9aa,
},
{ /* 0x395 */
  0xaaa2aba9,
  0x3332aba9,
  0x2222aba9,
  0xaa22aba9,
  0x2aa2aba9,
  0x92a2aba9,
  0x32a2aba9,
  0xaa9a9999,
},
{ /* 0x396 */
  0xaba92a29,
  0xaba92a23,
  0xaba92aa2,
  0xaba922aa,
  0xaba92222,
  0xaba92a32,
  0xaba92aa3,
  0xaba92aa3,
},
{ /* 0x397 */
  0x92a2aba9,
  0x32a2aba9,
  0x2aa2aba9,
  0xaa22aba9,
  0x2222aba9,
  0x2a32aba9,
  0x2aa3aba9,
  0x2aa3aba9,
},
{ /* 0x398 */
  0xaba92aa3,
  0xaba92aa3,
  0xaba92a32,
  0xaba92a32,
  0xaba92a32,
  0xaba92322,
  0xaba92222,
  0x99999999,
},
{ /* 0x399 */
  0x2aa3aba9,
  0x2aa3aba9,
  0x2a32aba9,
  0x2a32aba9,
  0x2a32aba9,
  0x2322aba9,
  0x2222aba9,
  0x99999999,
},
{ /* 0x39a */
  0xaba92222,
  0xaba922aa,
  0xaba92aaa,
  0xaba92aaa,
  0xaba923aa,
  0xaba92233,
  0xaba92222,
  0xaba922a3,
},
{ /* 0x39b */
  0x2222aba9,
  0x32a3aba9,
  0xa3a3aba9,
  0xa3a3aba9,
  0x32a3aba9,
  0x2232aba9,
  0x2222aba9,
  0x2aa2aba9,
},
{ /* 0x39c */
  0xaba922a3,
  0xaba92aaa,
  0xaba922a3,
  0xaba922a3,
  0xaba922a3,
  0xaba922a3,
  0xaba92222,
  0x99999999,
},
{ /* 0x39d */
  0x2aa2aba9,
  0x3332aba9,
  0x2222aba9,
  0x2aa2aba9,
  0x2aa2aba9,
  0x2332aba9,
  0x2222aba9,
  0x99999999,
},
{ /* 0x39e */
  0x09abaaaa,
  0x0abaaaba,
  0x0aaaa993,
  0x0aba9ab9,
  0x0aba9b9b,
  0x0aa9b999,
  0x0ab99939,
  0x0aba9bb9,
},
{ /* 0x39f */
  0xababaaab,
  0xbbbbbbba,
  0xbbbbbbaa,
  0x3bbbbaa9,
  0x93bbbb99,
  0x9999bba3,
  0x33393bb9,
  0x93b3bab9,
},
{ /* 0x3a0 */
  0xaa9a9900,
  0xb99ba990,
  0x99a9b990,
  0xba9ab990,
  0xba99a990,
  0x99b9b990,
  0xb99a9990,
  0x9b9b9990,
},
{ /* 0x3a1 */
  0x00ba99b9,
  0x0aaa9399,
  0x0aaa9b99,
  0x09bb9939,
  0x0abab93b,
  0x0aaa93bb,
  0x09aaa9ba,
  0x09999999,
},
{ /* 0x3a2 */
  0x3bba9999,
  0xbbbbb339,
  0x3bbbbba9,
  0x3bbabbb9,
  0x93bbbbb9,
  0x993b9399,
  0xbbaaaabb,
  0x99999999,
},
{ /* 0x3a3 */
  0xba9b9990,
  0x999a9990,
  0x9b99a990,
  0x939b9990,
  0x3a9ba990,
  0xb99ba990,
  0xaaba9990,
  0x99999990,
},
{ /* 0x3a4 */
  0x09ababbb,
  0x0ababba9,
  0x0ab9aa93,
  0x09bbb3bb,
  0x0aba93bb,
  0x0aba9999,
  0x09abab33,
  0x09999999,
},
{ /* 0x3a5 */
  0xbbbbbaba,
  0xabbb9ba9,
  0x39aa939a,
  0xbb333b9b,
  0xbb939b9b,
  0x3b9393a9,
  0xbbbbbabb,
  0x99999999,
},
{ /* 0x3a6 */
  0xaa9a9900,
  0x9ab9a990,
  0xb9b99990,
  0xb9b99990,
  0xa9a9a990,
  0x9ab9a990,
  0xba9a9990,
  0x99999990,
},
{ /* 0x3a7 */
  0x09ababbb,
  0x0aba9aa9,
  0x0abb3b33,
  0x09a9a9a9,
  0x0abbbb33,
  0x0ab9a9aa,
  0x09abb333,
  0x09999999,
},
{ /* 0x3a8 */
  0xbbbbbaba,
  0xbbb99ba9,
  0xbb9ab939,
  0x3b3993b9,
  0xbbbb3ba9,
  0x3ba99ab9,
  0xbbb33bbb,
  0x99999999,
},
{ /* 0x3a9 */
  0xaa9a9900,
  0xbaa99990,
  0x99a9a990,
  0xabb9a990,
  0x3aa99990,
  0xbaa9a990,
  0xaa9a9990,
  0x99999990,
},
{ /* 0x3aa */
  0x099a9aaa,
  0x99ababab,
  0x9abab3b3,
  0x99baab3b,
  0x9abba3b3,
  0x9abab3b3,
  0x99aaba3b,
  0x0999a9a9,
},
{ /* 0x3ab */
  0xbabababa,
  0xab3b3bab,
  0xb3f3b3bb,
  0x33b33b3b,
  0xf333b3bb,
  0x3f3b3b3b,
  0x33b3b3bb,
  0x9a9aa99a,
},
{ /* 0x3ac */
  0xaa9a9000,
  0xaba99009,
  0xbabaa900,
  0xabaa9009,
  0xaba99909,
  0xbaaa9009,
  0xaba99909,
  0x99999000,
},
{ /* 0x3ad */
  0000000000,
  0xddedefef,
  0xcdceeeef,
  0x0cddedee,
  0x0000000c,
  0x00cddede,
  0x00cdeeed,
  0x00cddede,
},
{ /* 0x3ae */
  0000000000,
  0xfffffffe,
  0xefffffef,
  0xffffffff,
  0x0cccccc0,
  0xeeffffff,
  0xefffffff,
  0xfffffffe,
},
{ /* 0x3af */
  0000000000,
  0xfefeeefe,
  0xeeeeefee,
  0xfefffeed,
  0x0cc00c00,
  0xeffeeedd,
  0xeffffedc,
  0xfffeeded,
},
{ /* 0x3b0 */
  0000000000,
  0xeddcd0cc,
  0xdccdcc0c,
  0xdcdc0cc0,
  0000000000,
  0xcdc00000,
  0xccc0cc00,
  0xcd00c000,
},
{ /* 0x3b1 */
  0x00cddede,
  0x00ccddee,
  0x00cddede,
  0x00cddedd,
  0x00cdeede,
  0x00cddeee,
  0x00ccdede,
  0x00cdddde,
},
{ /* 0x3b2 */
  0xfeffffff,
  0xffffffff,
  0xefffffff,
  0xeeffffff,
  0xeffffffe,
  0xfeffffff,
  0xefffffff,
  0xeeffffff,
},
{ /* 0x3b3 */
  0xeefffedd,
  0xefffeedd,
  0xffffeddd,
  0xefeeeedd,
  0xefffeeed,
  0xefeeeded,
  0xefffeedd,
  0xfeffeedd,
},
{ /* 0x3b4 */
  0xcdc0cc00,
  0xdd00c000,
  0xcdc00c00,
  0xcc00cc00,
  0xcdc00c00,
  0xdd00cc00,
  0xcd00c000,
  0xccc0cc00,
},
{ /* 0x3b5 */
  0x00ccdede,
  0x00cddeee,
  0x00cddede,
  0x0000ccc0,
  0x0cddedee,
  0xcddedfef,
  0xddedeefe,
  0000000000,
},
{ /* 0x3b6 */
  0xfeffffff,
  0xefffffff,
  0xefffffff,
  0x0dedded0,
  0xffffffff,
  0xffeffffe,
  0xffffffff,
  0000000000,
},
{ /* 0x3b7 */
  0xffeefeed,
  0xeffffedc,
  0xefffeedd,
  0xcdddccc0,
  0xfeeefefd,
  0xfeeefeee,
  0xffeeeffe,
  0000000000,
},
{ /* 0x3b8 */
  0xcdc00c00,
  0xccc0cc00,
  0xcdc0cc00,
  0000000000,
  0xdcdc0cc0,
  0xddc0c00c,
  0xeddcdc0c,
  0000000000,
},
{ /* 0x3b9 */
  0000000000,
  0x09a22b3b,
  0x09ab22bb,
  0x09ab2b3b,
  0x00000099,
  0x000009ab,
  0x0000009a,
  0000000000,
},
{ /* 0x3ba */
  0000000000,
  0x3b333333,
  0xb3332332,
  0x3b333333,
  0x900aaaaa,
  0x2b333332,
  0xb22b3323,
  0x0999aaaa,
},
{ /* 0x3bb */
  0000000000,
  0x33333b33,
  0x3333bb3b,
  0x333b3b33,
  0xaa009099,
  0x33b3b33b,
  0x333b33ab,
  0xa0999990,
},
{ /* 0x3bc */
  0000000000,
  0xbaaba990,
  0xbbaaa990,
  0xbaaba990,
  0x99000000,
  0xba990000,
  0xa9900000,
  0000000000,
},
{ /* 0x3bd */
  0x9ab2b333,
  0x9aa22b33,
  0x9ab2b332,
  0x9abab333,
  0x9ab22333,
  0x9a22b333,
  0x9aba2b33,
  0x9a22b33b,
},
{ /* 0x3be */
  0xb3baba99,
  0xb3baaa99,
  0x3baaba99,
  0xb3baba99,
  0xbbbab999,
  0xb3aaba99,
  0xb3baaa99,
  0x33baba99,
},
{ /* 0x3bf */
  0x9abab333,
  0x9ab23333,
  0x9ab2b333,
  0x9aa23233,
  0x9ab22333,
  0x9ab2333b,
  0x9aa22333,
  0x9ab2b333,
},
{ /* 0x3c0 */
  0xb33aa999,
  0xb3baba99,
  0x3baaba99,
  0xb3baba99,
  0xb3baa999,
  0x3bbaba99,
  0xb3baaa99,
  0xb3baba99,
},
{ /* 0x3c1 */
  0000000000,
  0x0000009a,
  0x000009ab,
  0x00000099,
  0x09ab2b3b,
  0x09ab22bb,
  0x09a22b3b,
  0000000000,
},
{ /* 0x3c2 */
  0000000000,
  0xb22b3323,
  0x2b333332,
  0xa9aa222a,
  0x3b333333,
  0xb3332332,
  0x3b333333,
  0000000000,
},
{ /* 0x3c3 */
  0000000000,
  0x333b33ab,
  0x33b3b33b,
  0xaa2aaaaa,
  0x333b3b33,
  0x3333bb3b,
  0x33333b33,
  0000000000,
},
{ /* 0x3c4 */
  0000000000,
  0xa9900000,
  0xba990000,
  0x99000000,
  0xbaaba990,
  0xbbaaa990,
  0xbaaba990,
  0000000000,
},
{ /* 0x3c5 */
  0000000000,
  0x9b33333b,
  0xabbbbbbb,
  0x009aabbb,
  0x000009aa,
  0000000000,
  0x33333333,
  0xbbbbbbbb,
},
{ /* 0x3c6 */
  0x009aba90,
  0xb9ba8aa9,
  0xa9a99aaa,
  0xba99abaa,
  0xaaa9aba9,
  0x9a9aba99,
  0x33333333,
  0xbbbbbbbb,
},
{ /* 0x3c7 */
  0x09aba900,
  0x9aa8ab9b,
  0xaaa99a9a,
  0xaaba99ab,
  0x9aba9aaa,
  0x99aba9a9,
  0x33333333,
  0xbbbbbbbb,
},
{ /* 0x3c8 */
  0000000000,
  0xb33333b9,
  0xbbbbbbba,
  0xaaaaa900,
  0xaa900000,
  0000000000,
  0x33333333,
  0xbbbbbbbb,
},
{ /* 0x3c9 */
  0x99999999,
  0x0aaaaaaa,
  0x00999999,
  0x00a56595,
  0x00a56595,
  0x09a56595,
  0x9b333333,
  0xaaaaaaaa,
},
{ /* 0x3ca */
  0x99999999,
  0xaaaaaaaa,
  0x99999999,
  0x559a559a,
  0x559a9659,
  0x559aa965,
  0x3b333b3b,
  0xaaaaaaaa,
},
{ /* 0x3cb */
  0x99999999,
  0xaaaaaaaa,
  0x99999999,
  0xa955a956,
  0x9569a956,
  0x569aa956,
  0x3b3bb3bb,
  0xaaaaaaaa,
},
{ /* 0x3cc */
  0x99999999,
  0xaaaaaaa0,
  0x99999900,
  0x59565a00,
  0x59565a00,
  0x59565a90,
  0xb3bbbbb9,
  0xaaaaaaaa,
},
{ /* 0x3cd */
  0x09990009,
  0x9aba999a,
  0x09aba9a3,
  0x009a9a9a,
  0x00999b99,
  0x009a9991,
  0x09aa9aa9,
  0x09aba9ba,
},
{ /* 0x3ce */
  0x9a9bb9a9,
  0x9b9aa9b9,
  0xb9a99a9b,
  0xb39ba93b,
  0x9aa99aa9,
  0x619aa916,
  0x19b33b91,
  0xba9bb9ab,
},
{ /* 0x3cf */
  0x90009990,
  0xa999aba9,
  0x3a9aba90,
  0xa9a9a900,
  0x99b99900,
  0x1999a900,
  0x9aa9aa90,
  0xab9aba90,
},
{ /* 0x3d0 */
  0x9a9a99b9,
  0x99a9a99b,
  0x9aba9a9a,
  0x99a9a9a9,
  0x9a9aba9a,
  0x09a9a9a9,
  0x00999a9a,
  0x00000999,
},
{ /* 0x3d1 */
  0xabbaabba,
  0x9eceece9,
  0xbf9cc9fb,
  0xbc9999cb,
  0xab9999ba,
  0x93d99d39,
  0x9be99eb9,
  0xa9b99b9a,
},
{ /* 0x3d2 */
  0x9b99a9a9,
  0xb99a9a99,
  0xa9a9aba9,
  0x9a9a9a99,
  0xa9aba9a9,
  0x9a9a9a90,
  0xa9a99900,
  0x99900000,
},
{ /* 0x3d3 */
  0x99b99b99,
  0xa9a33a99,
  0xab99999a,
  0x9abaa9a9,
  0x05abba59,
  0x0a6aa590,
  0x9ab65a90,
  0x9aabaa90,
},
{ /* 0x3d4 */
  0x095aa590,
  0x09a65aa9,
  0x009aba59,
  0x00a956aa,
  0x00ab9aba,
  0x00ab95a5,
  0x00aba96a,
  0x00aba9a9,
},
{ /* 0x3d5 */
  0x00aba9a9,
  0x00aba990,
  0x00aba990,
  0x09aba900,
  0x9a9aa900,
  0x9ba9a900,
  0x0ab99900,
  0x09ba9990,
},
{ /* 0x3d6 */
  0x009ba9a9,
  0x00a9aa90,
  0x00ab9900,
  0x00aba900,
  0x00aba900,
  0x00aba900,
  0x00aba900,
  0x00aba900,
},
{ /* 0x3d7 */
  0x00aba900,
  0x00aba900,
  0x00aba900,
  0x00aba900,
  0x00aba900,
  0x00aba900,
  0x00aba900,
  0x00aba900,
},
{ /* 0x3d8 */
  0x00aba900,
  0x00ba9900,
  0x00aba900,
  0x00a3b900,
  0x00aba900,
  0x00aba900,
  0x009aa900,
  0x00abb900,
},
{ /* 0x3d9 */
  0x00aba900,
  0x00aba900,
  0x00aba900,
  0x00ba9900,
  0x00aba900,
  0x00b3a900,
  0x00ab9900,
  0x00aba900,
},
{ /* 0x3da */
  0x0000a000,
  0x000009ba,
  0x00000baa,
  0x00000baa,
  0x000009aa,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x3db */
  0x00aba900,
  0x90ba999a,
  0xa9aba9ab,
  0xa9aab9aa,
  0x90aba99a,
  0x00aba900,
  0x009aa900,
  0x00abb900,
},
{ /* 0x3dc */
  0x00a00000,
  0xa9000000,
  0xaa900000,
  0xaa900000,
  0xa9000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x3dd */
  0000000000,
  0x00090000,
  0x009a0000,
  0x00aa9000,
  0x00aba000,
  0x00aba900,
  0x009aa900,
  0x00abb900,
},
{ /* 0x3de */
  0x3bbbbaa0,
  0xbaaaaa90,
  0xaaa9aaa0,
  0x99999990,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x3df */
  0000000000,
  0x3b33bbb0,
  0xbaaaaa90,
  0x3aaaaaa0,
  0xa99a9990,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x3e0 */
  0000000000,
  0000000000,
  0x3bbbbaa0,
  0xbaaaaa90,
  0xaaa9aaa0,
  0x99999990,
  0000000000,
  0000000000,
},
{ /* 0x3e1 */
  0x3bbbbaa0,
  0xbaaaaa90,
  0xaaa9aaa0,
  0x99999990,
  0xaaa90000,
  0x0aba9000,
  0x00aba900,
  0x000aba90,
},
{ /* 0x3e2 */
  0x39bba9a0,
  0xb9ba9990,
  0xa9bba9a0,
  0x99aab990,
  0x00aba900,
  0x00aba900,
  0x009aa900,
  0x00abb900,
},
{ /* 0x3e3 */
  0x3bbbbaa0,
  0xbaaaaa90,
  0xaaa9aaa0,
  0x99999990,
  0000000000,
  0x00999900,
  0x0aaaa000,
  0xabaa0000,
},
{ /* 0x3e4 */
  0xeff78787,
  0xffeef8cc,
  0xcccce8c0,
  0xd0ceecdc,
  0xccdcddcd,
  0xfedeeeee,
  0xeeeeddee,
  0x09099000,
},
{ /* 0x3e5 */
  0x7fffff8f,
  0xdeeeeeee,
  0xccddc0cc,
  0xcdeddcce,
  0xccddc0cc,
  0xeeeeeeee,
  0xccedeede,
  0x90c90909,
},
{ /* 0x3e6 */
  0x9aaaaaaa,
  0xabbbbbbb,
  0xb33b3b3b,
  0xabbbbbbb,
  0xaaaaaaaa,
  0x9aaaaaaa,
  0x09999999,
  0000000000,
},
{ /* 0x3e7 */
  0xaaaaaaaa,
  0xbbbbbbbb,
  0x3b3b3b3b,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x99999999,
  0000000000,
},
{ /* 0x3e8 */
  0xaaaaaaa9,
  0xbbbbbbba,
  0x3b3b3b3b,
  0xbbbbbbba,
  0xaaaaaaa9,
  0xaaaaaaa9,
  0x99999999,
  0000000000,
},
{ /* 0x3e9 */
  0x9aaaaaaa,
  0xabbbbbbb,
  0xb3333333,
  0xabbbbbbb,
  0xaaaaaaaa,
  0x9aaaaaaa,
  0x09999999,
  0000000000,
},
{ /* 0x3ea */
  0xaaaaaaaa,
  0xbbbbbbbb,
  0x33333333,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x99999999,
  0000000000,
},
{ /* 0x3eb */
  0xaaaaaaa9,
  0xbbbbbbba,
  0x3333333b,
  0xbbbbbbba,
  0xaaaaaaa9,
  0xaaaaaaa9,
  0x99999999,
  0000000000,
},
{ /* 0x3ec */
  0x99999990,
  0xaaaaaaa9,
  0xaaaaaaa9,
  0xbbbbbbba,
  0xbbbbbbba,
  0xbbbbbbba,
  0xbbbbbbba,
  0x99999990,
},
{ /* 0x3ed */
  0x99999999,
  0xbaaaaaaa,
  0xbaaaaaaa,
  0x3bbbbbbb,
  0x3bbbbbbb,
  0x3bbbbbbb,
  0x3bbbbbbb,
  0xa9999999,
},
{ /* 0x3ee */
  0x9aaaaaaa,
  0xabbbbbbb,
  0xbb333333,
  0xaabbbbbb,
  0x999aaaaa,
  0x999aaaaa,
  0x00009999,
  0000000000,
},
{ /* 0x3ef */
  0x00000999,
  0x999999aa,
  0x999999aa,
  0xaaaaaaab,
  0xaaaaaaab,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x99999999,
},
{ /* 0x3f0 */
  0x0cdeeedd,
  0xcddcccc0,
  0xdec00dcc,
  0xdc00c0dc,
  0xdc0cc0dc,
  0xedc00dcc,
  0xdccddcec,
  0xdcdccdec,
},
{ /* 0x3f1 */
  0xc0cccc00,
  0xcccc0cc0,
  0xcc00ccc0,
  0xc00c0dc0,
  0xc0cc0dc0,
  0x0c00edc0,
  0x0ccd0c00,
  0x00c000c0,
},
{ /* 0x3f2 */
  0xdcccdedc,
  0xcdcdccc0,
  0xcdc0eeed,
  0xcc0ecccc,
  0x0c0dcc00,
  0xccc0dddd,
  0x0cccc0c0,
  0000000000,
},
{ /* 0x3f3 */
  0xc00c0c00,
  0xccc0c000,
  0xddc00c00,
  0xccdc00c0,
  0x00dc0c00,
  0xddc0c000,
  0xc0000000,
  0000000000,
},
{ /* 0x3f4 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x3f5 */
  0x0000ddc0,
  0x000dedcc,
  0x00ceddcc,
  0x0cdeddc0,
  0x0deddcc0,
  0x0dedcc0d,
  0x00dc0cde,
  0x0000cdef,
},
{ /* 0x3f6 */
  0x00000ddd,
  0x0000deed,
  0x000deedd,
  0x000defed,
  0x000deede,
  0x000ddeed,
  0x0000defe,
  0x00000ded,
},
{ /* 0x3f7 */
  0000000000,
  0000000000,
  0x000dedc0,
  0x00defedc,
  0x00deeddc,
  0xdc0dddcc,
  0xedc0ccc0,
  0xedc00000,
},
{ /* 0x3f8 */
  0xc0000000,
  0xccc00000,
  0xdcc00000,
  0xddcc0000,
  0xddcc0000,
  0xddcc0000,
  0xddcc0000,
  0xdcc00000,
},
{ /* 0x3f9 */
  0x0defffff,
  0xceffeeee,
  0xcfe0cced,
  0xcfeccdee,
  0xcfecccdd,
  0xceeeeeee,
  0xcdefedde,
  0x7ccdac9c,
},
{ /* 0x3fa */
  0xfff87ed0,
  0xeee787ec,
  0xedcc87ec,
  0xfedc8eec,
  0xedcc0edc,
  0xeeeeeeec,
  0xfeeededc,
  0xc00d00cd,
},
{ /* 0x3fb */
  0xdc9bdeee,
  0xecbdecfd,
  0xf7befc00,
  0xf7aef0de,
  0xecdedc00,
  0xecddeddd,
  0xfdcddece,
  0xdfdccddd,
},
{ /* 0x3fc */
  0xddc00000,
  0xdcc00000,
  0xdc000000,
  0xcc000000,
  0xc0000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x3fd */
  0xeeeeeede,
  0xeddeedee,
  0xddcddeed,
  0xccdcdddc,
  0xed00cccc,
  0xdd0cc000,
  0x0cc00000,
  0xcc000ccc,
},
{ /* 0x3fe */
  0xedcc0cde,
  0xeedddeed,
  0xeedcdddd,
  0xddeddcdc,
  0xccdeeccc,
  0xccccccc0,
  0x00cc000c,
  0x0000cdde,
},
{ /* 0x3ff */
  0xdcc0cddd,
  0xdcc0deed,
  0xdc0deedd,
  0xcc0defed,
  0xc00deede,
  0x000ddeed,
  0xddc0defe,
  0xdddc0ded,
},
{ /* 0x400 */
  0xc000deff,
  0xccc0defe,
  0xdcc0cdfe,
  0xddcc0ded,
  0xddcc0cdd,
  0xddcc00cc,
  0xddcc0000,
  0xdcc00000,
},
{ /* 0x401 */
  0xddcc0cde,
  0x0cc000cd,
  0x00cdedc0,
  0x00defedc,
  0x00deeddc,
  0xdc0dddcc,
  0xedc0ccc0,
  0xedc00000,
},
{ /* 0x402 */
  0xddc0ddc0,
  0xdc0dedcc,
  0x00ceddcc,
  0x0cdeddc0,
  0x0deddcc0,
  0x0dedcc0d,
  0x0cdc0cde,
  0x0000cdef,
},
{ /* 0x403 */
  0xddc00ddd,
  0xdcc0deed,
  0xdc0deedd,
  0xcccdefed,
  0xc0cdeede,
  0x000ddeed,
  0xddccdefe,
  0xdddccdee,
},
{ /* 0x404 */
  0xc000deff,
  0xccc0defe,
  0xdcc0cdfe,
  0xddcc0ded,
  0xddcc0cdd,
  0xddcc00cc,
  0xddcc000c,
  0xdcc000cd,
},
{ /* 0x405 */
  0xeceec0ce,
  0xfffdec0e,
  0xc00cdecf,
  0x0ed0dece,
  0xc00caecd,
  0xddbdedce,
  0xeceedcde,
  0xdadccded,
},
{ /* 0x406 */
  0xcfedcccc,
  0xcddeddcd,
  0xdccddcdc,
  0xdddccddc,
  0xedededcc,
  0xdeeedcdd,
  0xdeddceed,
  0xdeedcedc,
},
{ /* 0x407 */
  0xccc0ced7,
  0xc00ceed7,
  0x7ccedccd,
  0xdddccddd,
  0xccddddee,
  0xddcddede,
  0xdedcddee,
  0xcddcddee,
},
{ /* 0x408 */
  0xeedcdd00,
  0xdedced00,
  0xeeecec00,
  0xeedcdc0c,
  0xdedcddc0,
  0xceedccdd,
  0xcddeddcc,
  0x0cddeddd,
},
{ /* 0x409 */
  0xabbbb33b,
  0xab33bbba,
  0xb33baaaa,
  0xb3baaa9a,
  0xbbaaa9a9,
  0xbaba999a,
  0x3baaa999,
  0x33ba9a9a,
},
{ /* 0x40a */
  0xa99ab33b,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0xababb2bb,
  0xaaaaabab,
  0xaababaaa,
  0xab2baa9a,
  0xb2aaaaa9,
},
{ /* 0x40b */
  0xbabbbbaa,
  0xabaaaaa9,
  0xaaa99aa9,
  0xbb2a9aa9,
  0xaaaa9aa9,
  0xaaaaaaa9,
  0x99aaaaa9,
  0xa999aaa9,
},
{ /* 0x40c */
  0xa3aa99aa,
  0xabaa9a9a,
  0xabaa99aa,
  0xbaaa9aaa,
  0x3aaaaaa9,
  0x3a9aaaaa,
  0xbaaaaaaa,
  0xa9999999,
},
{ /* 0x40d */
  0xabaa9a99,
  0xbaaaa999,
  0xabaa9a9a,
  0xaaa9a99a,
  0x9a9a99aa,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x99999999,
},
{ /* 0x40e */
  0x9aaabaa9,
  0xabaaaaa9,
  0xaaaabaa9,
  0xabbbaaa9,
  0xb3babaa9,
  0xababaaa9,
  0xaaaaaa99,
  0x99999990,
},
{ /* 0x40f */
  0x3333b33b,
  0x32aaaaaa,
  0xbaaaaa9a,
  0x3aaaaaaa,
  0xbaaabaa9,
  0xbaaaaaaa,
  0x3a9aaaaa,
  0x3aaa9aaa,
},
{ /* 0x410 */
  0xb22bbb22,
  0xaaaaaaaa,
  0xaaaaaaaa,
  0x9aa2aa2a,
  0xaa9a9aaa,
  0xaaaaaaaa,
  0xa9aaabaa,
  0x9aaa2b2a,
},
{ /* 0x411 */
  0xbb3b3bba,
  0xaaaaaaa9,
  0xaaaaaa99,
  0xaababaa9,
  0xaba2aa99,
  0xaaaaa9a9,
  0xaaa9a9a9,
  0xaaaaaa99,
},
{ /* 0x412 */
  0xbaaaaaa2,
  0x3aaaa2aa,
  0xbaaa2aaa,
  0x2aaaaaaa,
  0xbaa9aaab,
  0x2aaaa2aa,
  0x2aaaaaaa,
  0xa9999999,
},
{ /* 0x413 */
  0xaa9aabaa,
  0xa9aaaaaa,
  0xaaaa99aa,
  0xaaa9aaab,
  0xaaaabaa2,
  0xa9aaaaaa,
  0xaaaa9a9a,
  0x99999999,
},
{ /* 0x414 */
  0x99aaa9a9,
  0xaaba9aa9,
  0xaaaaa9a9,
  0xaaaaaa99,
  0xaaa9a999,
  0xaa9a99a9,
  0xa9a9a999,
  0x99999999,
},
{ /* 0x415 */
  0xfffffeff,
  0xfeeeeeee,
  0xeeeeeddd,
  0xfeedddde,
  0xeeddeddd,
  0xfeddddda,
  0xeedddddd,
  0xdccccccc,
},
{ /* 0x416 */
  0xfeefeedc,
  0xedeedddc,
  0xdddddddc,
  0xddddddcc,
  0xddaddddc,
  0xddddadcc,
  0xddddcccc,
  0xcccccccc,
},
{ /* 0x417 */
  0xffffeeff,
  0xfeeedddd,
  0xfddddddd,
  0xfeddd0de,
  0xfedd0add,
  0xfddddddd,
  0xeedddddc,
  0xdccccccc,
},
{ /* 0x418 */
  0xfeefeedc,
  0xedeedddc,
  0xdddddda9,
  0xddddda9c,
  0xadaddddc,
  0xddddadcc,
  0xccddcccc,
  0xc0cccccc,
},
{ /* 0x419 */
  0xffffeedc,
  0xfeeedddc,
  0xfedddddc,
  0xfddcdcdc,
  0xfddddcdc,
  0xfdddcdcc,
  0xfddddccc,
  0xedcccccc,
},
{ /* 0x41a */
  0xffefeffd,
  0xfdeeeeec,
  0xeedddddc,
  0xfddddddc,
  0xedadaddc,
  0xeddddddc,
  0xddddddcc,
  0xcccccccc,
},
{ /* 0x41b */
  0xffffeedc,
  0xfeeedddc,
  0xfedddddc,
  0xdccccccc,
  0xffffeeec,
  0xfdddcdcc,
  0xfddddccc,
  0xedcccccc,
},
{ /* 0x41c */
  0x0ceeefee,
  0xcffeeedd,
  0xfeedddcd,
  0xfddeddde,
  0xeddddedd,
  0xddeeeeed,
  0xcdddeded,
  0x0ccccccc,
},
{ /* 0x41d */
  0xdddcc000,
  0xdedddccc,
  0xddcddddd,
  0xeddeeddd,
  0xeeedddcd,
  0xddddcddc,
  0xdcdddddd,
  0xcc00c00c,
},
{ /* 0x41e */
  0xcccdddef,
  0xddeeffff,
  0xeffedddd,
  0xdddddddd,
  0xcddeedce,
  0xdcdddcdc,
  0xcdddddcd,
  0xccc000cc,
},
{ /* 0x41f */
  0xfeeffedc,
  0xeddeeddd,
  0xcdeddedc,
  0xdddedddd,
  0xedcddedc,
  0xdddeddcc,
  0xcdcccccc,
  0xcccc00c0,
},
{ /* 0x420 */
  0x00cddc00,
  0x0deddcc0,
  0xcfdcccc0,
  0xddccc0c0,
  0xdccc00c0,
  0xcccc0cc0,
  0xccc0cc0d,
  0x0ccc000c,
},
{ /* 0x421 */
  0000000000,
  0x00cccc00,
  0x0cddc0c0,
  0x0cdc0cc0,
  0x00ccc000,
  0xdc000ccc,
  0xedc0cdcc,
  0xdc000cc0,
},
{ /* 0x422 */
  0000000000,
  0x0cdddddd,
  0xcdeedccc,
  0xcdfdcccd,
  0xcdecccdd,
  0x0cddcccd,
  0x00cccccc,
  0000000000,
},
{ /* 0x423 */
  0000000000,
  0xccccc000,
  0xddcc0cc0,
  0xccccc0c0,
  0xdccdc0c0,
  0xc0c00cc0,
  0xccccc000,
  0000000000,
},
{ /* 0x424 */
  0x9a39aaaa,
  0xbaba3abb,
  0xa3a3a333,
  0xab3abbbb,
  0xababaaaa,
  0x99a99999,
  0x9ab99999,
  0x9ba90000,
},
{ /* 0x425 */
  0xaaaaa3b9,
  0xbbba3aba,
  0x3333a3a3,
  0xbbbbba3b,
  0xaaaaabaa,
  0x99999a99,
  0x99999ba9,
  0x00009a39,
},
{ /* 0x426 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x427 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
  },
{ /* BANK 3 */
{ /* 0x428 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x429 */
  0x00000040,
  0x40000004,
  0x40400404,
  0x40444404,
  0x40444404,
  0x40400404,
  0x40000004,
  0000000000,
},
{ /* 0x42a */
  0xcccc44cc,
  0x44444444,
  0x45444444,
  0x46544444,
  0x46454444,
  0x4e450444,
  0x4f454044,
  0x0f050000,
},
{ /* 0x42b */
  0xcccc4c4c,
  0x44444444,
  0x44444544,
  0x44445644,
  0x44454604,
  0x44454e40,
  0x44454f40,
  0x00050f00,
},
{ /* 0x42c */
  0xc4049222,
  0xc4922444,
  0xc9244999,
  0xc2444444,
  0x92499999,
  0x24999999,
  0x24444444,
  0x249a99aa,
},
{ /* 0x42d */
  0xaaa90400,
  0x444aa900,
  0x99999a90,
  0x444444a0,
  0xa9a99929,
  0x9999999a,
  0x44444442,
  0xaaa9aa92,
},
{ /* 0x42e */
  0xa4999999,
  0x244444dc,
  0xa4999999,
  0x9a499994,
  0xc244444c,
  0xc9a4999c,
  0xc492a499,
  0xc4449aaa,
},
{ /* 0x42f */
  0x99999992,
  0xecd44442,
  0xca9aa992,
  0xd4999929,
  0xdc444420,
  0xdc999290,
  0x99922900,
  0xaaa90000,
},
{ /* 0x430 */
  0000000000,
  0x40000788,
  0x03f888ff,
  0x0a877788,
  0x40000777,
  0x40400000,
  0x40000788,
  0x03f888ff,
},
{ /* 0x431 */
  0x0a877788,
  0x40000777,
  0x40000000,
  0x00000788,
  0x03f888ff,
  0x0a877788,
  0x40000777,
  0000000000,
},
{ /* 0x432 */
  0xbbabbaa9,
  0xbaaaaaa9,
  0xbaaaaaa9,
  0xa9999999,
  0xbbbbbab9,
  0xbaaaaaa9,
  0xbaaaaaa9,
  0xa9999999,
},
{ /* 0x433 */
  0000000000,
  0x88700000,
  0xff888f30,
  0x887778a0,
  0x77700000,
  0000000000,
  0x88700000,
  0xff888f30,
},
{ /* 0x434 */
  0x887778a0,
  0x77700000,
  0000000000,
  0x88700000,
  0xff888f30,
  0x887778a0,
  0x77700000,
  0000000000,
},
{ /* 0x435 */
  0xcccc44cc,
  0x44444444,
  0xddddcdcd,
  0x44444444,
  0000000000,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0x436 */
  0xcc4d4c4c,
  0x444d4404,
  0xccce4ccc,
  0x444d4404,
  0x000c0000,
  0x444d4404,
  0x444d4404,
  0x000d0000,
},
{ /* 0x437 */
  0xcccc4c4c,
  0x44444444,
  0xcdcdddcd,
  0x44444444,
  0000000000,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0x438 */
  0xcccc44cc,
  0x44444444,
  0xddddcdcd,
  0x44444444,
  0000000000,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0x439 */
  0xcc4d4c4c,
  0x444d4404,
  0xccce4ccc,
  0x444dc404,
  0x000c0e00,
  0x444d4d04,
  0x444d4c04,
  0x000dc000,
},
{ /* 0x43a */
  0xcccc4c4c,
  0x44cccc44,
  0x4cdeedc4,
  0xcdeffedc,
  0xcdeffedc,
  0x4cdeedc4,
  0x44cccc44,
  0000000000,
},
{ /* 0x43b */
  0xcccc44cc,
  0x444ccccc,
  0x44ceeeee,
  0x4cefffff,
  0x4cdeeeee,
  0x44cddddd,
  0x444ccccc,
  0000000000,
},
{ /* 0x43c */
  0xcccc4c4c,
  0xcccc4444,
  0xeeedc444,
  0xfffedc44,
  0xeeeddc44,
  0xddddcc44,
  0xcccc4444,
  0000000000,
},
{ /* 0x43d */
  0xcccc44cc,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0x43e */
  0xcccc4c4c,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0x43f */
  0xcccc0ccc,
  0x44440444,
  0x44440444,
  0x44440444,
  0x44440444,
  0x44440444,
  0x44440444,
  0000000000,
},
{ /* 0x440 */
  0x44444444,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x441 */
  0x04040040,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x442 */
  0xdedddddc,
  0xddcccccc,
  0xdccdccc4,
  0xdcccc4cc,
  0xdccccccc,
  0xdc4c444c,
  0xdcc444c4,
  0xec444c4c,
},
{ /* 0x443 */
  0x44cdddc4,
  0xcccccc40,
  0xcccccc40,
  0xccdc4c40,
  0xcccc4c40,
  0x4ccccc40,
  0xcdcccc40,
  0xcccc4c40,
},
{ /* 0x444 */
  0xecc4c4c4,
  0xdcc44cdc,
  0xdcc4cded,
  0xdccc4cdc,
  0xccc4cccd,
  0xdccccccc,
  0xc4444444,
  0x40000000,
},
{ /* 0x445 */
  0xccdcc440,
  0xc4cc4c40,
  0xccccc440,
  0xdccc4c40,
  0xccc44440,
  0xc4c44440,
  0x44444440,
  0000000000,
},
{ /* 0x446 */
  0xddcccccc,
  0xdcc44444,
  0xcc44cc44,
  0xc44c4440,
  0xc4444044,
  0xc4444444,
  0xc4444040,
  0xc444c404,
},
{ /* 0x447 */
  0xcc4ccc40,
  0x44444400,
  0x44444400,
  0x4c404400,
  0xcdc44400,
  0x4c444400,
  0x44440400,
  0x04444400,
},
{ /* 0x448 */
  0x444cdc40,
  0x0444c4c4,
  0x44404444,
  0xc4444404,
  0xc4444040,
  0xc4444444,
  0x40000000,
  0000000000,
},
{ /* 0x449 */
  0x44440400,
  0x44c44000,
  0x44440000,
  0xc4444000,
  0000000000,
  0x04040000,
  0000000000,
  0000000000,
},
{ /* 0x44a */
  0xcdccccc4,
  0xcc444444,
  0xc44c4440,
  0xc4444044,
  0xc4444444,
  0xc4040004,
  0xc4400040,
  0xd4000404,
},
{ /* 0x44b */
  0x004ccc40,
  0x44444400,
  0x44444400,
  0x44c40400,
  0x44440400,
  0x04444400,
  0x4c444400,
  0x44440400,
},
{ /* 0x44c */
  0xd4404040,
  0xc44004c4,
  0xc4404cdc,
  0xc44404c4,
  0x4440444c,
  0xc4444444,
  0x40000000,
  0000000000,
},
{ /* 0x44d */
  0x44c44000,
  0x40440400,
  0x44444000,
  0xc4440400,
  0x44400000,
  0x40400000,
  0000000000,
  0000000000,
},
{ /* 0x44e */
  0x44444444,
  0x40000000,
  0x40000000,
  0x40000000,
  0000000000,
  0x40000000,
  0000000000,
  0x40000000,
},
{ /* 0x44f */
  0x44044400,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x450 */
  0x40000000,
  0000000000,
  0x40000000,
  0x40000000,
  0000000000,
  0x40000000,
  0000000000,
  0000000000,
},
{ /* 0x451 */
  0xcccccddd,
  0x00000ccd,
  0xeffeeddd,
  0xddcdedcd,
  0xcddccccc,
  0xcccccddc,
  0x4cc4cccc,
  0x04444444,
},
{ /* 0x452 */
  0xeeeeeeee,
  0xeddddddd,
  0xeddeeeee,
  0xedecccdd,
  0xedec4efc,
  0xedede4ef,
  0xeddefeee,
  0xeddddccc,
},
{ /* 0x453 */
  0xeeeeeeee,
  0xdddddddd,
  0xddd444de,
  0xecd444de,
  0xecd464de,
  0xecdc64de,
  0xcdd4e4de,
  0xdddc54dd,
},
{ /* 0x454 */
  0xeeeeeeed,
  0xdddddddc,
  0xeeeeedd4,
  0x11111cd4,
  0x11111cd4,
  0x11111cdc,
  0x11111cdc,
  0xccccccdc,
},
{ /* 0x455 */
  0xddddddc4,
  0xdccccc40,
  0xdccccc40,
  0xdcdc4c40,
  0xdccc4c40,
  0xdccccc40,
  0xddcccc40,
  0xdccc4c40,
},
{ /* 0x456 */
  0xccdcc440,
  0xd4cc4c40,
  0xdccccc40,
  0xcccc4c40,
  0xdcc4c440,
  0xc4cc4c40,
  0x44444440,
  0000000000,
},
{ /* 0x457 */
  0xeddeeeee,
  0xedecccdd,
  0xedec4efc,
  0xedede4ef,
  0xeddefeee,
  0xeddddccc,
  0xeddddddd,
  0xdccccccc,
},
{ /* 0x458 */
  0xddd454dd,
  0xecdc54d4,
  0xecd454d4,
  0xecdc54de,
  0xcdd454d4,
  0xddd444d4,
  0xdddddddd,
  0xcccccccc,
},
{ /* 0x459 */
  0xdddddddc,
  0xd4d4d4dc,
  0xd4dbd4dc,
  0xded4d4dc,
  0xd4d4d1dc,
  0xd4d4d4dc,
  0xdddddddc,
  0xcccccccc,
},
{ /* 0x45a */
  0x4cdcc4c4,
  0xcdeddcdc,
  0xcdeddcdc,
  0xcdeddcdc,
  0xcdeddcdc,
  0xcdeddcdc,
  0xcdeddcdc,
  0xcdeddcdc,
},
{ /* 0x45b */
  0x000dc000,
  0x000dc000,
  0x000dc000,
  0x000dc000,
  0x000dc000,
  0x000dc000,
  0x000dc000,
  0x000dc000,
},
{ /* 0x45c */
  0x000c4000,
  0x000c4000,
  0x000d4000,
  0x000dc000,
  0x000dc000,
  0x000dc000,
  0x000dc000,
  0x000dc000,
},
{ /* 0x45d */
  0x000dc000,
  0x000dc000,
  0x000dc000,
  0xdddddddd,
  0xcccccccc,
  0x000c4000,
  0x000d4000,
  0x000dc000,
},
{ /* 0x45e */
  0x000dc000,
  0xeeeeeeed,
  0xeddc4cdc,
  0xedd444ec,
  0xeddd4ddc,
  0xeddc4cdc,
  0xdcccdccc,
  0x000c4000,
},
{ /* 0x45f */
  0xc6c44c4c,
  0x45404444,
  0x46404444,
  0x46cc6c55,
  0x45404444,
  0x46400000,
  0x45404444,
  0x05000000,
},
{ /* 0x460 */
  0xcccc46c4,
  0x44444540,
  0x44444640,
  0x55555540,
  0x44444640,
  0x00000600,
  0x44444540,
  0x00000600,
},
{ /* 0x461 */
  0xedccccc4,
  0xed444444,
  0xedcdeede,
  0xed4cdddd,
  0xed444444,
  0xed040004,
  0xdd400040,
  0xed000404,
},
{ /* 0x462 */
  0x004ccced,
  0x444444fd,
  0xeefeffed,
  0xdddddddd,
  0x444404dd,
  0x044444ed,
  0x4c4444ed,
  0x444404ed,
},
{ /* 0x463 */
  0x00090000,
  0x000a0000,
  0x000a0000,
  0x000a9000,
  0x009b9000,
  0x00ab9900,
  0x00aba900,
  0x00aba900,
},
{ /* 0x464 */
  0000000000,
  0x00000700,
  0x00700700,
  0x00807700,
  0x078f8700,
  0x078f8700,
  0x078f8700,
  0x078f8700,
},
{ /* 0x465 */
  0x4000000c,
  0x0000000c,
  0x40040010,
  0x40000000,
  0000000000,
  0x40000000,
  0000000000,
  0000000000,
},
{ /* 0x466 */
  0x00000400,
  0000000000,
  0xc0000000,
  0xc0000000,
  0x01000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x467 */
  0x04cdefff,
  0x04cdefff,
  0x04cdefff,
  0x04cdefff,
  0x04cdefff,
  0x04cdefff,
  0x04cdefff,
  0x04cdefff,
},
{ /* 0x468 */
  0xfeedcc40,
  0xfeedcc40,
  0xfeedcc40,
  0xfeedcc40,
  0xfeedcc40,
  0xfeedcc40,
  0xfeedcc40,
  0xfeedcc40,
},
{ /* 0x469 */
  0000000000,
  0x44444444,
  0xcccccccc,
  0xdddddddd,
  0xeeeeeeee,
  0xffffffff,
  0xffffffff,
  0xffffffff,
},
{ /* 0x46a */
  0xffffffff,
  0xeeeeeeee,
  0xeeeeeeee,
  0xdddddddd,
  0xcccccccc,
  0xcccccccc,
  0x44444444,
  0000000000,
},
{ /* 0x46b */
  0x04cdefff,
  0x04cdefff,
  0x04cdefff,
  0x04cddfff,
  0x04ccdeff,
  0x04ccddff,
  0x04cddeff,
  0x04cdefff,
},
{ /* 0x46c */
  0xfeedcc40,
  0xfeedc440,
  0xfedc4440,
  0xfed44c40,
  0xfedc4c40,
  0xfefcc440,
  0xfeefc440,
  0xfeedcc40,
},
{ /* 0x46d */
  0000000000,
  0x44c44444,
  0xccd4cccc,
  0xddecdddd,
  0xeefdeeee,
  0xfffeffff,
  0xfffeffff,
  0xfffeffff,
},
{ /* 0x46e */
  0xfffeffff,
  0xeefdeeee,
  0xeefdeeee,
  0xddecdddd,
  0xccd4cccc,
  0xccd4cccc,
  0x44c44444,
  0000000000,
},
{ /* 0x46f */
  0xc4c4cc4c,
  0x44444400,
  0x444404cc,
  0x44404cdd,
  0x4404ddee,
  0x404cdeee,
  0x40cdeeef,
  0x00cdeefe,
},
{ /* 0x470 */
  0x000000d0,
  0x4cccc0e4,
  0xddddd0e4,
  0xeeeee0fc,
  0xefefe0ed,
  0xfefef0fe,
  0xefefe0ee,
  0xfffff0fe,
},
{ /* 0x471 */
  0x04deefff,
  0x0cdefeff,
  0x0cdeefef,
  0x0cdefeff,
  0x0cdeffff,
  0000000000,
  0xdeffffff,
  0x044cdeee,
},
{ /* 0x472 */
  0xeffff0ee,
  0xfffff0ed,
  0xfffff0fd,
  0xffeff0fc,
  0xfffff0e4,
  0x000000f4,
  0xffffeff4,
  0xeddc4400,
},
{ /* 0x473 */
  0x0d000000,
  0x4e0cccc4,
  0x4e0ddddd,
  0xcf0eeeee,
  0xde0efefe,
  0xef0fefef,
  0xee0efefe,
  0xef0fffff,
},
{ /* 0x474 */
  0000000000,
  0000000000,
  0xcc400000,
  0xddc40000,
  0xeedd4000,
  0xeeedc400,
  0xfeeedc00,
  0xefeedc00,
},
{ /* 0x475 */
  0xee0ffffe,
  0xde0fffff,
  0xdf0fffff,
  0xcf0ffeff,
  0x4e0fffff,
  0x4f000000,
  0x4ffeffff,
  0x0044cdde,
},
{ /* 0x476 */
  0xfffeed40,
  0xffefedc0,
  0xfefeedc0,
  0xffefedc0,
  0xffffedc0,
  0000000000,
  0xffffffed,
  0xeeedc440,
},
{ /* 0x477 */
  0x044cdeee,
  0xdeffffff,
  0000000000,
  0x0cdeffff,
  0x0cdefeff,
  0x0cdeefef,
  0x0cdefeff,
  0x04deefff,
},
{ /* 0x478 */
  0xeddc4400,
  0xffffeff4,
  0x000000f4,
  0xfffff0e4,
  0xffeff0fc,
  0xfffff0fd,
  0xfffff0ed,
  0xeffff0ee,
},
{ /* 0x479 */
  0x00cdeefe,
  0x00cdeeef,
  0x404cdeee,
  0x4004ddee,
  0x44004cdd,
  0x444004cc,
  0x44440000,
  0000000000,
},
{ /* 0x47a */
  0xfffff0fe,
  0xefefe0ee,
  0xfefef0fe,
  0xefefe0ed,
  0xeeeee0fc,
  0xddddd0e4,
  0x4cccc0e4,
  0x000000d0,
},
{ /* 0x47b */
  0x0044cdde,
  0x4ffeffff,
  0x4f000000,
  0x4e0fffff,
  0xcf0ffeff,
  0xdf0fffff,
  0xde0fffff,
  0xee0ffffe,
},
{ /* 0x47c */
  0xeeedc440,
  0xffffffed,
  0000000000,
  0xffffedc0,
  0xffefedc0,
  0xfefeedc0,
  0xffefedc0,
  0xfffeed40,
},
{ /* 0x47d */
  0xef0fffff,
  0xee0efefe,
  0xef0fefef,
  0xde0efefe,
  0xcf0eeeee,
  0x4e0ddddd,
  0x4e0cccc4,
  0x0d000000,
},
{ /* 0x47e */
  0xefeedc00,
  0xfeeedc00,
  0xeeedc400,
  0xeedd4000,
  0xddc40000,
  0xcc400000,
  0000000000,
  0000000000,
},
{ /* 0x47f */
  0x0ab3ba90,
  0xab3f3ba9,
  0xab3f3ba9,
  0xab3f3ba9,
  0xab3f3ba9,
  0xab3f3ba9,
  0x09aba940,
  0x0ab3ba90,
},
{ /* 0x480 */
  0x4cc44090,
  0x44409aa0,
  0x440aaab0,
  0x40aabbb0,
  0x09abb3b0,
  0x0aab33a0,
  0x9abbba90,
  0000000000,
},
{ /* 0x481 */
  0x09000000,
  0x0aa94000,
  0x0baaa400,
  0x0bbbaa40,
  0x0b3bba90,
  0x0a33baa0,
  0x09abbba9,
  0000000000,
},
{ /* 0x482 */
  0000000000,
  0x9abbba90,
  0x0aab33a0,
  0x09abb3b0,
  0x04aabbb0,
  0x004aaab0,
  0x00049aa0,
  0x00000090,
},
{ /* 0x483 */
  0000000000,
  0x09abbba9,
  0x0a33baa0,
  0x0b3bba90,
  0x0bbbaa40,
  0x0baaa400,
  0x0aa94000,
  0x09000000,
},
{ /* 0x484 */
  0x09aba940,
  0x09aba940,
  0x09aba940,
  0x09aba940,
  0x09aba940,
  0x09aba940,
  0x09aba940,
  0x09aba940,
},
{ /* 0x485 */
  0000000000,
  0x90909090,
  0xa0a0a0a0,
  0xbabababa,
  0xa0a0a0a0,
  0x90909090,
  0x40404040,
  0000000000,
},
{ /* 0x486 */
  0x44444444,
  0x49999999,
  0x99aaaaaa,
  0xaabbbbbb,
  0xaaabbbbb,
  0x999aaaaa,
  0x44449999,
  0000000000,
},
{ /* 0x487 */
  0x44444444,
  0x99999999,
  0xaaaaaaaa,
  0xbbbbbbbb,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0x99999999,
  0000000000,
},
{ /* 0x488 */
  0x44999944,
  0x99aaaa49,
  0xaabbbb9a,
  0xbb3333ab,
  0xbb3333ab,
  0xaabbbb9a,
  0x99aaaa49,
  0x00999900,
},
{ /* 0x489 */
  0xc099aaaa,
  0x09ab3bb3,
  0x0ab3f3fa,
  0x0aabbbba,
  0x09aaaaaa,
  0x40999999,
  0x40009999,
  0000000000,
},
{ /* 0x48a */
  0xaaaacccc,
  0xb33bdddd,
  0xa9a3eeff,
  0x3b9bdddd,
  0x99aacccc,
  0x99994444,
  0x99994444,
  0000000000,
},
{ /* 0x48b */
  0xcccccccc,
  0xeededddd,
  0xfffefefe,
  0xdedddddd,
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0x48c */
  0xcccccccc,
  0xdddeeded,
  0xeeeefeef,
  0xdddddddd,
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0x48d */
  0xcccccccc,
  0xeddddddd,
  0xefffffef,
  0xdde9a1cd,
  0xccda1bcc,
  0x44cdddc4,
  0x44444444,
  0000000000,
},
{ /* 0x48e */
  0xc0000000,
  0xdccccccc,
  0xfedddddd,
  0xdccccccc,
  0xc4444444,
  0x44444444,
  0x40000000,
  0000000000,
},
{ /* 0x48f */
  0x4ccddeed,
  0xc44ceddd,
  0xdee44444,
  0xcdddcccd,
  0x4cc44444,
  0x444ccccc,
  0x44444444,
  0000000000,
},
{ /* 0x490 */
  0x000ec000,
  0x0ceedcc0,
  0x0e0dc0d0,
  0x0e0000d0,
  0x0e0000e0,
  0x0d0ee0e0,
  0x0cdfdcc0,
  0x000ec000,
},
{ /* 0x491 */
  0xd000000d,
  0xecccccce,
  0xedddddde,
  0xfeeeeeef,
  0xfeeeeeef,
  0xfeeeeeef,
  0xfeeeeeef,
  0xedddddde,
},
{ /* 0x492 */
  0x0000000d,
  0xccccccce,
  0xddddddde,
  0xeeeeeeef,
  0xeeeeeeef,
  0xeeeeeeef,
  0xeeeeeeef,
  0xddddddde,
},
{ /* 0x493 */
  0x000000d0,
  0xcccccce0,
  0xdddddde0,
  0xeeeeeef0,
  0xeeeeeef0,
  0xeeeeeef0,
  0xeeeeeef0,
  0xdddddde0,
},
{ /* 0x494 */
  0xedddddde,
  0xecccccce,
  0xdddddddd,
  0xdccccccd,
  0xc444444c,
  0xc000000c,
  0x44444444,
  0xc000000c,
},
{ /* 0x495 */
  0xddddddde,
  0xccccccce,
  0xdddddddd,
  0xcccccccd,
  0x4444444c,
  0x0000000c,
  0x44444444,
  0x0000000c,
},
{ /* 0x496 */
  0xdddddde0,
  0xcccccce0,
  0xddddddd0,
  0xccccccd0,
  0x444444c0,
  0x000000c0,
  0x44444440,
  0x000000c0,
},
{ /* 0x497 */
  0x0bbbbbbb,
  0x0aaaaaaa,
  0x0aa44994,
  0x0aa99aa9,
  0x0aa00ba0,
  0x0aa99ba9,
  0x0aa99ba9,
  0x0aa00ba0,
},
{ /* 0x498 */
  0xabbbbbbb,
  0xaaaaaaaa,
  0x49944994,
  0x9aa99aa9,
  0x0aa00ba0,
  0x9aa99ba9,
  0x9ba99ba9,
  0x0aa00ba0,
},
{ /* 0x499 */
  0xbbbbaba0,
  0xaaaaaaa0,
  0x49944aa0,
  0x9aa99ba0,
  0x0ba00ba0,
  0xaaa9aaa0,
  0x9ba99ba0,
  0x0ba00aa0,
},
{ /* 0x49a */
  0x0aa99aa9,
  0x0aa99ba9,
  0x0aa00ba0,
  0x0aa9abaa,
  0x0aa99ba9,
  0x0aabbbaa,
  0x0aaaaaaa,
  0000000000,
},
{ /* 0x49b */
  0xaba9aba9,
  0x9ba99ba9,
  0x0ba00ba0,
  0xaba9abaa,
  0x9ba99ba9,
  0xbaabbbab,
  0xaaaaaaaa,
  0000000000,
},
{ /* 0x49c */
  0xabaaaba0,
  0x9ba99ba0,
  0x0aa00ba0,
  0xaba9aba0,
  0x9ba99ba0,
  0xbaaabba0,
  0xaaaaaaa0,
  0000000000,
},
{ /* 0x49d */
  0xdeeffeee,
  0xdddddddd,
  0xdddddddd,
  0xdddddddd,
  0xdddcdddc,
  0xddddcdcd,
  0xdcccccdc,
  0000000000,
},
{ /* 0x49e */
  0xedeecede,
  0xdddfcddd,
  0xdddecddd,
  0xdddecddd,
  0xccddccdd,
  0xddddcdcc,
  0xcdcdcccd,
  0x00cdc000,
},
{ /* 0x49f */
  0xedeedede,
  0xddddcddd,
  0xdddddddd,
  0xdddddddd,
  0xccdddcdd,
  0xdddcddcc,
  0xcdcccccd,
  0000000000,
},
{ /* 0x4a0 */
  0xdeededcd,
  0xcddcdddc,
  0xdcdddddd,
  0xddddcdcd,
  0xcdddcddc,
  0xdcdcdccc,
  0xcdcccccc,
  0000000000,
},
{ /* 0x4a1 */
  0xcdeeeeee,
  0xcdedeeee,
  0xcdedeeee,
  0xcdeeeeee,
  0xdeffffff,
  0xdefeffff,
  0xdefeffff,
  0xdeffffff,
},
{ /* 0x4a2 */
  0xddcdc444,
  0xdcdcdc44,
  0xedcdc4c4,
  0xdccddc44,
  0xeededccc,
  0xedededcc,
  0xfededcdc,
  0xeddeedcc,
},
{ /* 0x4a3 */
  0xdefeffff,
  0xdeffffff,
  0xdefeffff,
  0xdefeffff,
  0xdeffffff,
  0xddfeffff,
  0xdeffffff,
  0xeefeffff,
},
{ /* 0x4a4 */
  0xeededdcc,
  0xeddeedcc,
  0xfededcdc,
  0xedededcc,
  0xeededccc,
  0xfededdcc,
  0xeeeddcdc,
  0xeededdcc,
},
{ /* 0x4a5 */
  0000000000,
  0x0cdccccc,
  0x0cdccccc,
  0x4deddddd,
  0xdefeeeee,
  0xdefeeeee,
  0xdefeeeee,
  0xdefeeeee,
},
{ /* 0x4a6 */
  0000000000,
  0xccccc400,
  0xccccc400,
  0xdddddc40,
  0xeeeeedc0,
  0xeeeeedc0,
  0xeeeeedc0,
  0xeeeeedc0,
},
{ /* 0x4a7 */
  0xdefeeeee,
  0xdefeeeee,
  0xdefeeeee,
  0xdefeeeee,
  0xdefeeeee,
  0xdefeeeee,
  0xdefeeeee,
  0xdefeeeee,
},
{ /* 0x4a8 */
  0xeeeeedc0,
  0xeeeeedc0,
  0xeeeeedc0,
  0xeeeeedc0,
  0xeeeeedc0,
  0xeeeeedc0,
  0xeeeeedc0,
  0xeeeeedc0,
},
{ /* 0x4a9 */
  0x0ccddddd,
  0x0cdeeeee,
  0x0deeeeee,
  0x0fffffff,
  0x40099ab3,
  0x44000000,
  0x44444444,
  0000000000,
},
{ /* 0x4aa */
  0xddddddcf,
  0xeeeeeeec,
  0xeeeeeeee,
  0xffffffff,
  0x3333ffff,
  0000000000,
  0x44444440,
  0000000000,
},
{ /* 0x4ab */
  0xdcdddddd,
  0xceeeeeee,
  0xeeeeeeee,
  0xffffffff,
  0xfff3f333,
  0000000000,
  0x44444444,
  0000000000,
},
{ /* 0x4ac */
  0xdddddcc0,
  0xeeeeedc0,
  0xeeeeeed0,
  0xfffffff0,
  0x3ba99000,
  0x00000040,
  0x44444440,
  0000000000,
},
{ /* 0x4ad */
  0xaaaaaaaa,
  0xbbebbdbb,
  0xaaaaaaaa,
  0xacccccca,
  0xaaaaaaaa,
  0xcacccaca,
  0xaaaaaaaa,
  0xcccccccc,
},
{ /* 0x4ae */
  0xaaaaaaaa,
  0xbbeebeeb,
  0xaaaaaaaa,
  0xaccaaacc,
  0xaaaaaaaa,
  0xaaccccaa,
  0xaaaaaaaa,
  0xcccccccc,
},
{ /* 0x4af */
  0xaaaaaaaa,
  0xbbeccccc,
  0xaaceeeee,
  0xacefffff,
  0xacdeeeee,
  0xcacddddd,
  0xaaaccccc,
  0xcccccccc,
},
{ /* 0x4b0 */
  0xaaaaaaaa,
  0xccccbeeb,
  0xeeedcaaa,
  0xfffedc11,
  0xeeeddc99,
  0xddddccaa,
  0xccccaaaa,
  0xcccccccc,
},
{ /* 0x4b1 */
  0xaaaaaaaa,
  0xbbeebeeb,
  0xadddaaaa,
  0x1eeecacc,
  0x9dddcaaa,
  0xaaccccaa,
  0xaaaaaaaa,
  0xcccccccc,
},
{ /* 0x4b2 */
  0xabaa9aa9,
  0xaa9aaa99,
  0xab9a9aa9,
  0xab9aaaa9,
  0xabaa99a9,
  0xaa9a9aa9,
  0xabaa9a99,
  0xabaaaaa9,
},
{ /* 0x4b3 */
  0xaa9a9a99,
  0xaa9aaaa9,
  0xaba9a9a9,
  0xabaaa9a9,
  0xab9a9a99,
  0xabaaaaa9,
  0xab99a9a9,
  0xab99aaa9,
},
{ /* 0x4b4 */
  0xaaaaaaaa,
  0xbbbbbbbb,
  0x99999999,
  0x55555555,
  0x55555555,
  0x55555555,
  0x55555555,
  0x5555555e,
},
{ /* 0x4b5 */
  0xaaaaaaaa,
  0xbbbbbbbb,
  0x99999999,
  0x66666666,
  0x66eeeeee,
  0x6effffff,
  0xeffffffe,
  0xffffffe6,
},
{ /* 0x4b6 */
  0xaaaaaaa0,
  0xbbbbbbb0,
  0x99999990,
  0x55555550,
  0xee555550,
  0xe5555550,
  0x55555550,
  0x55555550,
},
{ /* 0x4b7 */
  0x555555ef,
  0x555555ef,
  0x5555555e,
  0x55555555,
  0x55555555,
  0x55555555,
  0x55555555,
  0x55555555,
},
{ /* 0x4b8 */
  0xfffffe66,
  0xffffe666,
  0xfffffe66,
  0xefffffe6,
  0x5efffffe,
  0x55efffe6,
  0x55effe66,
  0x5effe666,
},
{ /* 0x4b9 */
  0x00dedc00,
  0x00dedc00,
  0x00dedc00,
  0x00cdcc00,
  0x00dedc00,
  0x00dedc00,
  0x00dedc00,
  0x00dedc00,
},
{ /* 0x4ba */
  0xdeeffffe,
  0x0cdeeeed,
  0x0cdeeeed,
  0x0cdeeeed,
  0x0cdeeeed,
  0x0cdeeeed,
  0x0cdeeeed,
  0xdeeffffe,
},
{ /* 0x4bb */
  0xeeddcc4c,
  0xdcdc4040,
  0xdcdc4040,
  0xdcdc4040,
  0xdcdc4040,
  0xdcdc4040,
  0xdcdc4040,
  0xeeddcc4c,
},
{ /* 0x4bc */
  0xcccc404c,
  0x444444cd,
  0x44440cde,
  0x44444cee,
  0x4444cded,
  0x4440cdec,
  0x4444cdec,
  0x000c7ddc,
},
{ /* 0x4bd */
  0xc4040404,
  0x4c400000,
  0x74c00000,
  0x74c40000,
  0x744c0000,
  0x74470000,
  0x74474000,
  0x74447000,
},
{ /* 0x4be */
  0xcc0cdddc,
  0x444ccd87,
  0x44ccce87,
  0x44cdc887,
  0x40cdc887,
  0x4478c887,
  0x4778cedc,
  0x077dcedc,
},
{ /* 0x4bf */
  0xdc4cd004,
  0x74447400,
  0x74444700,
  0x74744700,
  0x74444700,
  0x74744740,
  0xc4744470,
  0xc4c44470,
},
{ /* 0x4c0 */
  0x0004ccc4,
  0x47cdeedc,
  0xcdcdeedc,
  0xcdcdeedc,
  0xcdcdeedc,
  0xcdcdeedd,
  0xddcdeeed,
  0xedceffed,
},
{ /* 0x4c1 */
  0x44000040,
  0xc44c4474,
  0xcc4c44cc,
  0xcc4cc4cd,
  0xcddec4cd,
  0xeedecccd,
  0xeedec4cc,
  0xeedecc4c,
},
{ /* 0x4c2 */
  0xcccccc4d,
  0x4444444c,
  0x49b9044d,
  0x49aa9aad,
  0x49aa9aad,
  0x49a9044d,
  0x49a9040c,
  0x09a9004c,
},
{ /* 0x4c3 */
  0xedefffed,
  0xdccddddc,
  0xeeffffed,
  0xeeffffed,
  0xeeffffed,
  0xeeffffed,
  0xddefffed,
  0xdceeefed,
},
{ /* 0x4c4 */
  0xeedecc4c,
  0xdccc4444,
  0xeeedec4c,
  0xeeedec4c,
  0xeeedec4c,
  0xeeedec4c,
  0xeeeddc44,
  0xeeedd444,
},
{ /* 0x4c5 */
  0xd4444444,
  0x40000000,
  0xc0009990,
  0xc9aabba9,
  0xc9aaaba9,
  0xc0009a90,
  0xc0009a90,
  0x74009a90,
},
{ /* 0x4c6 */
  0xc9a904cc,
  0x49a904cd,
  0x9aba94cd,
  0x9aba944c,
  0x449404cd,
  0x49a90478,
  0x49a90478,
  0x09a90078,
},
{ /* 0x4c7 */
  0xdceeeded,
  0xcdeeedd7,
  0xcdeee887,
  0x4cdcdcc4,
  0x78eee887,
  0x78eee887,
  0x78eee887,
  0x78eee887,
},
{ /* 0x4c8 */
  0xeed74744,
  0x87774744,
  0x87774744,
  0xc4c44444,
  0x87774c44,
  0x877c4c44,
  0x87cc4c44,
  0x87cc4c44,
},
{ /* 0x4c9 */
  0x47049a90,
  0x47009a90,
  0x4c009a90,
  0x4400aba0,
  0x4c000900,
  0x4c009a90,
  0x4c009a90,
  0x4c009a90,
},
{ /* 0x4ca */
  0xbab90478,
  0xa9a904c8,
  0xa9990ac8,
  0xa9a90acd,
  0xa9a904cd,
  0xaab9047d,
  0x49a9044c,
  0x49990078,
},
{ /* 0x4cb */
  0x78eee887,
  0x78eee887,
  0x78eee887,
  0x78eee8dc,
  0xc8eeeddc,
  0xcdeeedd7,
  0x4ccdccc4,
  0x78eee887,
},
{ /* 0x4cc */
  0x8ccc4c44,
  0x8ccc4c44,
  0xdccc4744,
  0xdcc74744,
  0xd7774744,
  0xd7774744,
  0xc4444444,
  0x87774744,
},
{ /* 0x4cd */
  0x4c449a94,
  0x47009a90,
  0x479a9a90,
  0x479a9a90,
  0x47009a90,
  0x47009a90,
  0x4409ba90,
  0x4c09a900,
},
{ /* 0x4ce */
  0xc9a90478,
  0x49a90478,
  0x49a9044d,
  0x49a904c4,
  0x499abae4,
  0x49a904c4,
  0x49a9044d,
  0x09a900cd,
},
{ /* 0x4cf */
  0x78eee887,
  0x78eee887,
  0xcdeeed87,
  0xcdeee887,
  0xcdeee887,
  0xcdee888c,
  0xcdee888c,
  0xcde888dc,
},
{ /* 0x4d0 */
  0x87774744,
  0x87774c44,
  0x877c4c44,
  0x87cc4c44,
  0x8ccddd44,
  0xdcdedec4,
  0xddeedec4,
  0xdeeedecc,
},
{ /* 0x4d1 */
  0x4c49a940,
  0x4c09a900,
  0x4c09a900,
  0x4c09a900,
  0x4c09aa90,
  0x4c009a90,
  0xcd009a90,
  0xcd009a90,
},
{ /* 0x4d2 */
  0xc9a90ccd,
  0x49a904cd,
  0x49a904de,
  0x49a90404,
  0x9aba9404,
  0x9aba94cd,
  0x449404cd,
  0x09a900cd,
},
{ /* 0x4d3 */
  0xcd88eddc,
  0xcdeeeddd,
  0xeefffeed,
  0xddfeefdc,
  0xcdeeeedc,
  0xcefffedc,
  0xcefffedc,
  0xcefffedc,
},
{ /* 0x4d4 */
  0xeeeedec4,
  0xeeeedecc,
  0xeeeedec4,
  0xec4d44c4,
  0xdc4c4404,
  0xeeeedec4,
  0xeeeedec4,
  0xeeeedec4,
},
{ /* 0x4d5 */
  0xcd9aaba9,
  0xcd4aaba9,
  0xcd4aaba9,
  0xc0009a90,
  0x00004940,
  0x4d009a90,
  0x4d009a90,
  0x4d009a90,
},
{ /* 0x4d6 */
  0xc9a900ce,
  0x49a4d0cd,
  0x49a0c0cd,
  0x494d40cd,
  0x490c40cd,
  0x44d470cd,
  0x40c470cd,
  0x0d47770c,
},
{ /* 0x4d7 */
  0xceffeeee,
  0xceffeeec,
  0xcefeeedd,
  0xcefedc4e,
  0xcefdc4ce,
  0xceecc4cd,
  0xceecc4ce,
  0xdcecc4cf,
},
{ /* 0x4d8 */
  0xeeeedc4c,
  0xeeeec4c4,
  0x4ccc4c4c,
  0x4ccc4444,
  0xc4cc4c44,
  0xc4c44444,
  0xc4cc4c44,
  0xc4c4c444,
},
{ /* 0x4d9 */
  0xdc009a90,
  0xdc0c0a90,
  0xdc0c0990,
  0xcc00c090,
  0x4c00c090,
  0x4c0c0c00,
  0x4c0c0c00,
  0xc0ccc0c0,
},
{ /* 0x4da */
  0x0c4777dc,
  0xd447778c,
  0xd44444dc,
  0xd44dd8dc,
  0xd44787dc,
  0xdc47778c,
  0xd444448c,
  0xc44d8880,
},
{ /* 0x4db */
  0xdcecc4cf,
  0xdcec74cf,
  0xdcec74cf,
  0xdce774ce,
  0xdce774cf,
  0xdce774ce,
  0xdce774ce,
  0xcde774cd,
},
{ /* 0x4dc */
  0xc4cc4444,
  0xc4c4c44c,
  0xc4cc444c,
  0xc4c4c4cc,
  0xc4cc4ccc,
  0xc4c4dccc,
  0xc4cddccc,
  0xc4ddcccd,
},
{ /* 0x4dd */
  0xc0777dc0,
  0xd0777d0c,
  0xd0444d0c,
  0xd0eeed0c,
  0xd0d77d0c,
  0xd0ed7dcc,
  0xd0444d0c,
  0x0deeeddc,
},
{ /* 0x4de */
  0xdc477780,
  0xc4487780,
  0xdc444480,
  0xc44d88d0,
  0xcc478787,
  0xdc477787,
  0xcc444487,
  0xcc48d8d7,
},
{ /* 0x4df */
  0xcde774ce,
  0xcde874cd,
  0xcde874cd,
  0xcdd874ce,
  0x0cd874cd,
  0x0788774e,
  0x0788774d,
  0x7078874d,
},
{ /* 0x4e0 */
  0xc4cdcccd,
  0xc4cccccd,
  0xc4cc4ccd,
  0xc4cc44cd,
  0xc4c444c0,
  0x4cc444c0,
  0x4cc444c0,
  0x4c444c0d,
},
{ /* 0x4e1 */
  0x0dedddcd,
  0x0ddedd0d,
  0x0d444dcd,
  0x0deeed0c,
  0xdddfdddc,
  0xddeeddcc,
  0xdd444d0c,
  0xddeeedcc,
},
{ /* 0x4e2 */
  0xcc4777d7,
  0xcd477777,
  0xc8477777,
  0xcf47777c,
  0x0f4c77cc,
  0xc84c7c00,
  0xcd4c7044,
  0xcccc0000,
},
{ /* 0x4e3 */
  0x7078874d,
  0x7c07874d,
  0xcc00004d,
  0xcc0cc04d,
  0xcc0dce0c,
  0x000dcd0c,
  0x44400004,
  0000000000,
},
{ /* 0x4e4 */
  0x4c444c0d,
  0x4c44c0cc,
  0x400000cc,
  0x400cc0cc,
  0x00ded0cc,
  0x00dcd000,
  0x00000444,
  0000000000,
},
{ /* 0x4e5 */
  0xddddcccc,
  0xddddc0cc,
  0xdddcd0cc,
  0xcddce0cc,
  0xcdcce0c0,
  0x00cce0cc,
  0x000cd0cc,
  0x0000cccc,
},
{ /* 0x4e6 */
  0x0ba0c949,
  0x0ba09949,
  0x0ba09909,
  0x0ba00004,
  0x0ba0ac49,
  0x0ba09999,
  0x0ba09c99,
  0x0ba00004,
},
{ /* 0x4e7 */
  0xaaaa4ba0,
  0xc9994ba0,
  0x999c4ba0,
  0x40444ba0,
  0xc94a4ba0,
  0x994a4ba0,
  0x99094ba0,
  0x40004ba0,
},
{ /* 0x4e8 */
  0x55555550,
  0x55555550,
  0x55555550,
  0x55555550,
  0x55555550,
  0x55555550,
  0x55555550,
  0x55555550,
},
{ /* 0x4e9 */
  0x55555555,
  0x55555555,
  0x55555555,
  0x5555555e,
  0x5555555e,
  0x55555555,
  0xaaaaaaaa,
  0xbbbbbbbb,
},
{ /* 0x4ea */
  0x5efe6666,
  0xefe66666,
  0xee666666,
  0xe6666666,
  0x66666666,
  0x66666666,
  0xaaaaaaaa,
  0xbbbbbbbb,
},
{ /* 0x4eb */
  0x55555550,
  0x55555550,
  0x55555550,
  0x55555550,
  0x55555550,
  0x55555550,
  0xaaaaaaa0,
  0xbbbbbbb0,
},
{ /* 0x4ec */
  0000000000,
  0xeeeeeeee,
  0xcccccccc,
  0xddcf0ecc,
  0xdcfe0eec,
  0xdcfe000c,
  0xdcfeeeec,
  0xcc4eee4c,
},
{ /* 0x4ed */
  0000000000,
  0xeeeeeee0,
  0xccccccc4,
  0xdddddddc,
  0xcd1cd8c4,
  0xcdccdcc4,
  0xcdddddd0,
  0xccccccc0,
},
{ /* 0x4ee */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x4ef */
  0x001b1900,
  0x000a9000,
  0xaaaaaaaa,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0x99919999,
  0x00019000,
  0x001b1900,
},
{ /* 0x4f0 */
  0x00a29000,
  0x00a29000,
  0x00a29000,
  0x00a29000,
  0x00a29000,
  0x00a29000,
  0x00a29000,
  0x00a29000,
},
{ /* 0x4f1 */
  0x00a29000,
  0x00a29000,
  0xaaa299aa,
  0xbba29abb,
  0xaaa299aa,
  0x99a29999,
  0x00a29000,
  0x00a29000,
},
{ /* 0x4f2 */
  0x00a29000,
  0x00a29000,
  0xaaaaaaaa,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0x99999999,
  0x009a9000,
  0x00a29000,
},
{ /* 0x4f3 */
  0x06555550,
  0x06555550,
  0x06555550,
  0x06566550,
  0x06565c50,
  0x0655cc50,
  0x06555550,
  0x06555550,
},
{ /* 0x4f4 */
  0x06555550,
  0x06555550,
  0x06566550,
  0x06565c50,
  0x0655cc50,
  0x06555550,
  0x06555550,
  0x66666665,
},
{ /* 0x4f5 */
  0x06555550,
  0x06555550,
  0xaaaaaaaa,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0x99999999,
  0x055cccc0,
  0x065555c0,
},
{ /* 0x4f6 */
  0000000000,
  0000000000,
  0xaaaaaaaa,
  0xbbbbbbbb,
  0xaaaaaaaa,
  0x99999999,
  0000000000,
  0000000000,
},
{ /* 0x4f7 */
  0xeeeeeeee,
  0xdddddddd,
  0xcccccccc,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x4f8 */
  0xeededeee,
  0xdcdfdcdd,
  0xccdedccc,
  0x00cdc000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x4f9 */
  0000000000,
  0x44444444,
  0xcccccccc,
  0xdddddddd,
  0xeeeeeeee,
  0xffffffff,
  0xffffffff,
  0xffffffff,
},
{ /* 0x4fa */
  0xbbbbbbbb,
  0xaaaaaaaa,
  0000000000,
  0000000000,
  0000000000,
  0xdddddddd,
  0xcccccccc,
  0000000000,
},
{ /* 0x4fb */
  0xbbbbbbbb,
  0xaaaaaaaa,
  0x09999990,
  0x0aaaaaa0,
  0x0aaaaaa0,
  0xdddddddd,
  0xcccccccc,
  0000000000,
},
{ /* 0x4fc */
  0xbaababa9,
  0xaaaaaaa9,
  0000000000,
  0000000000,
  0000000000,
  0xdddddddd,
  0xcccccccc,
  0000000000,
},
{ /* 0x4fd */
  0xabbbbbbb,
  0x99aaaaaa,
  0000000000,
  0000000000,
  0000000000,
  0xccccdddd,
  0x44444ccc,
  0000000000,
},
{ /* 0x4fe */
  0x66666666,
  0x55555555,
  0x55665555,
  0x556fc555,
  0x555cc555,
  0x55555555,
  0xcccccccc,
  0000000000,
},
{ /* 0x4ff */
  0xeeeeeee6,
  0x66666665,
  0x5555555c,
  0xcccccccc,
  0xccccccc5,
  0x5555555c,
  0x6666666c,
  0x55555550,
},
{ /* 0x500 */
  0xbbbbbbbb,
  0xaaaaaaaa,
  0000000000,
  0000000000,
  0000000000,
  0xdddddddd,
  0xcccccccc,
  0000000000,
},
{ /* 0x501 */
  0xc099aaaa,
  0x09ab3bb3,
  0x0ab3f3fa,
  0x0aabbbba,
  0x09aaaaaa,
  0x40999999,
  0x40009999,
  0000000000,
},
{ /* 0x502 */
  0xcccccccc,
  0xeededddd,
  0xfffefefe,
  0xdedddddd,
  0xcccccccc,
  0x44444444,
  0x44444444,
  0000000000,
},
{ /* 0x503 */
  0x4ccddeed,
  0xc44ceddd,
  0xdee44444,
  0xcdddcccd,
  0x4cc44444,
  0x444ccccc,
  0x44444444,
  0000000000,
},
{ /* 0x504 */
  0xeeeeeeee,
  0xe6666666,
  0xe6555555,
  0xe6566555,
  0xe6565455,
  0xe6554455,
  0xe6555555,
  0xe6555555,
},
{ /* 0x505 */
  0xeeeeeee6,
  0x66666665,
  0x55555565,
  0x55665565,
  0x55654565,
  0x55544565,
  0x55555565,
  0x55555565,
},
{ /* 0x506 */
  0xe6555555,
  0xe6555555,
  0xe6566555,
  0xe6565455,
  0xe6554455,
  0xe6555555,
  0xe6666666,
  0x65555555,
},
{ /* 0x507 */
  0x55555565,
  0x55555565,
  0x55665565,
  0x55654565,
  0x55544565,
  0x55555565,
  0x66666665,
  0x55555555,
},
{ /* 0x508 */
  0xcddeddde,
  0xdeeeeeee,
  0xdeffefed,
  0xefeefede,
  0xeeededdd,
  0xefeedded,
  0xdededddd,
  0xdfededdd,
},
{ /* 0x509 */
  0xdddefedc,
  0xeeeddded,
  0xedfeeeef,
  0xdededdde,
  0xdddddddd,
  0xdddddddd,
  0xdddcdddd,
  0xdddddddd,
},
{ /* 0x50a */
  0xdeffeedd,
  0xdddddddd,
  0xeedeeede,
  0xdddddddd,
  0xdcdddddd,
  0xdddddddd,
  0xdddddddd,
  0xdddddddd,
},
{ /* 0x50b */
  0xeedddc40,
  0xddddddc4,
  0xddcccdc4,
  0xdddcddc4,
  0xcdddcdc4,
  0xddddddc4,
  0xddddddc4,
  0xddcdcdc4,
},
{ /* 0x50c */
  0xdefedddd,
  0xdfeddddd,
  0xdeeddddd,
  0xddeddcdd,
  0xdefedddd,
  0xddeddddd,
  0xdededddd,
  0xdfeddddd,
},
{ /* 0x50d */
  0xddcdccdd,
  0xdccccddd,
  0xcccddded,
  0xdcdddddd,
  0xcdcddedd,
  0xdcdddeee,
  0xcdedeeed,
  0xcddddedd,
},
{ /* 0x50e */
  0xdddddcdd,
  0xddedddcd,
  0xdddddcdd,
  0xdddddddd,
  0xdddddedd,
  0xdddddddd,
  0xddcddddd,
  0xdddddddd,
},
{ /* 0x50f */
  0xddddddc4,
  0xddcdcdc4,
  0xdcdddcc4,
  0xddcdcdc4,
  0xddddcdc4,
  0xddcdcdc4,
  0xdddddcc4,
  0xcdddcdc4,
},
{ /* 0x510 */
  0xdedddddd,
  0xdededdcd,
  0xdfdddddd,
  0xdfeddddd,
  0xdeedddde,
  0xdddedddd,
  0xddeddddd,
  0xdcddcddd,
},
{ /* 0x511 */
  0xdddddddd,
  0xdddddddd,
  0xdddedddd,
  0xddddddde,
  0xddddddcd,
  0xdddddccd,
  0xddddcddd,
  0xdddddddd,
},
{ /* 0x512 */
  0xdddddddd,
  0xdddccddd,
  0xdcdddcdd,
  0xddedccdd,
  0xdedccddd,
  0xcdccdddd,
  0xdddddddc,
  0xdddddddd,
},
{ /* 0x513 */
  0xdddccdc4,
  0xddddcdc4,
  0xddcdccc4,
  0xddddcdc4,
  0xcddddcc4,
  0xddddcdc4,
  0xdddcccc4,
  0xdcddccc4,
},
{ /* 0x514 */
  0xdddedddd,
  0xdcddcdcd,
  0xdddddddd,
  0xddcdedcd,
  0xcddccccc,
  0xcccccddc,
  0x4cc4cccc,
  0x04444444,
},
{ /* 0x515 */
  0xdedddddd,
  0xdddddddd,
  0xcdcddcde,
  0xdccdcdcd,
  0xcdccdccc,
  0xccdccc4c,
  0x4ccc4444,
  0x44444444,
},
{ /* 0x516 */
  0xdddcdddd,
  0xcddcddcd,
  0xdddddddd,
  0xdccddccd,
  0xcccccccc,
  0x44444ccc,
  0x4c4ccc4c,
  0x44444444,
},
{ /* 0x517 */
  0xdddcdcc4,
  0xcdcdc4c4,
  0xdcccccc4,
  0xcdccc4c4,
  0xcccc44c4,
  0x44c444c4,
  0xcccccc44,
  0x44444440,
},
{ /* 0x518 */
  0xdddcdccc,
  0xeeeeeeee,
  0xffeeffff,
  0xfeffffff,
  0xfffffffd,
  0xdddddddd,
  0xcccccccc,
  0x44444444,
},
{ /* 0x519 */
  0xdddddcdd,
  0xeedeedee,
  0xfeffffff,
  0xffffefff,
  0xfefffeff,
  0xdddddddd,
  0xcccccccc,
  0x44444444,
},
{ /* 0x51a */
  0xddccbbcc,
  0xeedbbdee,
  0xff33ccff,
  0xfe3003ff,
  0xff0033fd,
  0xdd0bb0dd,
  0xccaa00cc,
  0x44900944,
},
{ /* 0x51b */
  0xcddcdccc,
  0xdeeeeeee,
  0xdeeeffff,
  0xddefffff,
  0xddeffffd,
  0xccccdddd,
  0x44444ccc,
  0x44444444,
},
{ /* 0x51c */
  0xcdefffee,
  0xdfeddddd,
  0xdeddcdee,
  0xddeddddd,
  0xdddddedd,
  0xcdcddddd,
  0x4ccccccc,
  0x44444444,
},
{ /* 0x51d */
  0xedcdddc4,
  0xdddedddc,
  0xdddddcdc,
  0xdcddccdc,
  0xcdcccddc,
  0xdddcdccc,
  0xccccccc4,
  0x44444444,
},
{ /* 0x51e */
  0xcdedeffe,
  0xdefeeddd,
  0xededdddd,
  0xdededddd,
  0xdedddddc,
  0xcddddddd,
  0x4ccccccc,
  0x44444444,
},
{ /* 0x51f */
  0xdeeeddc4,
  0xdddddddc,
  0xdddddcdc,
  0xddddccdc,
  0xdccccddc,
  0xddddddcc,
  0xccccccc4,
  0x44444444,
},
{ /* 0x520 */
  0xeeedadce,
  0xeddddd9d,
  0xdaadaacd,
  0xccc9cc99,
  0xda9eeeed,
  0xad9eddda,
  0xdacdaaad,
  0x9cc99999,
},
{ /* 0x521 */
  0xb3bbda9a,
  0xdaaaaa9a,
  0xaaadaaca,
  0x9c999cc9,
  0xba9bbd9a,
  0xaa9baaaa,
  0xaacaadaa,
  0x9c9c99c9,
},
{ /* 0x522 */
  0xeedeeeee,
  0xd6cddddd,
  0xc5444c44,
  0x05555555,
  0x05000000,
  0x05000000,
  0x05000000,
  0x05000000,
},
{ /* 0x523 */
  0xeeeeeeee,
  0xddddd6cd,
  0xc4c4c54c,
  0x55555500,
  0x00000500,
  0x00000500,
  0x00000500,
  0x00000500,
},
{ /* 0x524 */
  0xeeabbbbb,
  0xed99aaaa,
  0xedcdeede,
  0xed4cdddd,
  0xed000000,
  0xedcddddd,
  0xdd44cccc,
  0xed000000,
},
{ /* 0x525 */
  0xbbbbbbee,
  0xaaaaaafd,
  0xeefeffed,
  0xdddddddd,
  0x000000dd,
  0xdddddded,
  0xcccccced,
  0x000000ed,
},
{ /* 0x526 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
{ /* 0x527 */
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
  0000000000,
},
  }
};

#endif /* GFXST */

/* eof */
