import Qt 4.7

Rectangle {
    width: 800
    height: 480

    color: "#ffffff"

    Rectangle
    {
        id: topbar

        height: 64
        anchors {top: parent.top; left: parent.left; right: parent.right}
        color: "#dfdfdf"

        Text
        {
            anchors.centerIn: parent
            font.weight: Font.Bold
            font.pixelSize: parent.height * 0.5
            color: "#5f5f5f"
            text: "XBox 360 Media Remote"
        }

        Image
        {
            anchors {right: parent.right; verticalCenter: parent.verticalCenter; margins: 10}
            source: "images/theme/icons/close.png"
            MouseArea {anchors.fill: parent; onClicked: Control.quit()}
        }
    }

    Rectangle
    {
        id: mainpane
        width: parent.width
        anchors {top: topbar.bottom; bottom: parent.bottom}

        Column
        {
            x: ((parent.width / 3) / 2) * 1 - (width / 2)
            anchors.verticalCenter: parent.verticalCenter
            spacing: 10

            Row
            {
                anchors.horizontalCenter: parent.horizontalCenter

                TextButton
                {
                    width: 64; height: 42;
                    anchors.verticalCenter: parent.verticalCenter;
                    label: "Back"
                    command: "Xbox360_Back"
                }

                ImageButton
                {
                    size: 74;
                    icon: "Xbox360"
                    command: "XBox360_Xbox"
                }

                TextButton
                {
                    width: 64; height: 42;
                    anchors.verticalCenter: parent.verticalCenter;
                    label: "Start"
                    command: "Xbox360_Start"
                }
            }

            MediaPad {anchors.horizontalCenter: parent.horizontalCenter}

            Row
            {
                anchors.horizontalCenter: parent.horizontalCenter

                Column
                {
                    TextButton {width: 75; height: 42; label: "Display"; command: "Display"}
                    TextButton {width: 60; height: 42; label: "Back"; command: "Xbox360_Back"}
                }

                TextButton {height: 42; anchors.verticalCenter: parent.verticalCenter; label: "Menu"; command: "DVD_Menu"}

                Column
                {
                    TextButton {width: 75; height: 42; label: "Title"; command: "Title"}
                    TextButton {width: 60; height: 42; anchors.right:  parent.right; label: "Info"}
                }
            }
        }

        NumPad
        {
            x: ((parent.width / 3) / 2) * 3 - (width / 2)
            anchors.verticalCenter: parent.verticalCenter
        }

        Column
        {
            x: ((parent.width / 3) / 2) * 5 - (width / 2)

            anchors.verticalCenter: parent.verticalCenter
            spacing: 10

            Row
            {
                anchors.horizontalCenter: parent.horizontalCenter

                ToolButton {size: 52; icon: "Xbox360_Y"; command: "Xbox360_Y"}
                ToolButton {size: 52; icon: "Xbox360_X"; command: "Xbox360_X"}
                ToolButton {size: 52; icon: "Xbox360_A"; command: "Xbox360_A"}
                ToolButton {size: 52; icon: "Xbox360_B"; command: "Xbox360_B"}
            }

            ArrowPad {anchors.horizontalCenter: parent.horizontalCenter}

            Grid
            {
                anchors.horizontalCenter: parent.horizontalCenter
                columns: 3

                TextButton {width: 64; height: 42; label:  "V+"; command: "Vol_Up"}
                TextButton {width: 64; height: 42; label:  "TV"}
                TextButton {width: 64; height: 42; label:  "C+"; command: "Ch_Up"}
                TextButton {width: 64; height: 42; label:  "V-"; command: "Vol_Down"}
                TextButton {width: 64; height: 42; label:  "MUTE"; command: "Vol_Mute"}
                TextButton {width: 64; height: 42; label:  "C-"; command: "Ch_Down"}
            }
        }
    }
}
