.\" # src/x48.man.  Generated from x48.man.in by configure.
.\"  
.\" $Id$
.\" Copyright (c) 2005  G. Allen Morris III
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" $XFree86: xc/programs/xcalc/xcalc.man,v 1.5 2003/03/19 01:49:28 dawes Exp $
.\"
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH X48 1 "20 April 2006" "Version 0.6.3" "X48 Manual Pages"
.SH NAME
x48 \- scientific calculator for X and an HP 48 emulator
.SH SYNOPSIS
.B x48
[\-options ...]

where options include:
.br
    [\-help]                     print out this message
.br
    [\-display  <displayname>]   X server to contact
.br
    [\-name	<string>]        set application name to <string>
.br
    [\-title    <string>]        set window title to <string>
.br
    [\-geometry <geometry>]      position of window
.br
    [\-iconGeom <geometry>]      position of icon window
.br
    [\-iconic]                   start iconic
.br
    [\-visual   <visualname>]    use visual <visualname>
.br
    [\-mono]                     force monochrome
.br
    [\-gray]                     force grayscale
.br
    [\-monoIcon]                 force monochrome icon
.br
    [\-smallFont  <fontname>]    <fontname> to draw small labels (MTH - DEL)
.br
    [\-mediumFont <fontname>]    <fontname> to draw medium label (ENTER)
.br
    [\-largeFont  <fontname>]    <fontname> to draw large labels (Numbers)
.br
    [\-connFont   <fontname>]    <fontname> to display wire & IR connections
.br
    [\-/+xshm]                   turn on/off XShm extension
.br
    [\-version]                  print out version information
.br
    [\-copyright]                print out copyright information
.br
    [\-warranty]                 print out warranty information
.br
    [\-verbose]                  run verbosive
.br
    [\-quiet]                    run quietly
.br
    [\-/+terminal]               turn on/off pseudo terminal interface
.br
    [\-/+serial]                 turn on/off serial interface
.br
    [\-line       <devicename>]  use serial line <devicename> for IR connection
.br
    [\-/+debug                   turn on/off debugger
.br
    [\-disasm     <string>       use <string> ('HP' or 'class') mnemonics
.br
    [\-reset                     perform a reset (PC = 0) on startup
.br
    [\-initialize                force initialization x48 from ROM-dump
.br
    [\-rom        <filename>     if initializing, read ROM from <filename>
.br
    [\-home       <directory>    use directory ~/<directory> to save x48 files
.br
    [\-xrm        <resource>     set Xresource <resource>
.br
    [\-/+netbook                 Enable/Disable netbook look


.SH DESCRIPTION
.I x48
is a scientific calculator desktop accessory that emulate an HP\-48 SX
or an HP\-48 GX.
.SH OPTIONS
.PP
\fIx48\fP accepts all of the standard toolkit command line options along
with several additional options:
.PP
.TP 8
.B \-help
Show a list of options.
.PP
.TP 8
.B \-version
This  causes  x48  to  print a version number to the standard output.
.PP
.TP 8
.B \-iconic
Start iconic
.SH OPERATION

.PP
x48 emulates an HP 48 calculator. This manual does not attempt to
describe the operation of the HP calulator, but only the user interface
to the emulator.

.I Pointer Usage:
When mouse button one is press on an x48 key the key is depress until
the mouse button is released.  If you wish to have more than one key
press at a time mouse button 3 may be used.  Button pressed with mouse
button 3 will remain pressed until mouse button 1 is used.  For example
to reset the calulator you can press the A key and the F key with mouse
button 3 and then press the on button with mouse button 1.

Mouse button 2 will paste the text in the cut buffer to the calculator
if it is press in the display area of the calculator. See notes on 
pasting text into the calculator below.

Use of mouse elsewhere on the image of the calculator is undefined.

.SH ACCELERATORS

The keyboard may be used to input data into the x48.
The number keys on the keyboard coresponds to the number buttons on
the calaculator, and the alphbetic keys on the keyboard control the
buttons on the top half of the calculator and the @code{+/-} and
@code{EXX} keys.

The @code{ENTER} button is attached to the Enter key, the delete key
to the <-/DROP button and Divide, multiply, subtract and add buttons to
the /, *, -, and + keys on the key board.

Note that only the DELETE key will auto repeat just like on the HP48
calculator.

.SH CUSTOMIZATION
.SH WIDGET HIERARCHY
.SH APPLICATION RESOURCES
The  program  understands  all of the core X Toolkit resource names and
classes.  Application specific resources (e.g., "\fBX48\fR.\fINAME\fR") follow:
.TP
.B .display: <diplayname>
Specifies the display to use.
.TP
.B *geometry: {+|-}x{+|-}y
You can not change the size of \fIx48\fR, but you can set the location of \fIx48\fR.
.TP
.B *iconGeom: <geometrystring>

.TP
.B *iconName: <name>

.TP
.B *iconic: <true|false>

.TP
.B *title: <name>

.TP
.B *useXShm: <true|false>

.TP
.B *visual: <default|staticgray|staticcolor|truecolor|grayscale|pseudocolor|directcolor|\fI0xnn\fR|\fInn\fR> 

.TP
.B *mono: <true|false>

.TP
.B *gray: <true|false>

.TP
.B *monoIcon: <true|false>

.TP
.B *printVersion: <true|false>

.TP
.B *printCopyright:

.TP
.B *printWarranty:

.TP
.B *smallLabelFont: <font>

.TP
.B *mediumLabelFont:

.TP
.B *largeLabelFont:

.TP
.B *connectionFont:

.TP
.B *verbose:

.TP
.B *quiet:

.TP
.B *useTerminal:

.TP
.B *useSerial:

.TP
.B *serialLine:

.TP
.B *completeInitialize: <true|false>

.TP
.B *resetOnStartup:

.TP
.B *romFileName:

.TP
.B *homeDirectory:

.TP
.B *useDebugger:

.TP
.B *disassemblerMnemonics:

.TP
.B *Netbook:

.SH COLORS
The x48 is trying to look like a particular device.
The colors are therefore not selectable.
.br
.SH "ENVIRONMENT"
XUSERFILESEARCHPATH
.SH "SEE ALSO"
X(7x), xrdb(1)
.SH BUGS
.PP
Bugs can be found and reported at: http://developer.berlios.de/bugs/?group_id=3335
.SH COPYRIGHT
Copyright \(co 1994-2005 Eddie C. Dost
.br
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.SH AUTHORS
Eddie C. Dost
.br
G. Allen Morris III <gam3@gam3.net>
