#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys, re, mechanize, cookielib, base64, urllib2

# Class which holds the provider methods.
class provider:
	# get the printable name for this provider
	def getName(self):
		raise Exception('provider class is a base class only')
	# eventually we will have to separate the advanced features out, and return these as
	# canSchedule(), canSetSender(), canFlash(), but with the current providers these
	# are all either on or off, so we use a single method to describe them
	def hasAdvancedFeatures(self):
		return False
	# send the sms
	def sendSMS(self, NUMBER, SMSTEXT, LOGIN, PASSWORD, SCHEDULE=None, SENDER=None, FLASH=None):
		return False, "SMS sending not implemented"

# o2online.de 1.0
class provider_o2online_de(provider):
	def getName(self):
		return 'o2online (Deutschland)'
	def hasAdvancedFeatures(self):
		return True
	def sendSMS(self, NUMBER, SMSTEXT, LOGIN, PASSWORD, SCHEDULE=None, SENDER=None, FLASH=None):
		LOGINURL = 'http://www.o2online.de/'
		execute = True
		if execute:

			# RegExp to check if SMS was send successfully:
			re_suc = re.compile('Ihre SMS wurde erfolgreich versendet', re.IGNORECASE)

			# RegEx to check if en error occured
			re_fail = re.compile('(Fehler beim Login)|(Error logging in)', re.IGNORECASE)
			# RegExp to find the link to the communication center:
			com = re.compile('comcenter')

			# Instanziate a Browser
			brw = mechanize.Browser()

			# Instanziate Cookie Jar
			CoJa = cookielib.LWPCookieJar()
			brw.set_cookiejar(CoJa)

			# Browser options
			#brw.set_handle_gzip(True)
			brw.set_handle_referer(True)
			brw.set_handle_redirect(True)
			brw.set_handle_equiv(True)
			brw.set_handle_robots(False)
			#brw._factory.encoding = "UTF-8"
			#brw._factory._forms_factory.encoding = "UTF-8"
			#brw._factory._links_factory._encoding = "UTF-8"

			# Follows refresh 0 but not hangs on refresh > 0
			brw.set_handle_refresh(mechanize._http.HTTPRefreshProcessor(), max_time=1)

			# Debugging stuff
			#brw.set_debug_http(True)
			#brw.set_debug_responses(True)
			#brw.set_debug_redirects(True)


			# User-Agent
			# Mozilla
			#br.addheaders = [('User-agent', 'Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.1.6) Gecko/20100105 Gentoo Firefox/3.5.6')]
			# Opera
			brw.addheaders = [('User-agent', 'Opera/9.80 (Linux x86_64; U; en) Presto/2.5.18 Version/10.50 Gentoo')]

			# Open the O2 website
			brw.open(LOGINURL)

			# Show the available forms
			#n = 0
			#for f in br.forms():
			    #print "--------FORM=%s------------" %(n)
			    #print f
			    #print "---------------------------"
			    #n += 1

			# Select the Login form
			brw.select_form(name='loginForm')

			# Get the URL to the Communication Center
			for item in brw.form.find_control("url", type="select").items:
			    if com.search(str(item)):
				COMMURL = str(item)

			# Check that COMURL is not empty
			try:
			    COMMURL
			except:
			    raise Exception("Failed to get URL to Communication Center")

			# Fill in User credentials
			brw.form['loginName'] = LOGIN
			#brw.form['password'] = base64.b64decode(PASSWORD)
			brw.form['password'] = PASSWORD
			brw.form['url'] = [COMMURL]
			#brw.form.set_value([COMMURL], name="url")

			# Login
			try:
				brw.submit()
			except:
				STATUS = False
				MSG = "Login fehlgeschlagen"
				return STATUS, MSG
				raise Exception("Login fehlgeschlagen")

			result = brw.response().read()
			print result
			log = open("submit.html", "w")
			log.write(str(result))
			log.close()
			if re_fail.search(str(result)):
			    STATUS = False
			    MSG = "Login fehlgeschlagen oder nicht registriert"
			    return STATUS, MSG
			    raise Exception("Login fehlgeschlagen oder nicht registriert")

			# Open the SMS Center (ISO-8859-1)
			brw.open('https://email.o2online.de/smscenter_new.osp')
			res = brw.response()
			ENCODING = res.info()["Content-type"].split()[1].split("=")[1]

			try:
				brw.select_form(name='frmSMS')
			except:
				STATUS = False
				MSG = "Failed to select form"
				return STATUS, MSG
				raise Exception("Failed to select form")

			brw.form.set_all_readonly(False)
			brw.form['SMSTo'] = NUMBER
			brw.form['SMSText'] = SMSTEXT
			if FLASH :
				print "Sending Flash SMS"
				brw.form['FlagFlash'] = '1'
			if SENDER == "Anonym" :
				print "Sending Anonymous SMS"
				brw.form['FlagDefSender'] = '1'
				brw.form['FlagAnonymous'] = '1'
			if SENDER != "MyNumber" and SENDER != "Anonym" :
				print "Sending SMS with \"%s\" as sender" %(SENDER)
				brw.form['FlagDefSender'] = '1'
				brw.form['SMSFrom'] = str(SENDER)
			# If Schedule is not selected: SCHEDULE = False
			# else:
			# SCHEDULE = ([RECURRENCY, STOP(True/False)], [YEARstart, YEARstop], [MONTHstart, MONTHstop], [DAYstart, DAYstop], [HOUREstart, HOUREstop], [MINUTEstart, MINUTEstop])
			if SCHEDULE :
				print "Scheduling SMS"
				StartDate = '%s,%s,%s,%s,%s,%s' %(str(SCHEDULE[1][0]), str(SCHEDULE[2][0]), str(SCHEDULE[3][0]), str(SCHEDULE[4][0]), str(SCHEDULE[5][0]), '00')
				StopDate = '%s,%s,%s,%s,%s,%s' %(str(SCHEDULE[1][1]), str(SCHEDULE[2][1]), str(SCHEDULE[3][1]), str(SCHEDULE[4][1]), str(SCHEDULE[5][1]), '00')
				# See sourcecode of  the webpage for the mapping:
				#<option value="5">einmalig
				#<option value="6">stündlich
				#<option value="1">täglich
				#<option value="2">wöchentlich
				#<option value="3">monatlich
				#<option value="4">jährlich
				Frequency_Dict = {'Daily' : '1', 'Weekly' : '2', 'Monthly': '3', 'Yearly' : '4', 'Once' : '5',  'Hourly' : '6'}
				FQ = str(Frequency_Dict[SCHEDULE[0][0]])
				brw.form['RepeatType'] = FQ
				brw.form['FolderID'] = '3'
				brw.form['RepeatStartDate'] = StartDate
				if SCHEDULE[0][1] :
					print "Setting end date to scheduling"
					brw.form['RepeatEndType'] = '1'
					brw.form['RepeatEndDate'] = StopDate
			try:
				brw.submit()
				result = brw.response().read()
				if re_suc.search(str(result)):
					STATUS = True
					MSG = 'Provider responded: Ihre SMS wurde erfolgreich versendet'
				else:
					STATUS = False
					MSG = 'Provider responded: Ihre SMS wurde nicht versendet'
			except :
				STATUS = False
				MSG = 'Failed to submit message to O2'
			return STATUS, MSG
			#--------FORM=3------------
			#<frmSMS POST https://email.o2online.de/smscenter_send.osp application/x-www-form-urlencoded
			#<HiddenControl(SID=92227538_eqdujvat) (readonly)>
			#<HiddenControl(MsgContentID=-1) (readonly)>
			#<HiddenControl(FlagDLR=0) (readonly)>
			#<HiddenControl(FlagFlash=0) (readonly)>
			#<HiddenControl(FlagAnonymous=0) (readonly)>
			#<HiddenControl(FlagDefSender=0) (readonly)>
			#<HiddenControl(FlagVCal=0) (readonly)>
			#<HiddenControl(FlagVCard=0) (readonly)>
			#<HiddenControl(CID=-1) (readonly)>
			#<HiddenControl(DID=-1) (readonly)>
			#<HiddenControl(RepeatStartDate=2010,1,6,16,45,00) (readonly)>
			#<HiddenControl(RepeatEndDate=2010,1,6,16,45,00) (readonly)>
			#<HiddenControl(RepeatType=0) (readonly)>
			#<HiddenControl(RepeatEndType=0) (readonly)>
			#<HiddenControl(FolderID=0) (readonly)>
			#<HiddenControl(SMSToNormalized=) (readonly)>
			#<HiddenControl(FID=) (readonly)>
			#<HiddenControl(RURL=smscenter_new.osp?Autocompletion=1&SID=92227538_eqdujvat&MsgContentID=-1&REF=1262792073) (readonly)>
			#<HiddenControl(REF=1262792073) (readonly)>
			#<TextareaControl(SMSTo=)>
			#<TextareaControl(SMSText=)>
			#<TextControl(SMSFrom=)>
			#<SelectControl(Frequency=[*5, 6, 1, 2, 3, 4])>
			#<SelectControl(StartDateDay=[*01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31])>
			#<SelectControl(StartDateMonth=[*01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12])>
			#<SelectControl(StartDateYear=[*2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015])>
			#<SelectControl(StartDateHour=[*00, 01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23])>
			#<SelectControl(StartDateMin=[*00, 15, 30, 45])>
			#<SelectControl(EndDateDay=[*01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31])>
			#<SelectControl(EndDateMonth=[*01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12])>
			#<SelectControl(EndDateYear=[*2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015])>
			#<SelectControl(EndDateHour=[*00, 01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23])>
			#<SelectControl(EndDateMin=[*00, 15, 30, 45])>>
			#---------------------------

# vodafone.nl 1.0
class provider_vodafone_nl(provider):
	def getName(self):
		return 'Vodefone Nederland'
	def hasAdvancedFeatures(self):
		return False
	def sendSMS(self, NUMBER, SMSTEXT, LOGIN, PASSWORD, SCHEDULE=None, SENDER=None, FLASH=None):
		# TODO: synchronize number verification with main code (UpdateChars() perhaps?)
		# TODO: block SMS longer than 1 message
		# TODO: enforce maximum SMS size of 125 characters (*not* 160)
		# TODO: check whether sending worked
		# TODO: handle "2 per day maximum"
		# TODO: localization support (at least English and Dutch)

		# get rid of whitespace and dots
		number = re.sub(r'(\s|\.)+', '', NUMBER)

		# handle a couple of number formats (only mobile numbers allowed)
		if re.search(r'^\+316\d{8}$', number):	# ITU format, +31 is the Netherlands
			number = number[3:]
		elif re.search(r'^06\d{8}$', number):	# local dialing format
			number = number[1:]
		else:
			return False, 'Only Dutch mobile phone numbers allowed'

		# set up our browser
		br = mechanize.Browser()
		cj = cookielib.LWPCookieJar()
		br.set_cookiejar(cj)

		# login
		try:
			br.open('https://my.vodafone.nl/prive/my_vodafone')
			br.select_form(name='login')
			br.form['username'] = LOGIN
			br.form['password'] = PASSWORD
			br.submit()
		except:
			return False, "Error logging in"


		# verify our login worked and return error if not
		br.response().read()
		try:
			br.find_link(text='Uitloggen')
		except mechanize.LinkNotFoundError:
			return False, 'Login failed'

		# send the SMS
		try:
			br.open('https://my.vodafone.nl/Prive/My_Vodafone/gratis_sms_versturen')
		except:
			return False, 'Error opening free SMS web page'
		response = br.response().read()
		if re.search(r'Je hebt het maximum aantal gratis SMS\'jes bereikt voor vandaag.', response):
			return False, "Provider responded: Je hebt het maximum aantal gratis SMS'jes bereikt voor vandaag."

		try:
			br.select_form(name='controle')
			br.form['phoneNumber'] = number
			br.form['body'] = SMSTEXT
			br.submit()
		except:
			print response
			return False, 'Error submitting SMS form'

		# check to see if our send worked
		response = br.response().read()
		if re.search(r'Je sms\'je is verstuurd.', response):
			return True, "Provider responded: Je sms'je is verstuurd."
		elif re.search(r'Je hebt het maximum aantal gratis SMS\'jes voor vandaag verstuurd.', response):
			return False, "Provider responded: Je hebt het maximum aantal gratis SMS'jes voor vandaag verstuurd."
		else:
			return False, 'Message not sent'
