/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRTWIDGETCONTAINERBASE_H__
#define __WRTWIDGETCONTAINERBASE_H__

#include <QObject>
#include <QPointer>
#include "wrtglobal.h"
#include "widgetcoreglobal.h"

class WidgetProperties;
class QWebFrame; //??

namespace WRT {

class WidgetContainerBasePrivate;
class WrtNetworkAccessManager;
class WrtController;
class WebWidgetPreference;
class WrtPage;
class SecSession;
class WrtApiInterface;
class WIDGETCORE_EXPORT WidgetContainerBase : public QObject
{
Q_OBJECT

public:

    /** Constructor. Creates a new WrtController, initializes private data
     *  and sets scrollbars off.
     */
    WidgetContainerBase(QWidget* parent = 0, WebKitView webkitView = WRT::WebView);

    /** Destructor
     */
    virtual ~WidgetContainerBase();

    /** Returns the url that has been loaded to the page. Returns
     *  an empty url, if no url has been loaded.
     */
    QUrl loadedUrl();

    /** Getter for wrtPage. WrtPage is owned by WrtController.
     */
    WrtPage* wrtPage() const;

    /** Getter for WrtController.
     */
    WrtController* wrtController() const;

    /**
     */
    virtual void setWidgetInfo(const QString& wgzPath, const QString& id);

   /** Loads all WRT APIi defined in wrtapiconf.h
    */
   void loadWrtApis(WRT::JSApi::WidgetJavaScriptApi apis = WRT::JSApi::W3C);

   /** Returns WRT API object based on the API name.
    *  @param name Name of the API, defined in wrtapiconf.h
    *  @return Pointer to WRT API object. The ownership of the object remains
    *          with this class.
    */
   WrtApiInterface* apiObject(QString name);

    /**
     */
    void setWidgetProperties(const WidgetProperties* widgetProperties);

    /** Getter for widget properties
     */
    const WidgetProperties* widgetProperties();

    /** Getter for widget preferences
     */
    WebWidgetPreference* widgetPreference() const;

    /** Sets network access manager for the wrt page.
     */
    void setWrtNetworkAccessManager(WrtNetworkAccessManager* wrtNetworkAccessManager);

    /** Getter for network access manager
     */
    WrtNetworkAccessManager* wrtNetworkAccessManager() const;

    /** Setter for application launch parameters
     */
    void setCommandline(QString commandline);

    /** Getter for application launch parameters
     */
    QString commandline();

    /** Setter for application launch parameters, when application
     *  already exists and is "launched" again to bring it to foreground
     */
    void setMessage(QString message);

    /** Getter for parameters that were given when bringing the application
     *  to foreground.
     */
    QString message();

    /** Informs JS about changes in widget visibility.
     *  @param visible If true, calls widget.onshow. If false, calls
     *         widget.onhide.
     */
    void visibilityChanged(bool visible);

    /** adds the given url to whitelist allowing it to be accessed
     *  @param url, location which should be accessible
     */

    void whitelistAccess(const QUrl& url);

    /** Inform JS about changes in view mode
     *  @param viewMode the view mode which was set.
     */
    void viewModeChanged(QString viewMode);


signals:
    /** Emitted when WrtPage signal windowCloseRequested is received.
     */
    void windowCloseRequested();

    /** Emitted when the widget has requested a view mode change.
     */
    void viewModeChangeRequested(QString viewMode);

    /** Emitted when wrt APIs were already loaded.
     */
    void wrtApisLoaded();

    /** Emitted when WrtNetworkAccessManager signal is received.
     */
    void createConnection();
    void connectionEstablished();
    void connectionError();

public slots:
    /** Public slot, saves the widget mainfest Url  into app Registry
     *  @param  url : mainfest Url
     */
    void saveWidgetManifestUrl(const QString& url);

protected slots:
    void frameCreated(QWebFrame *frame);
    void postPrepareWrtApis();

private:
    WidgetContainerBasePrivate* d;

};

}

#endif
