/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WRTWIDGETCONTAINERCWRT_H__
#define __WRTWIDGETCONTAINERCWRT_H__

#include <QObject>
#include <QPointer>
#include <QMenu>
#ifdef CWRT_BUILDING_TENONE
#include <HbMenu>
#endif
#include "wrtglobal.h"
#include "wrtwidgetcontainerBase.h"

class QWidget;
class QMenu;
class QGraphicsWebView;

namespace WRT {

  class WidgetContainerPrivate;

class WIDGETCORE_EXPORT WidgetContainer : public WidgetContainerBase
{
Q_OBJECT

public:
    enum WrtWidgetNotify {
        WrtWidgetToForeGround,
        WrtWidgetToBackGround,
        WrtWidgetFocusIn,
        WrtWidgetFocusOut,
        WrtWidgetToFullscreen,
        WrtWidgetOnRestore,
        WrtWidgetOnmessagereceived,
        WrtWidgetOnexit
    };

public:
    WidgetContainer(QWidget* parent, WebKitView webkitView = WRT::WebView);
    ~WidgetContainer();


    QWidget* webWidget() const;
    QGraphicsWebView* graphicsWebView() const;

    void deferTimers(bool enable);
    void deactivatePopup();
    bool active();
    void setActive(bool val) { m_active = val; }

    virtual void setWidgetInfo(const QString& wgzPath, const QString& id);


    void setTransitionMode(const QString& mode);
    void performTransition();

    void notifyWidget(WidgetContainer::WrtWidgetNotify command);
    QVariant evaluateJavaScript( const QString& script );

    QMenu* menu(QMenu* menu = 0);
#ifdef CWRT_BUILDING_TENONE
    HbMenu* menu(HbMenu* menu = 0);
#endif
    void openURL(QString url);
    void openApplication(QString application);
    QString leftSoftkeyLabel();
    QString rightSoftkeyLabel();
    bool isSoftkeyVisible();

    void installSoftkeyEventFilter(QObject *softkey);
    void removeSoftkeyEventFilter(QObject *softkey);

signals:
    void softkeysChanged();

public slots:
    void addJSObjectToWindowObject();

#ifdef Q_OS_SYMBIAN
// TODO replace with service provider
private:
    void launchApplicationL(const QVariant& aUid, const QVariant& aParam);
#endif

private:
    WidgetContainerPrivate* d;
    bool m_active;
};

}

#endif
