/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifdef __SYMBIAN32__
#include <e32base.h>
#include <e32std.h>
#include <W32STD.H>
#include <apgcli.h>
#include <apgtask.h>
#endif

#include "wrtwidgetcontainer.h"
#include "wrtwidgetcontainer_p.h"
#include "qwebframe.h"
#include "qwebpage.h"
#include "qgraphicswebview.h"
#include "webwidgetpreference.h"
#include "wgzjswidget.h"
#include "superjswidget.h"
#include "webjsmenu.h"
#include "webrenderer.h"
#include "w3cjswidget.h"
#include "wgtjswidget.h"
#include "jiljswidget.h"
#include "WebAppRegistry.h"
#include "wrtcontroller.h"
#include "wrtpage.h"
#include "wrtnetworkaccessmanager.h"
#include "wrtsettings.h"
#include "dialogsprovider.h"
#include "widgetcorelogs.h"
#include "WidgetProperties.h"
#include "widgetmanagerconstants.h"

#include <qfile.h>
#include <QPalette>
#include <Qt>
#include <QtCore>
#include <QtCore/qglobal.h>
#include <QWidget>
#include <QVariant>
#include <QtGui/QDesktopServices>
#ifdef CWRT_BUILDING_TENONE
#include <HbMenu>
#endif
#include <QApplication>

const QString KDEVICE_JS_FILE ("nokia/device/device.js");


using namespace WRT;

// CONSTANTS
const QString KFade = "fade";

WidgetContainerPrivate::WidgetContainerPrivate(QWidget* parent) :
  m_jsMenu(0)
, m_transitionMode(QString())
, m_widgetRenderer(0)
, m_superJsWidget(0)
, m_parent(parent)
{
}

WidgetContainerPrivate::~WidgetContainerPrivate()
{
    delete m_jsMenu;
    delete m_superJsWidget;
}

WidgetContainer::WidgetContainer(QWidget* parent, WebKitView webkitView) :
  WidgetContainerBase(parent, webkitView)
  , d(new WidgetContainerPrivate(parent))
  , m_active(false)
{
    d->m_jsMenu = new WebJSMenu(this);

    connect( wrtPage()->mainFrame(), SIGNAL(javaScriptWindowObjectCleared()), this, SLOT(addJSObjectToWindowObject()) );
    connect( d->m_jsMenu, SIGNAL(softkeysChanged()), this, SIGNAL(softkeysChanged()) );
    connect( d->m_jsMenu, SIGNAL(windowCloseRequested()), this, SIGNAL(windowCloseRequested()) );
}

WidgetContainer::~WidgetContainer()
{
    delete d;
}

QGraphicsWebView* WidgetContainer::graphicsWebView() const
{
    return wrtController()->graphicsWebView();
}

QWidget* WidgetContainer::webWidget() const
{
    return wrtController()->webWidget();
}

void WidgetContainer::deferTimers(bool enable)
{
    if (enable) {
        QEvent stopTimers (QEvent::ApplicationDeactivate);
        event(&stopTimers);
    }
    else {
        QEvent startTimers (QEvent::ApplicationActivate);
        event(&startTimers);
    }
}

bool WidgetContainer::active() {
    return m_active;
}

void WidgetContainer::setWidgetInfo(const QString& wgzPath, const QString& id)
{
    WidgetContainerBase::setWidgetInfo(wgzPath, id);

    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(id, webAppInfo);
    switch (webAppInfo.widgetType())
            {
            case WebAppInfo::WidgetNokia: //Nokia Widgets
                  d->m_superJsWidget = new WgzJSWidget(this);
                  break;
              case WebAppInfo::WidgetJIL:
              case WebAppInfo::WidgetW3C: //W3C
                  d->m_superJsWidget = new WgtJSWidget(this);
                  break;
//            case WebAppInfo::WidgetW3C: //both W3C and JIL widgets
//                  d->m_superJsWidget = new JILJSWidget(this);
//                  break;
            default: //unknown widget type
                  break;
            }
}

void WidgetContainer::setTransitionMode(const QString& mode)
{
    d->m_transitionMode = mode;
}

void WidgetContainer::performTransition()
{
    if ( !d->m_transitionMode.isNull() ) {
        // fade is supported mode
#if !defined(CWRT_BUILDING_NINETWO)
        if ( !d->m_transitionMode.compare(KFade) ) {
            if (!d->m_widgetRenderer) {
                d->m_widgetRenderer = new WebRenderer(d->m_parent);
            }
            d->m_widgetRenderer->start();
        }
#endif
        // reset m_mode after transition invokation
        d->m_transitionMode.clear();
    }
}

void WidgetContainer::deactivatePopup()
{
    QWidget*   childPopup = NULL;
    childPopup = QApplication::activeModalWidget();//modal dialog

    if (!childPopup)
        childPopup = QApplication::activePopupWidget(); //drop down, option menu

    if (childPopup)
    {
        childPopup->close();
    }
}



void WidgetContainer::notifyWidget(WidgetContainer::WrtWidgetNotify command)
{
    if (d && d->m_superJsWidget)
        d->m_superJsWidget->notificationRecieved(command);
}

QVariant WidgetContainer::evaluateJavaScript( const QString& script )
{
    return wrtPage()->mainFrame()->evaluateJavaScript(script);
}

QMenu* WidgetContainer::menu(QMenu* menu)
{
    return d->m_jsMenu->constructUIMenu(menu);
}

#ifdef CWRT_BUILDING_TENONE
HbMenu* WidgetContainer::menu(HbMenu* menu)
{
    return d->m_jsMenu->constructUIMenu(menu);
}
#endif

void WidgetContainer::openURL(QString url)
{
#ifndef QT_NO_DESKTOPSERVICES
    QDesktopServices::openUrl(QUrl(url));
#endif
}

void WidgetContainer::openApplication(QString application)
{
#ifdef Q_OS_SYMBIAN
    TRAP_IGNORE(launchApplicationL( QVariant(application), QVariant() ) );
#endif
}

void WidgetContainer::installSoftkeyEventFilter(QObject *softkey)
{
    softkey->installEventFilter(d->m_jsMenu);
}

void WidgetContainer::removeSoftkeyEventFilter(QObject *softkey)
{
    softkey->removeEventFilter(d->m_jsMenu);
}

/*!
Public Slots:
void addJSObjectToWindowObject()
void saveWidgetManifestUrl(const QString& url)
*/
void WidgetContainer::addJSObjectToWindowObject()
{
    if (d->m_superJsWidget)
         wrtPage()->mainFrame()->addToJavaScriptWindowObject("widget", d->m_superJsWidget);

    wrtPage()->mainFrame()->addToJavaScriptWindowObject("menuCPP", d->m_jsMenu);
    // ------Javascript object menuCPP:
    // It's a shadow of native side WebJSMenu object
    // ------Javascript function MenuItem and menuJS:
    // They are javascript side implementation for MenuItem and menu.
    // They need to call menuCPP on the native side
    // to connect javascript side and native side.
    // ------Menu tree:
    // Javascript MenuItem function maintains a javascript menu tree
    // by creating children array of menu and each of MenuItem.
    // On the native side, another menu tree is maintained in menuCPP.
    // ------Constructing menu tree:
    // In the javascript side, calling append()
    // and with the help of array of children of MenuItem and menu,
    // menu tree can be built nicely
    // In the native side, additionally, following functions are required:
    // appendNative(): recursive function of MenuItem
    // appendToMenuItem(): function of menuCPP
    d->m_jsMenu->clear();
    wrtPage()->mainFrame()->evaluateJavaScript("function MenuItem(label, id) \
        { \
            var typeId = typeof id; \
            if (typeId != 'number') { \
                throw 'fail to create MenuItem. Invalid id <'+id+'> has type: <'+typeId+'>'; \
            } \
            if (id < 0) { \
                throw 'fail to create MenuItem. Invalid id <'+id+'> is negative'; \
            } \
            var typeLabel = typeof label; \
            if (typeLabel != 'string') { \
                throw 'fail to create MenuItem. Invalid label <'+label+'> has type: <'+typeLabel+'>'; \
            } \
            if (label == '') { \
                throw 'fail to create MenuItem. Invalid label is empty string'; \
            } \
            this.id = id; \
            if (label.length > 40) { \
                this.label = label.substr(0, 40); \
            } \
            else { \
                this.label = label; \
            } \
            this.children = new Array(); \
        } \
        MenuItem.prototype.toString = function () { \
            return this.label; \
        }; \
        MenuItem.prototype.isItemUnique = function (id, label) { \
            var ret = true; \
            if (this.id == id || this.label == label) ret = false; \
            else { \
                var len = this.children.length; \
                for (var i=0; i<len; i++) { \
                    ret = this.children[i].isItemUnique(id, label); \
                    if (!ret) break; \
                } \
            } \
            return ret; \
        }; \
        MenuItem.prototype.isBranchUnique = function (parent) { \
            var ret = true; \
            if (!parent.isItemUnique(this.id, this.label)) ret = false; \
            else { \
                var len = this.children.length; \
                for (var i=0; i<len; i++) { \
                    ret = this.children[i].isBranchUnique(parent); \
                    if (!ret) break; \
                } \
            } \
            return ret; \
        }; \
        MenuItem.prototype.isBranchUniqueNative = function () { \
            var ret = true; \
            if (menuCPP.isExisting(this.id, this.label)) ret = false; \
            else { \
                var len = this.children.length; \
                for (var i=0; i<len; i++) { \
                    ret = this.children[i].isBranchUniqueNative(); \
                    if (!ret) break; \
                } \
            } \
            return ret; \
        }; \
        MenuItem.prototype.appendNative = function (parentId) { \
            var success = menuCPP.appendToMenuItem(parentId, this.id, this.label); \
            var len = this.children.length; \
            for (var i=0; i<len; i++) { \
                success = this.children[i].appendNative(this.id); \
                if (!success) break; \
            } \
            return success; \
        }; \
        MenuItem.prototype.append = function (childMenuItem) { \
            var valid = childMenuItem instanceof MenuItem; \
            if (!valid) return; \
            var success = false; \
            var inNativeTree = menuCPP.isExisting(this.id, this.label); \
            if (inNativeTree) { \
                if (childMenuItem.isBranchUniqueNative()) \
                    success = childMenuItem.appendNative(this.id); \
            } else \
                success = childMenuItem.isBranchUnique(this); \
            if (success) \
                this.children.push(childMenuItem); \
        }; \
        MenuItem.prototype.remove = function (childMenuItem) { \
            var valid = childMenuItem instanceof MenuItem; \
            if (!valid) return false; \
            var len = this.children.length; \
            for (var i=0; i<len; i++) { \
                if (this.children[i].id == childMenuItem.id) { \
                    this.children.splice(i, 1); \
                    menuCPP.removeFromMenuItem(this.id, childMenuItem.id); \
                    return true; \
                } \
            } \
            for (var i=0; i<len; i++) { \
                var removed = this.children[i].remove(childMenuItem); \
                if (removed) return true; \
            } \
            return false; \
        }; \
        MenuItem.prototype.setDimmed = function (dimmed) { \
            var typeDim = typeof dimmed; \
            if (typeDim != 'boolean') return; \
            menuCPP.setDimmed(this.id, dimmed); \
        }; \
        MenuItem.prototype.getMenuItemById = function (id) { \
            var ret = undefined; \
            if (this.id == id) ret = this; \
            else { \
                var len = this.children.length; \
                for (var i=0; i<len; i++) { \
                    ret = this.children[i].getMenuItemById(id); \
                    if (ret != undefined) break; \
                } \
            } \
            return ret; \
        }; \
        MenuItem.prototype.getMenuItemByName = function (label) { \
            var ret = undefined; \
            if (this.label == label) ret = this; \
            else { \
                var len = this.children.length; \
                for (var i=0; i<len; i++) { \
                    ret = this.children[i].getMenuItemByName(label); \
                    if (ret != undefined) break; \
                } \
            } \
            return ret; \
        }; \
        MenuItem.prototype.clear = function () { \
            var len = this.children.length; \
            for (var i=0; i<len; i++) { \
                this.children[i].clear(); \
            } \
            this.children = []; \
        }; \
    ");
    wrtPage()->mainFrame()->evaluateJavaScript("function menuJS() \
        { \
            this.children = new Array(); \
        }; \
        menuJS.prototype.append = function (childMenuItem) { \
            var valid = childMenuItem instanceof MenuItem; \
            if (!valid) return; \
            var success = childMenuItem.isBranchUniqueNative(); \
            if (success) { \
                success = menuCPP.append(childMenuItem.id, childMenuItem.label); \
                if (success) { \
                    var len = childMenuItem.children.length; \
                    for (var i=0; i<len; i++) { \
                        success = childMenuItem.children[i].appendNative(childMenuItem.id); \
                        if (!success) break; \
                    } \
                } \
            } \
            if (success) \
                this.children.push(childMenuItem); \
        }; \
        menuJS.prototype.remove = function (childMenuItem) { \
            var valid = childMenuItem instanceof MenuItem; \
            if (!valid) return; \
            var len = this.children.length; \
            for (var i=0; i<len; i++) { \
                if (this.children[i].id == childMenuItem.id) { \
                    this.children.splice(i, 1); \
                    menuCPP.remove(childMenuItem.id); \
                    return; \
                } \
            } \
            for (var i=0; i<len; i++) { \
                var removed = this.children[i].remove(childMenuItem); \
                if (removed) return; \
            } \
        }; \
        menuJS.prototype.setLeftSoftkeyLabel = function (label, functionName) { \
            menuCPP.setLeftSoftkeyLabel(label); \
            menuJS.prototype.leftSoftkeyCallback = functionName; \
        }; \
        menuJS.prototype.setRightSoftkeyLabel = function (label, functionName) { \
            menuCPP.setRightSoftkeyLabel(label); \
            menuJS.prototype.rightSoftkeyCallback = functionName; \
        }; \
        menuJS.prototype.showSoftkeys = function () { \
            menuCPP.showSoftkeys(); \
        }; \
        menuJS.prototype.hideSoftkeys = function () { \
            menuCPP.hideSoftkeys(); \
        }; \
        menuJS.prototype.clear = function () { \
            var len = this.children.length; \
            for (var i=0; i<len; i++) { \
                this.children[i].clear(); \
            } \
            this.children = []; \
            menuCPP.clear(); \
        }; \
        menuJS.prototype.getMenuItemById = function (id) { \
            var ret = undefined; \
            var typeId = typeof id; \
            if (typeId != 'number') return ret; \
            var len = this.children.length; \
            for (var i=0; i<len; i++) { \
                ret = this.children[i].getMenuItemById(id); \
                if (ret != undefined) break; \
            } \
            return ret; \
        }; \
        menuJS.prototype.getMenuItemByName = function (label) { \
            var ret = undefined; \
            var typeLabel = typeof label; \
            if (typeLabel != 'string') return ret; \
            var len = this.children.length; \
            for (var i=0; i<len; i++) { \
                ret = this.children[i].getMenuItemByName(label); \
                if (ret != undefined) break; \
            } \
            return ret; \
        }; \
        var menu = new menuJS(); \
    ");

     QFile Script(SHARED_LIBRARY_PATH+KDEVICE_JS_FILE);
     if (Script.exists() && Script.open(QIODevice::ReadOnly)){
     QByteArray content = Script.readAll();
     Script.close();
     wrtPage()->mainFrame()->evaluateJavaScript(content);
     }

     QString wrtVersion = WrtSettings::getWrtVersion();
     QString evalWrtVersion("nokia.device.version = ");
     evalWrtVersion +=  + "\""+wrtVersion+"\";";
     wrtPage()->mainFrame()->evaluateJavaScript(evalWrtVersion);

    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetProperties()->id(), webAppInfo);

    if (webAppInfo.widgetType() == WebAppInfo::WidgetJIL) {
        QString initializeJil = "(function() { \
              var so_jil, connectId; \
              try{ \
                  so_jil = nokia._services.load('jilservice','com.nokia.jil','1.0'); \
                  connectId = so_jil.addEventListener('evaluateJavaScript(QString)', evaluateJavascript); \
                  function evaluateJavascript(string) { window.eval(string); } \
                  so_jil.pageReload(); \
              }catch(e){ \
                  var err = 'JIL Service framework plugin is not loaded!'; alert(err); \
              } \
         })();";

         wrtPage()->mainFrame()->evaluateJavaScript(initializeJil);
      }

}


#ifdef __SYMBIAN32__
// ----------------------------------------------------------------------------
// TODO replace with service provider
// ----------------------------------------------------------------------------
//
void WidgetContainer::launchApplicationL(const QVariant& aUid, const QVariant& aParam)
{
    TUid uid = TUid::Uid(aUid.toString().toUInt());

    RWsSession wsSession;
    TApaTaskList taskList( wsSession );
    User::LeaveIfError( wsSession.Connect() );
    CleanupClosePushL( wsSession );
    TApaTask task = taskList.FindApp(uid);

    if ( task.Exists() ) {
        task.BringToForeground();
        if ( aParam.toString().length() > 0 ) {
            TPtrC8 ptr(reinterpret_cast<const TUint8*>(aParam.toString().toLocal8Bit().constData()));
            HBufC8* param8 = HBufC8::NewLC(ptr.Length());
            param8->Des().Copy(ptr);
            task.SendMessage( TUid::Uid( 0 ), *param8 );
            CleanupStack::PopAndDestroy( param8 );
        }
    }
    else {
        TPtrC16 ptr(reinterpret_cast<const TUint16*>(aParam.toString().constData()));
        HBufC16* param = HBufC16::NewLC(ptr.Length());
        param->Des().Copy(ptr);

        TApaAppInfo info;
        RApaLsSession session;
        User::LeaveIfError( session.Connect() );
        CleanupClosePushL( session );
        User::LeaveIfError( session.GetAppInfo( info, uid ) );

        RProcess newProc;
        CleanupClosePushL( newProc );

        TInt err = newProc.Create(info.iFullName, param->Des());
        newProc.Resume();

        CleanupStack::PopAndDestroy( 3 ); // param, session, newProc
    }
    CleanupStack::PopAndDestroy( ); // wsSession
}
#endif


QString WidgetContainer::leftSoftkeyLabel()
{
    return d->m_jsMenu->leftSoftkeyLabel();
}

QString WidgetContainer::rightSoftkeyLabel()
{
    return d->m_jsMenu->rightSoftkeyLabel();
}

bool WidgetContainer::isSoftkeyVisible()
{
    return d->m_jsMenu->isSoftkeyVisible();
}


