/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
 #include <QDebug>
#include <qwebframe.h>

#include "wrtpage.h"
#include "wrtapiprovider.h"
#include "wrtapimanager.h"
#include "wrtapimanager_p.h"
#include "wrtapiconf.h"
namespace WRT {

WrtApiManager::WrtApiManager(WRT::WrtPage* wrtPage) {
    d = new WrtApiManagerPrivate();
    d->m_wrtApiProvider = new WrtApiProvider();
    d->m_serviceLoader = new WRT::ServiceLoader();
    d->m_serviceLoader->setContext(wrtPage);
    d->m_serviceLoader->setServiceProvider(d->m_wrtApiProvider);
    d->m_wrtPage = wrtPage;
}

WrtApiManager::~WrtApiManager() {
    delete d;
}

void WrtApiManager::loadApis(JSApi::WidgetJavaScriptApi apis) {
    //Get apis that match the request and possible apis
    QString wrtApiList = d->getApiList(apis);
    d->m_wrtApiProvider->setApis(wrtApiList.split(DELIM));
    d->m_wrtApiProvider->handleNewInstance(d->m_serviceLoader);
    // We must not explicitly load APIs over here.
    // ServiceLoader fires pageOnReload to WrtApiProvider once javaScriptWindowObjectCleared is emitted.
}

WrtApiInterface* WrtApiManager::apiObject(QString name) {
    return d->m_wrtApiProvider->apiObject(name);

}

}
