/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __JSVIEWMENU_H
#define __JSVIEWMENU_H

#include <QObject>
#include <QString>
#include <QVariantMap>
#include <QList>
#include <qwebpage.h>

#include "jsmenu.h"

namespace WRT {

class Action;
class ActionAdapter;

class JSViewMenu : public JSMenu
{
    Q_OBJECT
    Q_PROPERTY(QString title READ title WRITE setTitle)

    public:


        explicit JSViewMenu();
        virtual ~JSViewMenu();

        QString title();
        void setTitle(QString title);

    signals:
        void titleChanged(QString viewTitle);

    public slots:
        void append(int id);
        void remove(int id);
        void insert(int id, int beforeIndex);
        void clear();

     private:
        QString m_title;
        QList<Action*> m_mainLevelMenu;
};

}

#endif
