/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef __WGZJSWIDGET_H
#define __WGZJSWIDGET_H

//  INCLUDES
#include <QObject>
#include <QString>
#include <QVariant>
#include "superjswidget.h"

// FUNCTION PROTOTYPES

namespace WRT {

   class WidgetContainer;

    /**
    *  WgzJSWidget
    *
    */
    class WgzJSWidget : public SuperJSWidget {
        Q_OBJECT
        Q_PROPERTY(QString identifier READ identifier)

    public slots:
        void prepareForTransition(const QString& mode);
        void performTransition();
        void setNavigationEnabled(bool flag);
        void setNavigationType(QString type);
        void openApplication(QString uid);
        void setDisplayLandscape();
        void setDisplayPortrait();
        bool isrotationsupported();
        QVariant preferenceForKey(const QVariant& key);
        void setPreferenceForKey(const QVariant& value, const QVariant& key);

   public:
        QString identifier() const;

        void notificationRecieved(WidgetContainer::WrtWidgetNotify value);

        WgzJSWidget(WidgetContainer* wrtWidgetContainer);
        ~WgzJSWidget();
    };

}

#endif
