/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QtCore>
#include <QVariant>
#include "wgzjswidget.h"
#include "webwidgetpreference.h"
#include "wrtwidgetcontainer.h"
#include "superjswidget.h"


using namespace WRT;

// LOCAL FUNCTION PROTOTYPES

// ----------------------------------------------------------------------------
// WgzJSWidget::
//
//
//
// ----------------------------------------------------------------------------
//
WgzJSWidget::WgzJSWidget(WidgetContainer* wrtWidgetContainer) : SuperJSWidget(wrtWidgetContainer)
{
}

WgzJSWidget::~WgzJSWidget()
{
}

void WgzJSWidget::notificationRecieved(WidgetContainer::WrtWidgetNotify value)
{

    switch (value) {
        case WidgetContainer::WrtWidgetFocusIn:
            widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onshow) != 'undefined') && (widget.onshow != null)){widget.onshow();}");
            break;


        case WidgetContainer::WrtWidgetFocusOut:
            widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onhide) != 'undefined') && (widget.onhide != null)){widget.onhide();}");
            break;

        default:
             //In case of any common UI events in future
             SuperJSWidget::notificationRecieved(value);
             break;
        }
}

void WgzJSWidget::prepareForTransition(const QString& mode)
{
   widgetContainer()->setTransitionMode( mode );
}

void WgzJSWidget::performTransition()
{
    widgetContainer()->performTransition();
}

void WgzJSWidget::setNavigationEnabled(bool flag)
{
    // if set tabbed navigation: if meta tag navigation is created, update its value
    // else, create the meta tag
    // if unset tabbed navigation: remove the meta tag navigation is it exists
    QString script;
    if (flag) {
        script = "var m = document.getElementsByTagName('meta'); \
            for (var i in m) { \
                if (m[i].name=='navigation') { \
                    var head = document.getElementsByTagName('head')[0]; \
                    head.removeChild(m[i]); \
                    break; \
                } \
            }";
    } else {
        script = "var found = false; \
            var m = document.getElementsByTagName('meta'); \
            for (var i in m) { \
                if (m[i].name=='navigation') { \
                    m[i].content = 'tabbed'; \
                    found = true; \
                    break; \
                } \
            } \
            if (!found) { \
                var head = document.getElementsByTagName('head')[0]; \
                var meta = document.createElement('meta'); \
                meta.name = 'navigation'; \
                meta.content = 'tabbed'; \
                head.appendChild(meta); \
            }";
    }

    qDebug() << "tab script:" << script;
    widgetContainer()->evaluateJavaScript(script);
}

void WgzJSWidget::setNavigationType(QString type)
{
    qDebug() << "setNavigationType: " << type;
/*
    if (type.startsWith("cursor"))
    else if (type.startsWith("tabbed"))
    else if (type.startsWith("none"))
*/
}

void WgzJSWidget::openApplication(QString uid)
{
    qDebug() << "openApplication: " << uid;
    widgetContainer()->openApplication(uid);
}

void WgzJSWidget::setDisplayLandscape()
{
    qDebug() << "setDisplayLandscape:";
}

void WgzJSWidget::setDisplayPortrait()
{
    qDebug() << "setDisplayPortrait:";
}

bool WgzJSWidget::isrotationsupported()
{
    qDebug() << "isrotationsupported:";
    return false;
}

QString WgzJSWidget::identifier() const
{
    return SuperJSWidget::identifier();
}

QVariant WgzJSWidget::preferenceForKey(const QVariant& key)
{
    return SuperJSWidget::preferenceForKey(key);
}

void WgzJSWidget::setPreferenceForKey(const QVariant& value, const QVariant& key)
{
    SuperJSWidget::setPreferenceForKey(value, key);
}
