/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _w3cjswidget_h
#define _w3cjswidget_h

#include <QObject>
#include <QVariant>
#include "superjswidget.h"

namespace WRT {

class WrtWidgetPage;
class WidgetContainer;

class W3CJSWidget : public SuperJSWidget {

    Q_OBJECT
    Q_PROPERTY(QString authorName READ authorName)
    Q_PROPERTY(QString authorEmail READ authorEmail)
    Q_PROPERTY(QString authorHref READ authorHref)
    Q_PROPERTY(QString name READ name)
    Q_PROPERTY(QString description READ description)
    Q_PROPERTY(QString version READ version)
    Q_PROPERTY(QString commandline READ commandline)
    Q_PROPERTY(QString message READ message)
    Q_PROPERTY(unsigned short width READ width)
    Q_PROPERTY(unsigned short height READ height)
    Q_PROPERTY(QString preferences READ preferences)
    Q_PROPERTY(QString id READ id)

public:
    QString id() const;
    QString authorName() const;
    QString authorEmail() const;
    QString authorHref() const;
    QString name() const;
    QString description() const;
    QString version() const;
    QString commandline() const;
    QString message() const;
    unsigned short width() const;
    unsigned short height() const;
    QString preferences() const;
    void notificationRecieved(WidgetContainer::WrtWidgetNotify value);

    W3CJSWidget(WidgetContainer *);
    ~W3CJSWidget();
};

}
#endif
