/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "superjswidget.h"
#include "w3cjswidget.h"
#include "webwidgetpreference.h"
#include "WebAppRegistry.h"
#include "wrtwidgetcontainer.h"
#include "w3celement.h"
#include "w3csettingskeys.h"
#include <QDebug>


Q_DECLARE_METATYPE(const W3CElement *)

using namespace WRT;

W3CJSWidget::W3CJSWidget(WidgetContainer* wrtWidgetContainer) :
    SuperJSWidget(wrtWidgetContainer)
{
}

W3CJSWidget::~W3CJSWidget ()
{
}

QString W3CJSWidget::authorName() const
{
    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetContainer()->widgetPreference()->widgetBundleId(), webAppInfo);
    AttributeMap attrMap = webAppInfo.attributes();
    QStringList keys = attrMap.keys();
    if (keys.contains(W3CSettingsKey::WIDGET_AUTHOR))
        return (attrMap[W3CSettingsKey::WIDGET_AUTHOR]).toString();
    return "";
}

QString W3CJSWidget::authorEmail() const
{
    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetContainer()->widgetPreference()->widgetBundleId(), webAppInfo);

    QList<W3CElement*> w3cElementsList = webAppInfo.getElement(W3CSettingsKey::WIDGET_AUTHOR);
    if (w3cElementsList.count() != 1)
        return ""; //Only one Author

    W3CElement* w3celem = w3cElementsList.at(0);
    if (!w3celem)
        return "";

    QString ret = w3celem->attributeValue("email");
    delete w3celem;
    return ret;
}

QString W3CJSWidget::authorHref() const
{
    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetContainer()->widgetPreference()->widgetBundleId(), webAppInfo);

    QList<W3CElement*> w3cElementsList = webAppInfo.getElement(W3CSettingsKey::WIDGET_AUTHOR);
    if (w3cElementsList.count() != 1)
        return "defultAuthorHref"; //Only one Author

    W3CElement* w3celem = w3cElementsList.at(0);
    if (!w3celem)
        return "defultAuthorHref";

    QString ret = w3celem->attributeValue("href");
    delete w3celem;
    return ret;
}

QString W3CJSWidget::name() const
{
    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetContainer()->widgetPreference()->widgetBundleId(), webAppInfo);

    QList<W3CElement*> w3cElementsList = webAppInfo.getElement(W3CSettingsKey::WIDGET_NAME);
    if (w3cElementsList.count() != 1)
        return ""; //Only one Name for local lang

    W3CElement* w3celem = w3cElementsList.at(0);
    if (!w3celem)
        return "";

    QString ret = w3celem->readElementText();
    delete w3celem;
    return ret;
}

QString W3CJSWidget::description() const
{
    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetContainer()->widgetPreference()->widgetBundleId(), webAppInfo);

    QList<W3CElement*> w3cElementsList = webAppInfo.getElement(W3CSettingsKey::WIDGET_DESCRIPTION);
    if (w3cElementsList.count() != 1)
        return ""; //Only one Description for local lang

    W3CElement* w3celem = w3cElementsList.at(0);
    if (!w3celem)
        return "";

    QString ret = w3celem->readElementText();
    delete w3celem;
    return ret;
}

QString W3CJSWidget::version() const
{
    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetContainer()->widgetPreference()->widgetBundleId(), webAppInfo);
    AttributeMap attrMap = webAppInfo.attributes();
    QStringList keys = attrMap.keys();
    if (keys.contains(W3CSettingsKey::WIDGET_VERSION))
        return (attrMap[W3CSettingsKey::WIDGET_VERSION]).toString();
    return "";
}

unsigned short W3CJSWidget::width() const
{
    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetContainer()->widgetPreference()->widgetBundleId(), webAppInfo);
    AttributeMap attrMap = webAppInfo.attributes();
    QStringList keys = attrMap.keys();
    if (keys.contains(W3CSettingsKey::WIDGET_WIDTH))   {
        return (attrMap[W3CSettingsKey::WIDGET_WIDTH]).toInt();
        }
    return -1;
}

unsigned short W3CJSWidget::height() const
{
    WebAppInfo webAppInfo;
    WebAppRegistry::instance()->isRegistered(widgetContainer()->widgetPreference()->widgetBundleId(), webAppInfo);
    AttributeMap attrMap = webAppInfo.attributes();
    QStringList keys = attrMap.keys();
    if (keys.contains(W3CSettingsKey::WIDGET_HEIGHT))   {
        return (attrMap[W3CSettingsKey::WIDGET_HEIGHT]).toInt();
        }
    return -1;
}

QString W3CJSWidget::preferences() const
{
    //not yet implemented
    return "";
}

QString W3CJSWidget::commandline() const
{
    return widgetContainer()->commandline();
}
QString W3CJSWidget::message() const
{
    return widgetContainer()->message();
}
void W3CJSWidget::notificationRecieved(WidgetContainer::WrtWidgetNotify value)
{
    switch (value) {
        case WidgetContainer::WrtWidgetOnmessagereceived:
            widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onmessagereceived) != 'undefined') && (widget.onmessagereceived != null)){widget.onmessagereceived();}");
            break;

        case WidgetContainer::WrtWidgetFocusIn:
            widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onshow) != 'undefined') && (widget.onshow != null)){widget.onshow();}");
            break;


        case WidgetContainer::WrtWidgetFocusOut:
            widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onhide) != 'undefined') && (widget.onhide != null)){widget.onhide();}");
            break;

        case WidgetContainer::WrtWidgetOnexit:
            widgetContainer()->wrtPage()->mainFrame()->evaluateJavaScript("if ((typeof(widget.onexit) != 'undefined') && (widget.onexit != null)){widget.onexit();}");
            break;

        default:
             //In case of any common UI events in future
             SuperJSWidget::notificationRecieved(value);
             break;
    }
}

QString W3CJSWidget::id() const
{
    return SuperJSWidget::identifier();
}




