/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef __WRTWIDGETCONTAINERMAEMO_H__
#define __WRTWIDGETCONTAINERMAEMO_H__

#include <QObject>
#include <QPointer>
#include <QMenu>
#include "wrtwidgetcontainerBase.h"
#include "widgetcoreglobal.h"

class WidgetProperties;
class QWebFrame;

namespace WRT {

class WrtNetworkAccessManager;
class WrtController;
class WrtPage;
class SecSession;
class ServiceLoader;
class SchemeHandler;

 namespace Maemo {
   class ServiceProvider;
   class ApplicationLauncher;
 }

class WIDGETCORE_EXPORT WidgetContainerMaemo : public WidgetContainerBase
{
Q_OBJECT

public:
  /** Constructor
   */
  WidgetContainerMaemo();


  /** Destructor
   */
  virtual ~WidgetContainerMaemo();

#ifdef Q_OS_MAEMO6
  /** Loads all plugins defined in pluginList.
   *  @param pluginList Names of plugins to be loaded.
   */
  void loadPlugins(QStringList pluginList);
#endif

  /** Sets relevant QWebSettings for wrt page.
   *  @param html5store Path to widget instance's HTML5 database.
   *  @param browsingCapa Browsing capacity of the widget. possible values:
   *         "all" - All links will open in widget window, "local" - All local
   *         links will open in widget window. Default is to open all links in
   *         the bowser.
   */
  void initPageSettings(QString html5store, QString browsingCapa);


  /** Returns plugin object based on the plugin name.
   *  @param name Name of the plugin
   *  @return Pointer to plugin object. The ownership of the object remains
   *          with this class.
   */
  QObject* pluginObject(QString name);

private:
  void setHttpProxy();

private:
  Maemo::ServiceProvider* m_serviceProvider;
  ServiceLoader* m_serviceLoader;
  Maemo::ApplicationLauncher* m_launcher;
  WRT::SchemeHandler * m_schemeHandler;
};

}

#endif
