/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef WWFWIDGETUTILS_H_
#define WWFWIDGETUTILS_H_

#include <QObject>
#include <QString>
#include <QStringList>
#include <QDir>
#include <QSize>

namespace WRT {
namespace Maemo {


    /**
      * Contains miscellanous utility functions.
      *
      */
class Utils: public QObject {
        Q_OBJECT

    public:

        /** Returns a list of languages that can be used for loading
         *  a suitable language version of a widget.
         *  @return Language list, where the most preferred language is the
         *          first item.
         */
        static QStringList getPreferredLanguages();

        /** Converts the language string.
          * Converts the supplied string so that underscores are converted to dashes.
          * In case the supplied string is not exactly five characters long then the
          * lang is returned as is.
          *
          * @param lang Input language (e.g "en_US")
          * @return Language in converted format (e.g "en-us")
          */
        static QString convertLanguage(QString lang);

        /**
          * Utilitiy function for recursive copying of directories
          *
          * @param src source directory
          * @param dst destination directory
          * @param overwrite if true target files will be overwritten
          *
          */
        static bool recursiveCopy(QDir src, QDir dst, bool overwrite);


        /**
          * Utility function for parsing QSize from QSettings-style string ("@Size(213 232)")
          *
          * @param s source string
          * @return QSize
          */
        static QSize parseSize(QString s );

};
}}

#endif /* WWFWIDGETUTILS_H_ */
