/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef WWF_WEBFACTORY_HH
#define WWF_WEBFACTORY_HH

#include <qwebpluginfactory.h>
#include <QString>
#include <QStringList>
#include <QUrl>
#include <QList>
#include <QObject>


namespace WRT { namespace Maemo{


/**
 * WRT::Maemo implementation for QWebPluginFactory
 * see http://doc.trolltech.com/4.5/qwebpluginfactory.html
 * for full documentation
 */
class MimeHandlerPluginFactory:public QWebPluginFactory{
   Q_OBJECT
public:
   MimeHandlerPluginFactory(QObject* p = 0);
   ~MimeHandlerPluginFactory();

   QObject* create(const QString& mimeType,
                   const QUrl& url,
                   const QStringList& argumentNames,
                   const QStringList& argumentValues) const;

   bool extension(Extension extension,
                  const ExtensionOption * option = 0,
                  ExtensionReturn * output = 0 );
   QList<Plugin> plugins () const;
   QString getAppByExtension(QString extension);
   QString getAppByMime(QString mime);
   void loadPluginSpecs();

   void refreshPlugins ();
   bool supportsExtension ( Extension extension ) const;

private:
   void addPlugin(QString,QString,QString,QString,QString);
   QList<Plugin> m_plugins;


};

}}
#endif

