/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "mimehandlerpluginfactory.h"
#include <QObject>
#include <QDebug>
#include <QLabel>
#include <QPixmap>


namespace WRT { namespace Maemo{



   MimeHandlerPluginFactory::MimeHandlerPluginFactory(QObject* p)
     :QWebPluginFactory(p)
   {
   }



   MimeHandlerPluginFactory::~MimeHandlerPluginFactory(){
   }

   QString MimeHandlerPluginFactory::getAppByExtension(QString extension)
   {
       foreach(Plugin plugin, m_plugins){
           foreach(MimeType type, plugin.mimeTypes){
               if (type.fileExtensions.contains(extension))
                 return plugin.name;
           }
       }
       return "";
   }

   QString MimeHandlerPluginFactory::getAppByMime(QString mime)
   {
       foreach(Plugin plugin, m_plugins){
           foreach(MimeType type, plugin.mimeTypes){
               if (type.name == mime)
                 return plugin.name;
           }
       }
       return "";
   }



   void MimeHandlerPluginFactory::addPlugin(QString name,
                                 QString mime,
                                 QString extension,
                                 QString parameter,
                                 QString value){
       Q_UNUSED(parameter);
       Q_UNUSED(value);
       Plugin p;
       p.name = name;
       p.description = "dummy";

       MimeType m;
       m.name = mime;
       m.fileExtensions<<extension;
       p.mimeTypes.append(m);
       m_plugins.append(p);
   }

   void MimeHandlerPluginFactory::loadPluginSpecs(){
#define mime_type( name, mime,ext,para, value) \
    addPlugin(#name,#mime,#ext,#para,#value);
#include "mimetypes.def"
#undef struct_member
   }

   QObject* MimeHandlerPluginFactory::create(const QString& mimeType,
                   const QUrl& url,
                   const QStringList& argumentNames,
                   const QStringList& argumentValues) const
   {

       qDebug()<<"\n\n"<<Q_FUNC_INFO<<"\n"<<mimeType<<"\n"<<url<<"\n"<<argumentNames<<"\n"<<argumentValues;
       Q_UNUSED(mimeType);
       Q_UNUSED(url);
       Q_UNUSED(argumentNames);
       Q_UNUSED(argumentValues);

       //demo
/*
       QPixmap * pix = new QPixmap("/tmp/example.jpg");

       QLabel* lb = new QLabel();
       lb->setPixmap(*pix);
       return lb;

  */
       return 0;
   }


   bool MimeHandlerPluginFactory::extension(Extension extension,
                  const ExtensionOption * option,
                  ExtensionReturn * output )
   {
       qDebug()<<Q_FUNC_INFO;
       Q_UNUSED(extension)
       Q_UNUSED(option)
       Q_UNUSED(output)
       return false;
   }


   QList<QWebPluginFactory::Plugin> MimeHandlerPluginFactory::plugins () const
   {

         qDebug()<<Q_FUNC_INFO;
       return m_plugins;

   }

   void MimeHandlerPluginFactory::refreshPlugins ()
   {
         qDebug()<<Q_FUNC_INFO;
   }


   bool MimeHandlerPluginFactory::supportsExtension ( Extension extension ) const
   {
       qDebug()<<Q_FUNC_INFO;
         Q_UNUSED(extension)
           return false;
   }

}}

