/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
 
#ifndef JAVASCRIPTEXTENSIONINTERFACE_H
#define JAVASCRIPTEXTENSIONINTERFACE_H

namespace WRT {
    class ServiceLoader;
    namespace Maemo {
      class WebWidget;
      class WebWidgetInstanceData;
    }
}

namespace NokiaAPI {

    namespace CJSEStatusCodes {

        const qint32 SUCCESS = 0;

        // NON-RECOVERABLE Exception codes
        const qint32 MISSING_ARG_ERR = 1;
        const qint32 INVALID_ARG_ERR = 2;
        const qint32 NOT_SUPPORTED_ERR = 3;

        // RECOVERABLE Exception codes
        const qint32 TIMEOUT_ERR = 100;
        const qint32 DATA_NOT_FOUND_ERR = 101;
        const qint32 DATA_ALREADY_EXISTS_ERR = 102;
        const qint32 SERVICE_BUSY_ERR = 103;
        const qint32 SERVICE_IN_USE_ERR = 104;
        const qint32 DATA_OUT_OF_RANGE_ERR = 105;
        const qint32 NOT_ALLOWED_ERR = 106;
        const qint32 SIZE_EXCEEDED_ERR = 107;
        const qint32 INVALID_URI_ERR = 108;
        const qint32 URI_NOT_FOUND_ERR = 109;
        const qint32 URI_ALREADY_EXISTS_ERR = 110;

    // DOMAIN SPECIFIC Status codes
    const qint32 DIR_NOT_EMPTY_ERR = 500;
    const qint32 FILE_ALREADY_OPEN_ERR = 501;
    const qint32 URI_NOT_SUPPORTED = 502;
    }


   /** Base class for all the JavaScript extensions.
      */
    class JavaScriptExtensionInterface {
        public:
        /** Sets the service loader.
          * Sets the service loader that the plugin
          * can later use e.g for evaluation JavaScript.
          *
          * @param loader Service loader.
          */
        virtual void setServiceLoader(WRT::ServiceLoader& loader) = 0;

        /** Gets the name of the plugin.
          *
          * @return The name of the plugin (e.g "File System API 2.0")
          */
        virtual QString name() const = 0;


       /** Page on reload
        * This function gets called when the page is being reloeaded
        * and the object is being newly added to page as javascript object
        */
       virtual void pageOnReload() = 0;


       /** setWidgetData
        * Implement this function in base class if you
        * want to plugin to be able to access instance data
        * and WebWidget
        */
       virtual void setWidgetData(WRT::Maemo::WebWidget*,
                                  WRT::Maemo::WebWidgetInstanceData*){}
    };
};

Q_DECLARE_INTERFACE(NokiaAPI::JavaScriptExtensionInterface, "com.nokia.JavaScriptExtensionInterface/1.0")

#endif // JAVASCRIPTEXTENSIONINTERFACE_H§
