/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "desktopfilereader.h"

#include <QFile>

namespace WRT {
    namespace Maemo {

        DesktopFileReader::DesktopFileReader(const QString & file) : m_valid(false),m_settings(0) {
            if (QFile(file).exists()) {
                m_settings = new QSettings(file, QSettings::IniFormat);
                validate();
            }
        }

        DesktopFileReader::~DesktopFileReader() {
            if (m_settings) {
                delete m_settings;
                m_settings = 0;
            }
        }

        bool DesktopFileReader::isValid() const {
            return m_valid;
        }

        void DesktopFileReader::validate() {
            // TODO : Move webwidget related stuff over here
            m_valid = true;
        }

        QString DesktopFileReader::fileName() const {
            return m_settings->fileName();
        }

        QString DesktopFileReader::value(const QString & key, const QString & defaultValue) const {
            return m_settings->value(key, defaultValue).toString();
        }

        bool DesktopFileReader::contains(const QString & key) const {
            return m_settings->contains(key);
        }

        QStringList DesktopFileReader::allKeys() const {
            return m_settings->allKeys();
        }
    }

}
