/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <openssl/bio.h>
#include <openssl/rsa.h>
#include <openssl/pem.h>
#include <QtCore>
#include <QCoreApplication>
#include <QtTest/QtTest>
#include <QCryptographicHash>
#include <QSslCertificate>
//#include "libbb5stub.h"
#include "SignatureValidator.h"

class ValidatorTest: public QObject {
  Q_OBJECT

  private:
  SignatureValidator * validator;

  //QCryptographicHash * c;
  //QSslCertificate * cert;
  // QString message;
  //QByteArray digest;


private slots:

  /** Called just before every test function. */
  void init() {

  }

  /** Called once before any of the tests are run.
      This function is called just once per test run and is meant for
      initialization if needed. In our case this is left empty.
  */
  void initTestCase() {
     validator = new SignatureValidator();
  }

  void testCheckGoodCertificate() {
    QFile certificatefile("testcertificates/goodcert.pem");
    certificatefile.open(QIODevice::ReadOnly);
    QByteArray certificate = certificatefile.readAll();
    QVERIFY(validator->checkCertificate(certificate) == 0);
    certificatefile.close();
  }


  void testCheckBadCertificate() {
    QFile certificatefile("testcertificates/badcert.pem");
    certificatefile.open(QIODevice::ReadOnly);
    QByteArray certificate = certificatefile.readAll();
    QVERIFY(validator->checkCertificate(certificate) != 0);
    certificatefile.close();
  }

  void testRsaVerifySuccess() {
    QFile datafile("signedinfo");
    QFile signaturefile("signature");
    QFile certificatefile("certificate");

    datafile.open(QIODevice::ReadOnly);
    signaturefile.open(QIODevice::ReadOnly);
    certificatefile.open(QIODevice::ReadOnly);

    QByteArray certificate = certificatefile.readAll();
    certificate.insert(0,"-----BEGIN CERTIFICATE-----\n");
    certificate.insert(certificate.size(),"\n-----END CERTIFICATE-----");

    QVERIFY(validator->rsaVerify(datafile.readAll(),signaturefile.readAll(),certificate)
        == SignatureValidator::Verification_Success);
    datafile.close();
    signaturefile.close();
    certificatefile.close();
  }

  void testRsaVerifyFailure() {
    QFile datafile("signedinfo");
    QFile signaturefile("signature");
    QFile certificatefile("certificate");

    datafile.open(QIODevice::ReadOnly);
    signaturefile.open(QIODevice::ReadOnly);
    certificatefile.open(QIODevice::ReadOnly);

    QByteArray certificate = certificatefile.readAll();
    certificate.insert(0,"-----BEGIN CERTIFICATE-----\n");
    certificate.insert(certificate.size(),"\n-----END CERTIFICATE-----");

    QByteArray data = datafile.readAll();
    data.append("x");

    QVERIFY(validator->rsaVerify(data,signaturefile.readAll(),certificate)
        == SignatureValidator::Verification_Failure);
    datafile.close();
    signaturefile.close();
    certificatefile.close();
  }

  void testBadCertificate() {
    QFile datafile("signedinfo");
    QFile signaturefile("signature");
    QFile certificatefile("certificate");

    datafile.open(QIODevice::ReadOnly);
    signaturefile.open(QIODevice::ReadOnly);
    certificatefile.open(QIODevice::ReadOnly);

    QByteArray certificate = certificatefile.readAll();
    certificate.insert(certificate.size(),"\n-----END CERTIFICATE-----");

    QVERIFY(validator->rsaVerify(datafile.readAll(),signaturefile.readAll(),certificate)
        == SignatureValidator::Bad_Certificate);
    datafile.close();
    signaturefile.close();
    certificatefile.close();
  }

 /** Called once just after all the tests have been run.
      This function is called after running all the tests. Do the cleanup
      here if needed (e.g compressing logs). In our case this is left empty.
  */
  void cleanupTestCase() {
    //bb5_finish();
  }


  /** Called just after every test function. */
  void cleanup() {


  }

};

QTEST_APPLESS_MAIN(ValidatorTest)

#include "validatortest.moc"

