/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QtCore/qpointer.h>
#include <QtCore/qstringlist.h>
#include <QDebug>

#include "serviceproxy.h"
#include "locationService.h"

namespace WRT {

    ServiceProxy::ServiceProxy(QObject& serviceObject, bool giveToGarbageCollector)
            :m_serviceObject(serviceObject) {
        m_valid = true;
        m_lastError = QString("ok");
        m_isInitialized = false;
        m_giveToGarbageCollector = giveToGarbageCollector;
    }

    void ServiceProxy::initialize() {
        m_isInitialized = true;
    }

    ServiceProxy::~ServiceProxy() {
    }

    const QMetaObject *ServiceProxy::metaObject() const {
        return m_serviceObject.metaObject();
    }

    void *ServiceProxy::qt_metacast(const char *_clname) {
        return m_serviceObject.qt_metacast(_clname);
    }

    int ServiceProxy::qt_metacall(QMetaObject::Call _c, int _id, void **_a) {
        // @todo : before you call this you need permission from
        // security manager
        return m_serviceObject.qt_metacall(_c, _id, _a);
    }

    bool ServiceProxy::isValid() {
        return m_valid;
    }

    QString ServiceProxy::getLastError() {
        return m_lastError;
    }

    QScriptEngine::ValueOwnership ServiceProxy::objectOwnership() {
        return m_giveToGarbageCollector ? QScriptEngine::ScriptOwnership : QScriptEngine::QtOwnership;
    }
}

