/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef SERVICELOADER_HH
#define SERVICELOADER_HH

#include <QObject>
#include <QMap>
#include <QStringList>

namespace WRT {

    class ServiceProvider;
    class ServiceProxy;
    class WrtPage;
    class ServiceLoader: public QObject {
            Q_OBJECT

        public:
            ServiceLoader();
            ~ServiceLoader();
            bool addService(const QString&, QObject&, bool giveToGarbageCollector=false);
            bool removeService(const QString&);
            bool setServiceProvider(ServiceProvider*);
            ServiceProvider* getServiceProvider() {
                return m_serviceHandler;
            }
            QStringList listServices();
            void setContext(WrtPage* page);
            WrtPage* getContext() {
                return m_page;    // should this class be using WrtPage ??
            }

        public slots:
            void windowObjectCleared();

        protected:
            ServiceProvider* m_serviceHandler;
            QMap<QString, ServiceProxy*> m_services;
            WrtPage* m_page;
    };
}
#endif



