/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QDebug>
#include "wrtpage.h"
#include "qwebframe.h"
#include "qwebpage.h"

#include "serviceloader.h"
#include "serviceproxy.h"
#include "serviceprovider.h"
namespace WRT {

    ServiceLoader::ServiceLoader() {

    }

    ServiceLoader::~ServiceLoader() {
    }

    void ServiceLoader::setContext(WrtPage* page) {
        m_page = page;
        connect(page->mainFrame(), SIGNAL(javaScriptWindowObjectCleared()),
                this, SLOT(windowObjectCleared()));

        // @todo : here we check the security manager
        // and then decide what services from the service provider
        // to expose.
    }
    bool ServiceLoader::addService(const QString& service_name, QObject& newObj, bool giveToGarbageCollector) {
        // save the service objects
        if (m_services.contains(service_name))
            return FALSE;
        // create service proxy so you can marshall
        // the calls

        ServiceProxy *proxy = new ServiceProxy(newObj, giveToGarbageCollector);
        proxy->initialize();
        m_services.insert(service_name, proxy);
        return TRUE;

    }

    bool ServiceLoader::removeService(const QString& service_name) {
        if (!m_services.contains(service_name))
            return FALSE;
        return m_services.remove(service_name);
    }

    bool ServiceLoader::setServiceProvider(ServiceProvider* provider) {
        m_serviceHandler = provider;
        return TRUE;
    }


    QStringList ServiceLoader::listServices() {
        QMapIterator<QString, ServiceProxy*> i(m_services);
        QStringList list_Services;
        while (i.hasNext()) {
            i.next();
            list_Services << i.key();
        }
        return list_Services;
    }

    void ServiceLoader::windowObjectCleared() {
        if (m_page != NULL) {
            QMap<QString, ServiceProxy*>::iterator i = m_services.begin();
            while (i != m_services.end()) {
                m_page->mainFrame()->addToJavaScriptWindowObject(i.key(),i.value(), i.value()->objectOwnership());
                ++i;
            }
        }
        if (m_serviceHandler)
          m_serviceHandler->pageOnReload();

    }

}
