/*
* ============================================================================
*  Name        : qsysinfoserviceplugin.h
*  Part of     : serviceproviders / WRT
*  Description : Qt plugin class for sysinfo service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef SYSINFOSERVICEPLUGIN_H_
#define SYSINFOSERVICEPLUGIN_H_

//INCLUDES
#include <QObject>
#include "serviceplugininterface.h"

// CLASS DECLARATION

/**
*  The class defines the methods for plugin instantiation
*  of SysInfo service provider
*  @lib sysinfoserviceplugin.qtplugin
*  @since x.y
*/
class SysInfoServicePlugin : public QObject, IServicePlugin
{
    Q_OBJECT
    Q_INTERFACES(IServicePlugin)

public:
    //public interfaces

    /**
    * Constructor
    */
    SysInfoServicePlugin();

    /**
    * Destructor
    */
    virtual ~SysInfoServicePlugin();

protected:
    // inherited methods

    /**
    * This API is used to instantiate Contact Service service provider
    * @since x.y
    * @param refCounted - true indicated reference counted object,
    *                     singleton object
    * @param secSession - pointer to Security Manager session - not owned
    * @return Interface pointer to SysInfo Service object
    */
    IServiceBase* getServiceBase( bool refCounted,
                                  WRT::SecSession *secSession );
};

#endif //SYSINFOSERVICEPLUGIN_H_
