/*
* ============================================================================
*  Name        : qsensordefines.h
*  Part of     : serviceproviders / WRT
*  Description : Qt class for sensor service
*  Version     : %version: 6 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QSENSORDEFINES_H_
#define QSENSORDEFINES_H_

#include <QString>


//Defines
#define MCE_SERVICE                             "com.nokia.mce"
#define MCE_REQUEST_PATH                        "/com/nokia/mce/request"
#define MCE_REQUEST_IF                          "com.nokia.mce.request"
#define MCE_GET_DEVICE_ORIENTATION              "get_device_orientation"

#define MCE_ORIENTATION_PORTRAIT                "portrait"
#define MCE_ORIENTATION_LANDSCAPE               "landscape"
#define MCE_ORIENTATION_PORTRAIT_INVERTED       "portrait (inverted)"
#define MCE_ORIENTATION_LANDSCAPE_INVERTED      "landscape (inverted)"
#define MCE_ORIENTATION_ON_STAND                "on_stand"
#define MCE_ORIENTATION_OFF_STAND               "off_stand"
#define MCE_ORIENTATION_FACE_UP                 "face_up"
#define MCE_ORIENTATION_FACE_DOWN               "face_down"
#define MCE_ORIENTATION_UNKNOWN                 "unknown"

#define HAL_PROXIMITY_SERVICE                   "org.freedesktop.Hal"
#define HAL_PROXIMITY_PATH                      "/org/freedesktop/Hal/devices/platform_proximity"
#define HAL_PROXIMITY_IF                        "org.freedesktop.Hal.Device"
#define HAL_PROXIMITY_GET_PROPERTY              "GetProperty"
#define HAL_PROXIMITY_STATE                     "button.state.value"

#define HAL_LIGHTSENSOR_SERVICE                 "org.freedesktop.Hal"
#define HAL_LIGHTSENSOR_PATH                    "/org/freedesktop/Hal/devices/als"
#define HAL_LIGHTSENSOR_IF                      "org.freedesktop.Hal.Device.LightSensor"
#define HAL_GET_BRIGHTNESS                      "GetBrightness"

#define SINGLE_START                            1
#define MIN_FREQUENCY                           10
#define MIN_FREQUENCY_NOT_CONTINUE              100

#define DB_TAPPING_FREQ                         1000
#define DB_TAPPING_MAX_COORD                    500
#define DB_TAPPING_MIN_COORD                    -500

#define SCF_ACCEL_SCALE_FACTOR                  0.0098;




//Supported input channels
const QString KAccelerometerAxis =              "AccelerometerAxis";
const QString KOrientation =                    "Orientation";
const QString KRotation =                       "Rotation";
const QString KAccelerometerDoubleTapping =     "AccelerometerDoubleTapping";
const QString KProximity =                      "Proximity";
const QString KIllumination =                   "Illumination";


//-Accelerometer
const QString KaxisX =                          "axisX";
const QString KaxisY =                          "axisY";
const QString KaxisZ =                          "axisZ";

//-Orientation
const QString Kdirection =                      "deviceOrientation";
const QString KdisplayUp =                      "DisplayUp";
const QString KdisplayDown =                    "DisplayDown";
const QString KdisplayLeftUp =                  "DisplayLeftUp";
const QString KdisplayRightUp =                 "DisplayRightUp";
const QString KdisplayUpwards =                 "DisplayUpwards";
const QString KdisplayDownwards =               "DisplayDownwards";
const QString KdisplayUnknown =                 "Unknown";

//-Rotation
const QString KrotationAboutXAxis =             "rotationAboutXAxis";
const QString KrotationAboutYAxis =             "rotationAboutYAxis";
const QString KrotationAboutZAxis =             "rotationAboutZAxis";

//-AccelerometerDoubleTapping
const QString KDeviceDirection =                "DeviceDirection";
const qint32  XPlus  =                          0x01;
const qint32  XMinus =                          0x02;
const qint32  YPlus  =                          0x04;
const qint32  YMinus =                          0x08;
const qint32  ZPlus  =                          0x10;
const qint32  ZMinus =                          0x20;
const qint32  Unknown =                         0x00;

//-Proximity
const QString KproximityState =                 "proximityState";

//-Illumination
const QString KBrightnessLevel =                "ambientLight";


//-Callback data keys
const QString KChannelName =                    "channelName";
const QString KtimeStamp =                      "timeStamp";
const QString KChannelData =                    "channelData";

//-Keys for Error Map
const QString KErrCode =                        "errorCode";
const QString KErrMessage =                     "errorMessage";

//-Keys for DBus Error
const QString KErrDBusIF =                      ":error create interface";
const QString KErrDBusMSG =                     ":msg is not reply";
const QString KErrDBusSG =                      ":error connect";

const QString m_getChannelEvent =               "getChannelEvent";
const QString m_startChannel =                  "startChannel";
const QString m_stopChannel =                   "stopChannel";
const QString m_setDesiredUpdateFrequency =     "setDesiredUpdateFrequency";
const QString m_getScaleFactor =                "getScaleFactor";
const QString m_dbusErrors =                    "dbusErrors";

//-Error messages
const QString KStrErrMissingArg =               "Missing input argument";
const QString KStrErrInvalidKey =               "Unsupported input argument";
const QString KStrErrInvalidTransID =           "Transaction id is invalid";
const QString KStrErrReadingGetInfo =           "Error in getting data";
const QString KStrErrTrigger =                  "Trigger values are out of range";
const QString KStrErrStop =                     "Attempt to stop non-existing notification";
const QString KStrErrPermission =               "Security check failed for input argument";

//-Error codes
const int SUCCESS                         = 0;
const int MISSING_ARG_ERR                 = 1;
const int INVALID_ARG_ERR                 = 2;
const int NOT_SUPPORTED_ERR               = 3;
const int SERVICE_NOT_AVAILABLE           = 4;

const int TIMEOUT_ERR                    = 100;
const int DATA_NOT_FOUND_ERR             = 101;
const int DATA_ALREADY_EXISTS_ERR        = 102;

const int SERVICE_BUSY_ERR               = 103;
const int SERVICE_IN_USE_ERR             = 104;

const int DATA_OUT_OF_RANGE_ERR          = 105;
const int NOT_ALLOWED_ERR                = 106;
const int SIZE_EXCEEDED_ERR              = 107;

const int INVALID_URI_ERR                = 108;
const int URI_NOT_FOUND_ERR              = 109;
const int URI_ALREADY_EXISTS_ERR         = 110;


#endif
