/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef GETMSGLISTTASK_H
#define GETMSGLISTTASK_H

#include <QRunnable>
#include <QObject>
#include <QMapIterator>
#include <QMap>
#include <QVariant>
#include <QStringList>
#include <QDateTime>
#include <QMutex>
#include <QWaitCondition>

#include "qmessagingconstants.h"
#include "messagefilter.h"

//QtMobility includes
#include <QMessageManager>
QTM_USE_NAMESPACE

class GetMsgListTask : public QObject, public QRunnable
{
    Q_OBJECT

public:
    GetMsgListTask(qint32 transaction_id, const MessageFilter& matchPattern, QMessageManager& manager);
    int getMessagesNow(QVariantList& aResults);
    void run();
    void finishTask();

Q_SIGNALS:
    void signalGetMsgListCb(GetMsgListTask* aTask, qint32 aTransactionId, int aErrorCode, QVariantList aList);

private:
    int getMessages(QVariantList& aResults);

private:
    qint32 iTransactionId;
    MessageFilter iMatchPattern;
    QVariantList iMessages;
    QMutex iMutex;
    QMutex iMutex2;
    QWaitCondition iWait;
    QMessageManager& iManager;
    bool iSynchronous;
};

#endif
