/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#include <QDebug>
#include <QDir>
#include <QFileInfo>
#include <QFile>

#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusReply>
#include <QtDBus/QDBusArgument>



#include "rdfselect.h"
#include "qmediakeyconstants.h"

const QString Tracker_service = "org.freedesktop.Tracker";
const QString Tracker_path = "/org/freedesktop/Tracker/Search";
const QString Tracker_interface = "org.freedesktop.Tracker.Search";


const QString RDFQUERY_INSET = "<rdfq:Condition>\n <rdfq:and> \n<rdfq:inSet> \n <rdfq:Property name='%1'/>\n \
                        <rdf:String>%2</rdf:String> \n </rdfq:inSet> \n </rdfq:and> \n</rdfq:Condition>";

const QString RDFQUERY_2_VALUE = "<rdfq:Condition>\n <rdfq:inSet> \n \
                          <rdfq:Property name='%1'/>\n \
                          <rdf:String>%2</rdf:String> \n </rdfq:inSet> \n \
                          </rdfq:Condition>";

const QString RDFQUERY_GREATERTHEN_INT = "<rdfq:Condition>\n <rdfq:and> \n<rdfq:greaterThan> \n<rdfq:Property name='%1'/>\n \
                                   <rdf:Integer>%2</rdf:Integer> \n </rdfq:greaterThan> \n </rdfq:and> \n</rdfq:Condition>";

const QString RDFQUERY_DATE_BETWEEN = "<rdfq:Condition>\n <rdfq:and> \n<rdfq:greaterThan> \n \
                               <rdfq:Property name='%1'/>\n <rdf:Date>%2</rdf:Date> \n </rdfq:greaterThan> \n \
                               <rdfq:lessThan> \n<rdfq:Property name='%1'/>\n <rdf:Date>%3</rdf:Date> \n </rdfq:lessThan> \n</rdfq:and> \n</rdfq:Condition>";

RDFselect::RDFselect():content_type(0) {

}




QVariantMap  RDFselect::resultListItem(QStringList array)
{
    QVariantMap item;

    if((array.count()-1)>=FIELD_URI){ item.insert(KUri,array.at(FIELD_URI));}
    else { item.insert(KUri,QString(" ")); }

    switch(content_type)
    {
    case CONTENT_FILES:
        item.insert(KType, KMediaTypeAll);
        break;
    case CONTENT_IMAGES:

        if((array.count()-1)>=IMAGE_FIELD_URI) { item.insert(KUri,array.at(IMAGE_FIELD_URI)); }
        else { item.insert(KUri,QString(" "));}

        if((array.count()-1)>=IMAGE_FIELD_SIZE)  { item.insert(KSize, (array.at(IMAGE_FIELD_SIZE)).toInt());}
        else  { item.insert(KSize,0); }

        if((array.count()-1)>=IMAGE_FIELD_TITLE) { item.insert(KFieldTitle, array.at(IMAGE_FIELD_TITLE)); }
        else { item.insert(KFieldTitle,QString(" "));}

        if((array.count()-1)>=IMAGE_FIELD_WIDTH) { item.insert(MFieldWidth_out, (array.at(IMAGE_FIELD_WIDTH)).toInt()); }
        else { item.insert(MFieldWidth_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_HEIGHT) { item.insert(MFieldHeight_out, (array.at(IMAGE_FIELD_HEIGHT)).toInt()); }
        else { item.insert(MFieldHeight_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_CAMERAMAKE) { item.insert(MFieldCameraMake_out, array.at(IMAGE_FIELD_CAMERAMAKE)); }
        else { item.insert(MFieldCameraMake_out,QString(" "));}

        if((array.count()-1)>=IMAGE_FIELD_CAMERAMODEL) { item.insert(MFieldCameraModel_out, array.at(IMAGE_FIELD_CAMERAMODEL)); }
        else { item.insert(MFieldCameraModel_out,QString(" "));}

        if((array.count()-1)>=IMAGE_FIELD_ISOSPEED) { item.insert(MFieldISOSpeed_out, (array.at(IMAGE_FIELD_ISOSPEED)).toInt()); }
        else { item.insert(MFieldISOSpeed_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_FNUMBER) { item.insert(MFieldFNumber_out, (array.at(IMAGE_FIELD_FNUMBER)).toInt()); }
        else { item.insert(MFieldFNumber_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_FOCALLENGHT) { item.insert(MFieldFocalLenght_out, (array.at(IMAGE_FIELD_FOCALLENGHT)).toInt()); }
        else { item.insert(MFieldFocalLenght_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_ORIENTATION) { item.insert(MFieldOrientation_out, (array.at(IMAGE_FIELD_ORIENTATION)).toInt()); }
        else { item.insert(MFieldOrientation_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_METERINGMODE) { item.insert(MFieldMeteringMode_out, array.at(IMAGE_FIELD_METERINGMODE)); }
        else { item.insert(MFieldMeteringMode_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_ORIGINALDATE) { item.insert(MFieldOriginalDate_out, QDate::fromJulianDay((array.at(IMAGE_FIELD_ORIGINALDATE)).toInt())); }
        else { item.insert(MFieldOriginalDate_out,QString(" "));}

        if((array.count()-1)>=IMAGE_FIELD_FLASH) { item.insert(MFieldFlash_out, (array.at(IMAGE_FIELD_FLASH)).toInt()); }
        else { item.insert(MFieldFlash_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_WHITEBALANCE) { item.insert(MFieldWhiteBalance_out, (array.at(IMAGE_FIELD_WHITEBALANCE)).toInt()); }
        else { item.insert(MFieldWhiteBalance_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_EXPOSURETIME) { item.insert(MFieldExposureTime_out, (array.at(IMAGE_FIELD_EXPOSURETIME)).toInt()); }
        else { item.insert(MFieldExposureTime_out,0);}

        if((array.count()-1)>=IMAGE_FIELD_COPYRIGHT) { item.insert(MFieldCopyright_out, array.at(IMAGE_FIELD_COPYRIGHT)); }
        else { item.insert(MFieldCopyright_out,QString(" "));}

        if((array.count()-1)>=IMAGE_FIELD_COMMENTS) { item.insert(MFieldComments_out, array.at(IMAGE_FIELD_COMMENTS)); }
        else { item.insert(MFieldComments_out,QString(" "));}

        if((array.count()-1)>=IMAGE_FIELD_DATE) { item.insert(MFieldDate_out, QDateTime::fromTime_t((array.at(AUDIO_FIELD_DATE)).toInt())) /*QDate::fromJulianDay((array.at(IMAGE_FIELD_DATE)).toInt()))*/; }
        else { item.insert(MFieldDate_out,0);}



        item.insert(KType, KMediaTypeImage);
                qDebug() << "item:" << item;
        break;
    case CONTENT_MUSIC:
        {
            if((array.count()-1)>=AUDIO_FIELD_URI) { item.insert(KUri,array.at(AUDIO_FIELD_URI)); }
            else { item.insert(KUri,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_ARTIST) {item.insert(KFieldComposer, array.at(AUDIO_FIELD_ARTIST)); }
            else {  item.insert(KFieldComposer,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_SIZE) { item.insert(KSize, (array.at(AUDIO_FIELD_SIZE)).toInt());}
            else { item.insert(KSize,0); }

            if((array.count()-1)>=AUDIO_FIELD_GENRE) { item.insert(KFieldGenre, array.at(AUDIO_FIELD_GENRE)); }
            else { item.insert(KFieldGenre,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_TRACK) {item.insert(KFieldTrack, array.at(AUDIO_FIELD_TRACK));}
            else { item.insert(KFieldTrack,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_ALBUM) { item.insert(KFieldAlbum, array.at(AUDIO_FIELD_ALBUM));}
            else { item.insert(KFieldAlbum,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_ARTIST) { item.insert(KFieldArtist, array.at(AUDIO_FIELD_ARTIST)); }
            else { item.insert(KFieldArtist,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_TITLE) { item.insert(KFieldTitle, array.at(AUDIO_FIELD_TITLE)); }
            else { item.insert(KFieldTitle,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_COPYRIGHT) { item.insert(MFieldCopyright_out, array.at(AUDIO_FIELD_COPYRIGHT)); }
            else { item.insert(MFieldCopyright_out,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_COMMENT) { item.insert(MFieldComment_out, array.at(AUDIO_FIELD_COMMENT)); }
            else { item.insert(MFieldComment_out,QString(" ")); }

            if((array.count()-1)>=AUDIO_FIELD_RELEASEDATE) { item.insert(MFieldReleaseDate_out, QDate::fromJulianDay((array.at(AUDIO_FIELD_RELEASEDATE)).toInt())); }
            else { item.insert(MFieldReleaseDate_out,0); }

            if((array.count()-1)>=AUDIO_FIELD_DATE) { item.insert(MFieldDate_out, QDateTime::fromTime_t((array.at(AUDIO_FIELD_DATE)).toInt()))/*QDate::fromJulianDay((array.at(AUDIO_FIELD_DATE)).toInt()))*/; }
            else { item.insert(MFieldDate_out,0); }


            item.insert(KType, KMediaTypeAudio);
        qDebug() << "item:" << item;
        }
        break;
    case CONTENT_VIDEOS:
        if((array.count()-1)>=VIDEO_FIELD_URI) { item.insert(KUri,array.at(FIELD_URI)); }
        else { item.insert(KUri,QString(" ")); }

        //        if((array.count()-1)>=FIELD_GENRE) { item.insert(KFieldGenre, array.at(FIELD_GENRE));}
        //        else { item.insert(KFieldGenre,QString(" ")); }

        //        if((array.count()-1)>=FIELD_TRACK) { item.insert(KFieldTrack, array.at(FIELD_TRACK));}
        //        else { item.insert(KFieldTrack,QString(" ")); }
        //
        //        if((array.count()-1)>=FIELD_ARTIST) { item.insert(KFieldArtist, array.at(FIELD_ARTIST));}
        //        else { item.insert(KFieldArtist,QString(" ")); }

        if((array.count()-1)>=VIDEO_FIELD_TITLE) { item.insert(KFieldTitle, array.at(VIDEO_FIELD_TITLE)); }
        else { item.insert(KFieldTitle,QString(" ")); }

        if((array.count()-1)>=VIDEO_FIELD_DURATION) { item.insert(MFieldDuration_out, (array.at(VIDEO_FIELD_DURATION)).toInt()); }
        else { item.insert(MFieldDuration_out,0); }

        if((array.count()-1)>=VIDEO_FIELD_WIDTH) { item.insert(MFieldWidth_out, (array.at(VIDEO_FIELD_WIDTH)).toInt()); }
        else { item.insert(MFieldWidth_out,0); }

        if((array.count()-1)>=VIDEO_FIELD_HEIGHT) { item.insert(MFieldHeight_out, (array.at(VIDEO_FIELD_HEIGHT)).toInt()); }
        else { item.insert(MFieldDuration_out,0); }

        if((array.count()-1)>=VIDEO_FIELD_COMMENTS) { item.insert(MFieldComments_out, array.at(VIDEO_FIELD_COMMENTS)); }
        else { item.insert(MFieldComments_out,QString(" ")); }

        if((array.count()-1)>=VIDEO_FIELD_TYPE) { item.insert(MFieldMime_out, array.at(VIDEO_FIELD_TYPE)); }
        else { item.insert(MFieldMime_out,QString(" ")); }

        if((array.count()-1)>=VIDEO_FIELD_SIZE) { item.insert(MFieldSize_out, (array.at(VIDEO_FIELD_SIZE)).toInt()); }
        else { item.insert(MFieldSize_out,0); }

        if((array.count()-1)>=VIDEO_FIELD_COPYRIGHT) { item.insert(MFieldCopyright_out, array.at(VIDEO_FIELD_COPYRIGHT)); }
        else { item.insert(MFieldCopyright_out,QString(" ")); }

        if((array.count()-1)>=VIDEO_FIELD_DATE) { item.insert(MFieldDate_out, QDate::fromJulianDay((array.at(VIDEO_FIELD_DATE)).toInt())); }
        else { item.insert(MFieldDate_out,QString(" ")); }

        item.insert(KType, KMediaTypeVideo);
        qDebug() << "item:" << item;
        break;

    default:
        item.insert(KUri,array.at(FIELD_URI));
        item.insert(KType, KMediaTypeAll);
        break;
    }

    return item;
}

bool RDFselect::makeSelect()
{

    int	        limit = 512;
    int	        offset = 0;

    QString query_base ;
    if(property_name.isEmpty() == false)
    {
        query_base = QString(RDFQUERY_INSET).arg(property_name).arg(property_value);
    }
    else
    {
        qDebug ()<<"startDate.isNull() = "<<startDate.isNull();
        qDebug ()<<"endDate.isNull() = "<<endDate.isNull();
        if(startDate.isNull() == false && endDate.isNull() == false)
        {
            query_base = QString(RDFQUERY_DATE_BETWEEN).arg(MPrefixFile+MFieldDate)
                         .arg(startDate.toString(Qt::ISODate)).arg(endDate.toString(Qt::ISODate));
        }
        else
        {
            qDebug ("invalid query to Tracker");
            return true;
        }
    }


    QDBusInterface iface(Tracker_service, Tracker_path, Tracker_interface ,QDBusConnection::sessionBus());
    if(!iface.isValid())
    {
        qDebug ("Could not establish a DBus connection to Tracker");
        return false;
    }


    QList<QVariant> xArg;
/*
    Query(
            int32 live_qury_id,
            String service,
            Array of [String] fields,
            String search_text,
            Array of [String] keywords,
            String query_condition,
            Boolean sort_by_service,
            Array of [String] sort_fields,
            Boolean sort_descending,
            Int32 offset,
            Int32 max_hits


            )?? (Array of[Array of [String]] result)
            "isasiassbasbii"
    */

    xArg.append((int)time(NULL));
    xArg.append(getServiceTypeAsString());
    xArg.append(getFieldsQArray());
    xArg.append(QString());
    xArg.append(QStringList());
    xArg.append(query_base);
    xArg.append(false);
    xArg.append(getOrderByQArray());
    xArg.append(sortMethod);
    xArg.append(offset);
    xArg.append(limit);

    QDBusArgument arg;
    QDBusMessage response=iface.callWithArgumentList(QDBus::Block, "Query", xArg);

qDebug() << "response.type = " << response.type();
qDebug() << "xArg = " << xArg;
    switch(response.type())
    {
    case QDBusMessage::ReplyMessage:
        arg=response.arguments().at(0).value<QDBusArgument>();

        arg.beginArray();
        while ( !arg.atEnd() )
        {
            QStringList element;
            arg >> element;
            qDebug()<< Q_FUNC_INFO << "element" << element;


            query_result.append(static_cast<QVariant>(resultListItem(element)));
        }
        arg.endArray();

        return true;

    case QDBusMessage::MethodCallMessage:
    case QDBusMessage::SignalMessage:
    case QDBusMessage::InvalidMessage:

        return false;
    case QDBusMessage::ErrorMessage:
        qDebug ()<<"Could not query search"<<response.errorMessage();
        return false;
    }

    return true;
}

QString RDFselect::getServiceTypeAsString()
{
    switch(content_type)
    {
    case CONTENT_IMAGES:
        return QString("Images");
    case CONTENT_MUSIC:
        return QString("Music");
    case CONTENT_VIDEOS:
        return QString("Videos");
    default:
        return QString("Files");
    }
}


QStringList RDFselect::getFieldsQArray()
{
    return List_fields;
}

QStringList RDFselect::getOrderByQArray()
{
    QStringList xlist;
    xlist.append(orderby);
    return xlist;
}

bool RDFselect::checkFileIndexed(QString filePath)
{

    qDebug() << Q_FUNC_INFO;

    bool ret=false;

    int	        limit = 512;
    int	        offset = 0;

    QFileInfo fi(filePath);
    QDir dir=fi.absoluteDir();
    QString path=dir.absolutePath();
    QString property_name1(MPrefixFile+MFieldName);
    QString property_value1(fi.fileName());

    QString  query_base = QString(RDFQUERY_2_VALUE).arg(property_name1).arg(property_value1);

    QDBusInterface iface(Tracker_service, Tracker_path, Tracker_interface ,QDBusConnection::sessionBus());

    if(!iface.isValid())
    {
        qDebug ("Could not establish a DBus connection to Tracker");
        return false;
    }


    List_fields.append(MPrefixFile+MFieldPath);
    List_fields.append(MPrefixFile+MFieldName);
    orderby = MPrefixFile+MFieldName;

    QList<QVariant> xArg;

    xArg.append((int)time(NULL));               // int32 live_qury_id
    xArg.append(getServiceTypeAsString());      // String service
    xArg.append(getFieldsQArray());             // Array of [String] fields
    xArg.append(QString());                     // String search_text
    xArg.append(QStringList());                 // Array of [String] keywords
    xArg.append(query_base);                    // String query_condition
    xArg.append(false);                         // Boolean sort_by_service
    xArg.append(getOrderByQArray());            // Array of [String] sort_fields
    xArg.append(false);                         // Boolean sort_descending
    xArg.append(offset);                        // Int32 offset
    xArg.append(limit);                         // Int32 max_hits

    QDBusArgument arg;
    QDBusMessage response=iface.callWithArgumentList(QDBus::Block, "Query", xArg);
    switch(response.type())
    {
    case QDBusMessage::ReplyMessage:
        arg=response.arguments().at(0).value<QDBusArgument>();
        arg.beginArray();
        ret=false;
        while ( !arg.atEnd() )
        {
            QStringList element;
            arg >> element;
            if (path.compare(element.takeAt(2)))
            {
                ret=true;
            }
        }
        arg.endArray();

        return ret;

   case QDBusMessage::MethodCallMessage:
   case QDBusMessage::SignalMessage:
   case QDBusMessage::InvalidMessage:
        return false;
   case QDBusMessage::ErrorMessage:
        qDebug ()<<"Could not query search"<<response.errorMessage();
        return false;
    }
    return ret;
}
