/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef qmediakeyconstants_h
#define qmediakeyconstants_h
#include <QStringList>

const QString TmpThumbnailPath = "/home/user/.thumbnails";

const int KMaxFileUriLength = 255;

//QT Keys for Media inputs
const QString KType                 = "type";
const QString KField                = "field";
const QString KFieldName            = "name";
const QString KFieldValue           = "value";
const QString KDateRange            = "dateRange";
const QString KDateStart            = "start";
const QString KDateEnd              = "end";
const QString KSortBy               = "sortBy";
const QString KFieldDate            = "date";

const QString KFieldTitle           = "title";
const QString KFieldArtist          = "artist";
const QString KFieldAlbum           = "album";
const QString KFieldGenre           = "genre";
const QString KFieldTrack           = "track";
const QString KFieldComposer        = "composer";

const QString KSortByDate           = "date";
const QString KSortByTitle          = "title";
const QString KSortByArtist         = "artist";
const QString KSortByAlbum          = "album";
const QString KSortByGenre          = "genre";
const QString KSortByTrack          = "track";
const QString KSortByComposer       = "composer";

const QString KLatitude             = "latitude";
const QString KLongitude            = "longitude";
const QString KAltitude             = "altitude";

const QString KMediaTypeStream      = "stream";
const QString KMediaTypeAudio       = "audio";
const QString KMediaTypeVideo       = "video";
const QString KMediaTypeImage       = "image";
const QString KMediaTypeAll         = "all";

//Keys for Thumbnail info
const QString KUri                  = "uri";
const QString KSize                 = "size"; //used also for getList
const QString KWidth                = "width";
const QString KHeight               = "height";
const QString KAspectRatioOption    = "aspectRatioOption";

//Keys for Error Map
const QString KErrCode              = "errorCode";
const QString KErrMsg               = "errorMessage";
const QString KTransId              = "transactionId";
const QString KReturnValue          = "returnValue";
const QString KUnKErr               = "Unknown";

const int KInvalidTransId = -1;
const int KSortAscending = 0;
const int KSortDescending = 1;


#define FORWARDSLASHSTRING QString("/")
#define DOT QString(".")
#define EMPTY_STRING QString("")

typedef unsigned long long int64;

const QStringList mediaFieldList = QStringList() <<
		                       "size" <<
		                       "date" <<
                               "title"<<
                               "artist"<<
                               "album"<<
                               "composer"<<
                               "track"<<
                               "genre"<<
                               "type"<<
                               "uri"<<
                               "latitude"<<
                               "longitude"<<
                               "altitude" <<
                               "image" <<
                               "audio" <<
                               "video" <<
                               "stream"<<
                               "MimeType"<<
                               "all"
                               ;
//                               "dateRange"<<
//                               "start"<<
//                               "end";
const int64 KNULL          =0x0;
const int64 KBASE          = 0x1;
const int64 KMFSIZE        = KBASE;
const int64 KMFDATE        = KBASE<<1;
const int64 KMFTITLE       = KBASE<<2;
const int64 KMFARTIST      = KBASE<<3;
const int64 KMFALBUM       = KBASE<<4;
const int64 KMFCOMPOSER    = KBASE<<5;
const int64 KMFTRACK       = KBASE<<6;
const int64 KMFGENRE       = KBASE<<7;
const int64 KMFTYPE        = KBASE<<8;
const int64 KMFURI         = KBASE<<9;
const int64 KMFLATITUDE    = KBASE<<10;
const int64 KMFLONGITUDE   = KBASE<<11;
const int64 KMFALTITUDE    = KBASE<<12;
const int64 KMFIMAGE       = KBASE<<13;
const int64 KMFAUDIO       = KBASE<<14;
const int64 KMFVIDEO       = KBASE<<15;
const int64 KMFSTREAM      = KBASE<<16;
const int64 KMFMIMETYPE    = KBASE<<17;
const int64 KMFALL         = KBASE<<18;
const int64 KMFDURATION    = KBASE<<19;
//const int64 KMFDATERANGE   = KBASE<<13;
//const int64 KMFSTARTDATE   = KBASE<<14;
//const int64 KMFENDDATE     = KBASE<<15;

// additional fields which would be present in the o/p are not mentioned here. Shall we ?
const int64 KMFBASE        = KMFSIZE | KMFDATE | KMFURI | KMFTITLE;
const int64 KMFAVCOMMON    = KMFBASE | KMFGENRE | KMFTRACK | KMFARTIST;

const int64 KMFIMAGEFIELDS       = KMFBASE;
const int64 KMFAUDIOFIELDS       = KMFBASE | KMFAVCOMMON | KMFALBUM | KMFCOMPOSER;
const int64 KMFVIDEOFIELDS       = KMFAVCOMMON;
const int64 KMFSTREAMFIELDS      = KMFAVCOMMON;
const int64 KMFALLFIELDS         = KMFIMAGEFIELDS | KMFAUDIOFIELDS | KMFVIDEOFIELDS | KMFSTREAMFIELDS;


const int64 KMFIMAGEIPMASK = ((KMFIMAGEFIELDS ^ KMFDATE) ^ KMFSIZE) ^ KMFURI;
const int64 KMFAUDIOIPMASK = ((KMFAUDIOFIELDS ^ KMFDATE) ^ KMFSIZE) ^ KMFURI;
const int64 KMFVIDEOIPMASK = ((KMFVIDEOFIELDS ^ KMFDATE) ^ KMFSIZE) ^ KMFURI;

const int64 KMFIMAGESORTMASK = KMFIMAGEIPMASK | KMFDATE;
const int64 KMFAUDIOSORTMASK = KMFAUDIOIPMASK | KMFDATE;
const int64 KMFVIDEOSORTMASK = KMFVIDEOIPMASK | KMFDATE;

#endif /* qmediakeyconstants_h */
