/*
* ============================================================================
*  Name        : contactserviceplugin.cpp
*  Part of     : serviceframework / WRT
*  Description : Qt plugin class for location provider
*  Version     : %version: 22 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "qlocationserviceplugin.h"


/**
 * Default constructor
 */
LocationPlugin::LocationPlugin()
{
}

/**
 * Destructor
 */
LocationPlugin::~LocationPlugin()
{
}

/**
 * This API is used to instantiate Location service.
 * @param refCounted true reference counted object.
 * @param secSession Security Manager session - not owned
 * @return interface pointer to Location Service object
 */
IServiceBase* LocationPlugin::getServiceBase(bool refCounted, WRT::SecSession *secSession)
{

    IServiceBase* pInterface(NULL);
    CREATE_SERVICE_OBJECT(LocationProvider, pInterface, refCounted);
    if (pInterface) {
        // add children if applicable, child ownership transferred
        IServiceSecurity *security=NULL;
        if (refCounted) {
            security = static_cast<IServiceSecurity*>(serviceObject);
        }
        else  {
            security = static_cast<IServiceSecurity*>(singletonServiceObject);
        }
        security->setSecuritySession(secSession);
    }
    return pInterface;
}

Q_EXPORT_PLUGIN(LocationPlugin);
