/*
* ============================================================================
*  Name        : timeObserver.cpp
*  Part of     : serviceframework / WRT
*  Description : Qt class for Location service
*  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "timeObserver.h"
#include <limits.h>  // for using maximum value of integer

timeObserver::timeObserver(qint32 transaction_id, QVariant aTimerOption):
        m_trId(transaction_id),
        timerOption(aTimerOption),
        timeOutTimer(NULL)
{
    timeOutTimer = new QTimer();
    connect(timeOutTimer, SIGNAL(timeout()), this, SLOT(timeOut()));
    if (timerOption.canConvert(QVariant::Int))
    {
        timeOutTimer->setInterval(timerOption.toInt());
    }
    else
    {
        // if we can't convert number from long to int we'll use the maximum value of int
        timeOutTimer->setInterval(INT_MAX);
    }
}

timeObserver::~timeObserver()
{
    disconnect(timeOutTimer, 0, 0, 0);
    if (timeOutTimer)
    {
        delete timeOutTimer;
    }
}

void timeObserver::run()
{
    timeOutTimer->stop();
    timeOutTimer->start();
}

void timeObserver::timeOut()
{
    emit timeOutCB(m_trId);
}
