/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef MYLOG_H_
#define MYLOG_H_

//INCLUDES
#include <QString>
#include <QFile>

//MACRO DEFINITION
#ifdef DEBUG_MODE
#define LOG(x) MyLog::writeToLogFile(x)
#else
#define LOG(x)
#endif

// CLASS DECLARATION

/**
 *  This class implements the logging mechanism for filesystemserviceplugin.
 *  @lib filesystemserviceplugin.qtplugin
 *  @since x.y
 */

class MyLog
    {
public:
    //public interfaces

    /**
     * Constructor
     */
    MyLog();

    /**
     * Destructor
     */
    virtual ~MyLog();

    /**
     * Implementation for logging the debug message
     * @since x.y
     * @param str - message to be written into log file
     * @return none
     */
    static void writeToLogFile(QString str);
    };

#endif /* MYLOG_H_ */
