/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */



#ifndef ERRORCODES_H_
#define ERRORCODES_H_

const int SUCCESS = 0;

const int MISSING_ARG_ERR = 1;
const int INVALID_ARG_ERR = 2;
const int NOT_SUPPORTED_ERR = 3;

const int DATA_NOT_FOUND_ERR = 101;
const int SERVICE_IN_USE_ERR = 104;
const int DATA_OUT_OF_RANGE_ERR = 105;
const int INVALID_URI_ERR = 108;
const int URI_NOT_FOUND_ERR = 109;
const int URI_ALREADY_EXISTS_ERR = 110;

const int DIR_NOT_EMPTY_ERR = 500;
const int FILE_ALREADY_OPEN_ERR = 501;
const int URI_NOT_SUPPORTED  = 502;
const int NOT_ALLOWED_ERR = 106;
#endif //ERRORCODES_H_
