/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef CONSTANTS_H_
#define CONSTANTS_H_

class QFile;

typedef struct _FileInfo
    {
    QFile* fileHandle;
    QString encoding;
    }FileInfo;

    const QString NOKIA_USER = "nokiaUser";
    const QString MOUNTPOINT_URI = "uri";
    const QString MOUNTPOINT_SIZE = "size";
    const QString MOUNTPOINT_AVAILABLESIZE = "availableSize";
    const QString MOUNTPOINT_NAME = "name";
    const QString MOUNTPOINT_ISWRITABLE = "isWritable";
    const QString MOUNTPOINT_TYPE = "type";
    const QString MOUNTPOINT_ISDEFAULT = "isDefault";

    //file or directory level operations
    const int CREATEDIR_METHOD      = 0;
    const int REMOVE_METHOD         = 1;
    const int RENAME_METHOD         = 2;
    const int GETDIRCONTENTS_METHOD = 3;
    const int COPY_METHOD           = 4;
    const int MOVE_METHOD           = 5;
    const int SEARCH_METHOD         = 6;
    const int OPENFILE_METHOD       = 7;

    //file io operations
    const int CLOSE_METHOD          = 8;
    const int READ_METHOD           = 9;
    const int READLINE_METHOD       = 10;
    const int READBASE64_METHOD     = 11;
    const int WRITE_METHOD          = 12;
    const int WRITELINE_METHOD      = 13;
    const int WRITEBASE64_METHOD    = 14;
    const int FLUSH_METHOD          = 15;
    const int SEEK_METHOD           = 16;

    //mount point operations
    const int GETMOUNTPOINTS_METHOD = 17;
    const int GETDEFAULTPATH_METHOD = 18;
    const int NOTIFYMOUNTEVENTS_METHOD = 19;

    const int GETELEMENTINFO_METHOD = 20;
    const int SEARCHMATCHOBJECT_METHOD = 21;

    const QString READ_MODE = "r";
    const QString READ_PLUS_MODE = "r+";
    const QString WRITE_MODE = "w";
    const QString WRITE_PLUS_MODE = "w+";
    const QString APPEND_MODE = "a";
    const QString APPEND_PLUS_MODE = "a+";
    const QString READ_TEXT_MODE = "rt";
    const QString READ_PLUS_TEXT_MODE = "r+t";
    const QString WRITE_TEXT_MODE = "wt";
    const QString WRITE_PLUS_TEXT_MODE = "w+t";
    const QString APPEND_TEXT_MODE = "at";
    const QString APPEND_PLUS_TEXT_MODE = "a+t";

    //return data strings
    const QString ERRORCODE_STR = "ErrorCode";
    const QString ERRORMESSAGE_STR = "ErrorMessage";
    const QString DATA_STR = "data";

    //File Attributes
    const QString ELEMENT_URI = "uri";
    const QString ELEMENT_TYPE = "type";
    const QString ELEMENT_READONLY = "readOnly";
    const QString ELEMENT_SIZE = "size";
    const QString ELEMENT_MODIFIEDDATE = "modifiedDate";
    const QString ELEMENT_CREATEDATE = "createDate";

    //constants for search based on match object , key values
    const QString  FILE_PATH_STR = "searchUri";
    const QString  ISDIRECTORY_STR = "isDirectory";
    const QString  FILE_SIZE_STR = "size";
    const QString  MODIFY_DATE_STR = "modifiedDate";
    const QString  CREATE_DATE_STR = "createDate";
    const QString  FILE_NAME_STR = "fileName";
    //Element Types
    const int FILE_TYPE      = 0;   //Element is a file.
    const int DIRECTORY_TYPE = 1;   //Element is a directory.
    const int LINK_TYPE      = 2;   //Element is a symbolic link.

    //search constants
    const int PARTIAL  = 0;
    const int COMPLETE = 1;

    //search output string constants
    const QString ELEMENT_STR = "element";
    const QString STATE_STR = "state";

    //mount event info constants
    const QString MOUNTEVENTINFO_STATUS_STR = "status";
    const QString MOUNTEVENTINFO_POINT_STR = "mountInfo";
    const int DISCONNECTED = 0;
    const int CONNECTED    = 1;

    //SEEK Options
    const int SEEKSTART   = 0;
    const int SEEKCURRENT = 1;
    const int SEEKEND     = 2;

    //KiloBytes constant
    const int KILO_BYTE = 1024;

    //notification active
    const int NOTIFICATION_DUMMY_ID = -1;

    //memory types
    const int INTERNAL_MEMORY  = 0;
    const int REMOVABLE_MEMORY = 1;
    const int REMOTE_MEMORY    = 2;
    const int UNKNOWN_MEMORY    = 3;


    //content types
    const QString ROOT_TYPE = "Root";
    const QString AUDIO_TYPE = "Audio";
    const QString VIDEO_TYPE = "Video";
    const QString IMAGE_TYPE = "Image";
    const QString ALL_CONTENT_TYPE = "All";

    //error message strings
    const QString NOT_ALLOWED_ERR_STR = "Security check failed for the input path";
    const QString INVALID_URI_ERR_STR = "URI is invalid";
    const QString NOT_SUPPORTED_ERR_STR = "URI is not supported";
    const QString INVALID_ARG_ERR_STR = "Invalid argument";
    const QString SUCCESS_STR = "SUCCESS";
    const QString NEWNAME_INVALID_STR =  "NewName is invalid";
    const QString SOURCE_NOT_EXISTS_STR = "Source does not exist";
    const QString DESTINATION_EXISTS_STR = "Destination already exists";
    const QString FILE_ALREADY_OPEN_STR = "Element is in use";
    const QString ELEMENT_NOT_DIR_STR = "Element is not a directory";
    const QString DIR_NOT_EMPTY_STR = "Directory is not empty";
    const QString ENCODING_FORMAT_NOT_SUPPORTED_STR = "Encoding Format not supported";
    const QString SOURCE_NOT_FILE_STR = "Source is not a file";
    const QString MODE_IS_INVALID_STR = "Mode is invalid";
    const QString FILE_ALREADY_OPEN_ERR_STR = "File open failed";
    const QString HANDLE_NOT_FOUND_ERR_STR = "File handle is invalid";
    const QString TRANS_ID_NOT_FOUND_ERR_STR = "Transaction Id not found";
    const QString WRITE_OP_FAILED_STR = "Write operation failed";
    const QString FLUSH_OP_FAILED_STR = "Flush operation failed";
    const QString SEEK_OP_FAILED_STR = "Seek operation failed";
    const QString GETMOUNTPOINTS_OP_FAILED_STR = "getMountPoints operation failed";
    const QString GETDEFAULTPATH_OP_FAILED_STR = "getDefaultPath operation failed";
    const QString SERVICE_NOT_IN_USE_STR = "Service not in use";
    const QString SYSTEM_ERROR_STR = "System Error";
    const QString NOTIFICATION_ALREADY_ACTIVE_STR = "Notification already active";
    const QString TOO_MANY_RESULTS_STR = "Too many results";

#ifndef __MAEMO__
    const QString LOG_DIR = "C:\\data\\others\\logs";
    const QString LOG_FILE = "C:\\data\\others\\logs\\filesystemlog.txt";
    const QString DRIVE_SEPERATOR = ":";
    const QString FILE_PROTOCOL = "file:///";
#else
    const QString LOG_DIR = "/tmp/FileSystem/logs";
    const QString LOG_FILE = "/tmp/FileSystem/logs/filesystemlog.txt";
    const QString DRIVE_SEPERATOR = "";
    const QString FILE_PROTOCOL = "file://";
#endif

#endif
