/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef FILESYSTEMSERVICEPLUGIN_H_
#define FILESYSTEMSERVICEPLUGIN_H_

//INLCUDES
#include <QObject>
#include "serviceplugininterface.h"

// CLASS DECLARATION

/**
 *  The class defines the methods for plugin instantiation
 *  of Filesystem service provider
 *  @lib filesytemserviceplugin.qtplugin
 *  @since x.y
 */
class FileSystemServicePlugin : public QObject, IServicePlugin
    {
    Q_OBJECT
    Q_INTERFACES(IServicePlugin)

public:
    //public interfaces

    /**
     * Constructor
     */
    FileSystemServicePlugin();

    /**
     * Destructor
     */
    virtual ~FileSystemServicePlugin();

protected:
    // inherited methods

    /**
     * This API is used to instantiate filesystem service provider
     * @since x.y
     * @param refCounted - true indicated reference counted object,
     *                     singleton object
     * @param secSession - pointer to Security Manager session - not owned
     * @return Interface pointer to filesystem Service object
     */
    IServiceBase* getServiceBase(bool refCounted, WRT::SecSession *secSession);
    };

#endif //FILESYSTEMSERVICEPLUGIN_H_
