# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

######################################################################
#
# Common Web Run Time Service Provider - common QMake settings
#
######################################################################

ROOT_DIR = $$PWD/../..
WRT_DIR = $$ROOT_DIR/wrt

include($$WRT_DIR/cwrt.pri)
include($$Root_DIR/shared.pri)

INCLUDEPATH += $$CWRT_INCLUDE

symbian {
    # Work around All Files capability
    # Dummy source file, target dll will be generated by qmake
    dummydeploy.sources = ./$${TARGET}.dll
    dummydeploy.path = /resource/qt/sfwplugin
    DEPLOYMENT += dummydeploy

    # Export registration file for winscw
    myblock = ".\\descriptionxml\\$${TARGET}.xml \\epoc32\\winscw\\c\\private\\102829B8\\import\\$${TARGET}.xml" \
              ".\\descriptionxml\\$${TARGET}.xml \\epoc32\\data\\Z\\private\\102829B8\\import\\$${TARGET}.xml"\
    
    BLD_INF_RULES.prj_exports += myblock
    
    # FIXME -- The servicefw headers should really be picked up at $$CWRT_INCLUDE,
    # but in very first fresh build, that directory (and exports) doesn't exist yet
    # and qmake doesn't include that path for moc_*.cpp compilation.
    INCLUDEPATH += $$WRT_DIR/servicefw/inc
    INCLUDEPATH += $$MW_LAYER_SYSTEMINCLUDE $$APP_LAYER_SYSTEMINCLUDE

}
else {
    # Export description file
    EXPORT_DIR = $$DESTDIR/import/
    EXPORT_FILES = ./descriptionxml/$${TARGET}.xml
    EXPORT_FILE_EXT = xml
}

include($$WRT_DIR/cwrt-export.pri)

maemo5|maemo6 {
    target.path = $$CWRT_INSTALL_SERVICE_DIR
  
    xml.path = $$INSTALL_SYSCONFDIR/wrt/api
    xml.files = ./descriptionxml/$${TARGET}.xml
    INCLUDEPATH += $$WRT_DIR/servicefw/inc
        
    INSTALLS += xml target
} 
