/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef GETGROUPIDSTASK_H_
#define GETGROUPIDSTASK_H_

#include <QObject>
#include <QRunnable>
#include <qtcontacts.h>
#include <QMutex>
#include <QWaitCondition>

using namespace QTM_NAMESPACE;

/**
 * An async task for invoking Contacts::getGroupIds().
 */
class GetGroupIdsTask: public QObject, public QRunnable {

    Q_OBJECT

public:
    GetGroupIdsTask(qint32 trId);
    virtual ~GetGroupIdsTask();

    virtual void run();

    void finishTask();

Q_SIGNALS:
    /**
     * Signals a groupIds with transactionId and status.
     * @param a list that contains all group ids.
     */
    void groupIds(GetGroupIdsTask* aTask, QList<QContactLocalId>, qint32 transactionId, qint32 status);

private:
    qint32 m_trId;
    QMutex iMutex;
    QMutex iMutex2;
    QWaitCondition iWait;
};

#endif /* GETGROUPIDSTASK_H_ */
