/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef CONTACTS_HELPERS_HH
#define CONTACTS_HELPERS_HH
#include <QObject>
#include <QString>
#include <QStringList>
#include <QVariant>

#include <qtcontacts.h>

using namespace QTM_NAMESPACE;

class QScriptValue;

    namespace CJSEStatusCodes {

        const qint32 SUCCESS = 0;

        // NON-RECOVERABLE Exception codes
        const qint32 MISSING_ARG_ERR = 1;
        const qint32 INVALID_ARG_ERR = 2;
        const qint32 NOT_SUPPORTED_ERR = 3;

        // RECOVERABLE Exception codes
        const qint32 TIMEOUT_ERR = 100;
        const qint32 DATA_NOT_FOUND_ERR = 101;
        const qint32 DATA_ALREADY_EXISTS_ERR = 102;
        const qint32 SERVICE_BUSY_ERR = 103;
        const qint32 SERVICE_IN_USE_ERR = 104;
        const qint32 DATA_OUT_OF_RANGE_ERR = 105;
        const qint32 NOT_ALLOWED_ERR = 106;
        const qint32 SIZE_EXCEEDED_ERR = 107;
        const qint32 INVALID_URI_ERR = 108;
        const qint32 URI_NOT_FOUND_ERR = 109;
        const qint32 URI_ALREADY_EXISTS_ERR = 110;

        // DOMAIN SPECIFIC Status codes
        const qint32 DIR_NOT_EMPTY_ERR = 500;
        const qint32 FILE_ALREADY_OPEN_ERR = 501;
        const qint32 URI_NOT_SUPPORTED = 502;
    }

    namespace ContactsEnums {
        enum JSContactSorting {
            SORT_ASCENDING = 0, SORT_DESCENDING = 1
        };
    }

    namespace CJSENotifications {
        // Notification events from Contact database
        const qint32 EVENT_CONTACT_ADDED = 0;
        const qint32 EVENT_CONTACT_UPDATED = 1;
        const qint32 EVENT_CONTACT_DELETED = 2;
        const qint32 EVENT_GROUP_ADDED = 3;
        const qint32 EVENT_GROUP_UPDATED = 4;
        const qint32 EVENT_GROUP_DELETED = 5;
    }

namespace ContactsHelpers {

    /**
     * Helper for creating GroupInfo map.
     * @param group group data from the device.
     */
    QVariant createGroupInfoJSON(const QContact *group);

    /**
     * Helper for transferring the contact to map.
     */
    void setContactFields(QContact * con, const QMap<QString, QVariant> & jsonObject);

    /**
     * Helpers for transferring the contact to map.
     */
    void setContactField(QContact* contact, QString key, QVariant data);

    void setFields(QContact* contact, const QString & keyPrefix, const QScriptValue & data);

    const qint32 DEFAULT_TIMEOUT = 3000;

}

#endif

