/*
 * ============================================================================
 *  Name        : qcommlogkeyconstants.h
 *  Part of     : serviceframework / WRT
 *  Description : Common constants for CommLog service provider
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QCOMMLOGKEYCONSTANTS_H_
#define QCOMMLOGKEYCONSTANTS_H_

#include <QString>
#include <QStringList>

const QString KLLogId       = "logId";
const QString KLRecent      = "recent";
const QString KTypeString   = "QString";
const QString KTypeBool     = "bool";
const QString KLType        = "type";
const QString KLCall        = "Call";
const QString KLSms         = "SMS";
const QString KLFlag        = "flag";
const QString KLTime        = "time";
const QString KLDuration    = "duration";
const QString KLPhone       = "phoneNumber";
const QString KLContactName = "contactName";
const QString KLNoOfLogs    = "nofLogs";
const QString KLStartTime   = "startTime";
const QString KLEndTime     = "endTime";
const QString KLIncoming    = "Incoming";
const QString KLReceived    = "Received";
const QString KLOutgoing    = "Outgoing";
const QString KLMissed      = "Missed";
const QString KLSummary     = "summary";
const QString KLNull        = "";
const QString KLSummarySMS  = "SHORTMESSAGE";
const QString KLSummaryCall = "VOICE CALL";



//Keys for Error Map
const QString KErrCode      = "status";
const QString KErrMsg       = "message";
const QString KTransId      = "transactionId";
const QString KUnKErr       = "Unknown";

//typedef unsigned long long int64; Use qulonglong instead

const QStringList eventFieldList = QStringList() <<
                               "incoming" <<
                               "outgoing" <<
                               "received" <<
                               "missed"   <<
                               "sms"      <<
                               "call"     <<
                               "fetched"  <<
                               "missed call";

const qulonglong KBASE          = 0x1;
const qulonglong KEFINCOMING    = KBASE;
const qulonglong KEFOUTGOING    = KBASE<<1;
const qulonglong KEFRECEIVED    = KBASE<<2;
const qulonglong KEFMISSED      = KBASE<<3;
const qulonglong KEFSMS         = KBASE<<4;
const qulonglong KEFCALL        = KBASE<<5;
const qulonglong KEFFETCHED     = KBASE<<6;
const qulonglong KEFMISSEDCALL  = KBASE<<7;

const qulonglong KEFTYPEMASK = KEFSMS | KEFCALL;
const qulonglong KEFFLAGMASK = KEFINCOMING | KEFOUTGOING | KEFRECEIVED | KEFMISSED;

const qulonglong KEFSMSFLAG = KEFFLAGMASK ^ KEFMISSED;
const qulonglong KEFCALLFLAG = KEFFLAGMASK;

const int KCallEventType = 1;
const int KSmsEventType = 2;

//RTComElEvent constants
const QString kid             = "id";
const QString kserviceid      = "service-id";
const QString ktypeid         = "type-id";
const QString kstoragetime    = "storage-time";
const QString kstarttime      = "start-time";
const QString kendtime        = "end-time";
const QString kisread         = "is-read";
const QString kflags          = "flags";
const QString kbytessent      = "bytes-sent";
const QString kbytesreceived  = "bytes-received";
const QString klocaluid       = "local-uid";
const QString klocalname      = "local-name";
const QString kremoteuid      = "remote-uid";
const QString kremotename     = "remote-name";
const QString kremoteebookuid = "remote-ebook-uid";
const QString kchannel        = "channel";
const QString kfreetext       = "free-text";
const QString kgroupuid       = "group-uid";
const QString kservice        = "service";
const QString keventtype      = "event-type";
const QString kadditionaltext = "additional-text";
const QString kiconname       = "icon-name";
const QString kpangomarkup    = "pangomarkup";
const QString kdirection      = "direction";
const QString kstatus         = "status";
const QString kcontactid      = "contact-id";
const QString ktpmessageid    = "tp-message-id";
const QString keventcount     = "event-count";

//RTCom service name constants
const QString ksmsservice  = "RTCOM_EL_SERVICE_SMS";
const QString kcallservice = "RTCOM_EL_SERVICE_CALL";


#endif /* QCOMMLOGKEYCONSTANTS_H_ */
