/*
 * ============================================================================
 *  Name        : qcamerasevice.h
 *  Part of     : serviceframework / WRT
 *  Description : Camera Service header
 *  Version     : %version: 14 % << Don't touch! Updated by Synergy at check-out.
 *
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QCAMERASERVICE_H_
#define QCAMERASERVICE_H_

//QT Includes
#include <QObject>
#include <QVariant>
#include <QMap>
#include <QString>
#include <QDateTime>
#include <QtDBus/QtDBus>


//Project includes
#include "servicesecurityinterface.h"
#include "qcameraserviceinterface.h"
#include "qcameraconstants.h"

    /*
    PictureData
    {
       "uri"
       "Format Data"
    }
    FormatData
    {
       "height"
       "width"
       "type"
    }
    */

class QCameraService : public QObject,                //For QT
                       public ICamera,             //Camera Interface Definition
                       public IServiceSecurity       //Security                        
{
    Q_OBJECT
    Q_INTERFACES(ICamera)

public:
    /**
     * constructor
     * 1) Creates Core class object
     * 2) Initializes transaction ID
     * 3) Creates Transaction Map
     * @since x.y
     * @param
     * @return
     */
    QCameraService();
    
    /**
     * destructor
     * 1) Delete core class instance
     * @since x.y
     * @param
     * @return
     */
    virtual ~QCameraService();
    
    /**
     * Implemented from IServiceSecurity.Needed to handle capabilities.
     * @since x.y
     * @param WRT::SecSession
     * @return 
     */   
    void setSecuritySession(WRT::SecSession *aSecSession);
       
public slots:    

    /**
     * QCameraService::supportedSizes()
     * This method gives list of suppported sizes and mime types
     * @since x.y
     * @param
     * @return QVariant - FormatData QList
     */    
    const QVariant supportedSizes();
    
    /**
     * QCameraService::getList()
     * This gets the list of image meta data within the given interval of time.
     * @since x.y
     * @param aStartTime - interval start time
     * @param aEndTime - interval end time
     * @return QVariant - PictureData QList
     */
     QVariant getList (QDateTime aStartTime, QDateTime aEndTime);

    /**
     * QCameraService::startCamera()
     * This starts platform native camera application.
     * @since x.y
     * @param
     * @return iErrorMap - an error map with the error code and error description
     */
    QVariant startCamera();
    
 signals:
    /**
     * The signal emitted for the all the Async functions.
     * @since x.y
     * @param aStatus   - 0 or Error code
     * @param aTransactionId - TransactionID of the Async operation
     * @param pictureData - The actual response data
     *         PictureData
     *         {
     *             "uri"
     *             "Format Data"
     *         }
     *         FormatData
     *         {
     *             "height"
     *             "width"
     *             "type"
     *         }
     * @return 
     */
    void asyncCallback(int aStatus, int aTransactionId, 
    	               QVariant aPictureData);
    
    
protected:
    WRT::SecSession *iSecSession;

private:
    
    /**
     * QMessagingService::setErrorMap()
     * Constructing an error map
     * ------------------------------------------------------------------------------------------------------------------------
     * @param aErrCode            error code
     * @param aErrMsg             error message
     * ------------------------------------------------------------------------------------------------------------------------
     * @return                    an error map with the error code and error description
     */
     void setErrorMap(const int aErrCode, const QString& aErrMsg);
		
     QMap<QString, QVariant> iErrorMap;
     int iTransactionId;

     QVariantList pictureData;
     QVariantList supportedSizesImage;
     QDateTime startTime;

     bool iNotifySet;

     void sendURIs();
 private slots:
#ifndef CAM_SIGNAL_NE
     void pictureDone(const QString &uri);
#endif

     void getNotify(const QDBusMessage &msg);
    };

#endif // QCAMERASERVICE_H_

