/*
* ============================================================================
*  Name        : qcalendarhelper.h
*  Part of     : serviceframework / WRT
*  Description : calendar helper class for calendar service
*  Version     : %version: 1 % << Don't touch! Updated by Synergy at check-out.
*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef QCALENDAR_HELPERS_H
#define QCALENDAR_HELPERS_H
#include <QObject>
#include <QString>
#include <QVariant>
#include <QDateTime>
#include <calendar-backend/CComponent.h>
#include <calendar-backend/CMulticalendar.h>
#include <calendar-backend/CRecurrence.h>
#include <calendar-backend/CProperties.h>

#ifdef QT_NO_DEBUG
#undef qDebug
#define qDebug if (true) ; else qDebug
#undef printf
#define printf if (true) ; else printf
#endif

#define X_PROPERTY             "X-TYPE_SPEC"

namespace CalendarHelpers {
    //creates CalendarEntry object (as QVariantMap) based on native
    QVariantMap createCalendarEntry(CComponent *entry);

    //creates CalendarEntry instance object (as QVariantMap) based on native
    QVariantMap createCalendarEntry(CComponent *entry, QDateTime instanceTime);

    //fetches calendar entry by uid
    bool getCalendarEntryById(CMulticalendar* multiCalendar, QVariantMap &entry, const QString uid);

    //creates Time object (as QVariantMap) based on native
    QVariantMap createTimeFromEntry(CComponent *entry);

    //creates RepeatRule object (as QVariantMap) based on native
    QVariantMap createRepeatRuleFromRecurrence(CRecurrence *recurrence);

    //creates exceptionDates array (as QVariantList) based on native
    QVariantList createExceptionDatesFromRecurrence(CRecurrence *recurrence);

    //creates Month/MonthDay array (as QList) based on native recurrence rule string
    QList<int> getSpecificRuleFromRecurrence(vector <string> rRules, QString ruleSpecificator);

    //updates CalendarEntry time with instance time
    void createInstanceTime(int type, QVariantMap * map, QDateTime instanceTime);
}

#endif //QCALENDAR_HELPERS_H
