/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef serviceresolver_h
#define serviceresolver_h

#include <QObject>
#include <serviceipcobserver.h>
#include <errdefs.h>

#ifdef __SYMBIAN32__
#include <f32file.h>
#endif

#define GETSERVICEREQ   "GetServiceReq"
#define LISTSERVICEREQ  "ListServiceReq"
#define GETSERVICEVERSIONREQ   "GetServiceVersionReq"
#define SERVICE_RESOLVER_NAME "SERVICE_RESOLVER"

#if defined Q_WS_X11
#define SERVICE_RESOLVER_SERVER "wrtserviceresolver"
#else
#define SERVICE_RESOLVER_SERVER "wrtserviceresolver.exe"
#endif //Q_WS_X11


class QFileSystemWatcher;

namespace WRT {

    class ServiceFwIPCServer;
    class ServiceIPCRequest;
    class ServiceMetaData;
    class ServiceResolutionCriteria;
    class ServiceInfoList;
    class ServiceInfo;
    class ServiceDatabase;

    class ServiceResolver : public QObject, public MServiceIPCObserver
    {
        Q_OBJECT

    public:

        //! ServiceResolver::ServiceResolverErr
        /*!
         This enum describes the errors that may be returned by the Service resolver.
         */
        enum ServiceResolverErr {
            SFW_ERROR_DLL_FILE_NOT_FOUND = RESOLVER_ERR_START_VALUE,  /*!< Can not find service dll file */
            SFW_ERROR_CAN_NOT_REMOVE_SERVICE_ENTRY_FROM_DB,           /*!< Can not remove entries for an uninstalled service from DB */
            SFW_ERROR_CAN_NOT_DELETE_REGISTERED_XML_FILE,             /*!< Can not delete xml file for an uninstalled service from registered folder */
            SFW_ERROR_SERVICE_INSTALLED_DRIVED_HAS_BEEN_REMOVED,      /*!< Drive on which service is intalled, has been removed */
            SFW_ERROR_DLL_VERSION_NOT_MATCH_SERVICE_VERSION_IN_XML,   /*!< Service  dll version does not match service version specified in XML*/
            SFW_ERROR_READING_LIBRARY_INFO ,                          /*!< Error reading library info*/
            SFW_ERROR_SERVICE_VERSION_NOT_CORRECT_IN_XML              /*!< service version in xml file is not in the right format*/
        };

    public:

        ServiceResolver(QObject *aParent = NULL );

        virtual ~ServiceResolver();

    private:

        ServiceInfo getService(ServiceResolutionCriteria &aSearchCriteria);

        int registerService(const QString &aXmlFilePath);

        ServiceInfoList listServices();

        void recoverDB();

        bool pluginExists(QString filePath);

        int completeBinaryFilePath(QString& dllName);

        int checkBinaryVersion(const QString& dllPath, const QString& xmlDllVersion);

        int completeUnistallation(ServiceDatabase &database, const QString& serviceName, const QString& dllPath,
                                  const QString& xmlFileName);
        QString getServiceVersion(const QString &aServiceName);

    //From MServiceIPCObserver
    private:
        bool handleRequest(ServiceIPCRequest *aRequest);

        void handleCancelRequest(ServiceIPCRequest *aRequest);

        void handleClientConnect( ClientInfo *aNewClient );

        void handleClientDisconnect( ClientInfo *aClient );

    private Q_SLOTS:

        void onDirectoryChanged( const QString &aPath = "" );
        void closeServer();

    // Member Variables
    private:
        ServiceFwIPCServer *m_server;
        ServiceMetaData    *m_parser;
        QFileSystemWatcher  *m_fsWatcher;
        QString m_importFolder;
        QString m_registeredFolder;
        QString m_libraryExt;
        int m_count;
#ifdef __SYMBIAN32__
        QString m_privatePath;
        RFs m_fsSession;
#endif
    };

}

#endif /*serviceresolver_h*/
