/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef SFWPARAMETER_H
#define SFWPARAMETER_H

#include <QString>
#include "servicemetadata_global.h"

namespace WRT {

    class METADATA_EXPORT SFWParameter
    {

    public:
        /**
         * Class constructor
         *
         * @param aName method parameter name
         * @param aType method parameter type
         * @param aDescription parameter description
         * @param aStatus parameter status (mandatory or not)
         */
        SFWParameter(const QString& aName, const QString& aType, const QString& aDescription, bool aStatus);

        /**
         *  Class destructor
         */
        ~SFWParameter(void);

        /**
         *  Gets the parameter name
         *
         * @return parameter name or default value (empty string) if it is not available
         */
        QString name();

        /**
         *  Gets the parameter type ("string", "int"  etc)
         *
         * @return parameter type or default value (empty string) if it is not available
         */
        QString type();

        /**
         *  Gets the parameter description
         *
         * @return parameter description or default value (empty string) if it is not available
         */
        QString description();

        /**
         *  Gets the parameter status
         *
         * @return parameter status or default value (empty string) if it is not available
         */
        bool mandatory();

    private:
        QString parameterName;
        QString parameterType;
        QString parameterDescription;
        bool parameterStatus;

    };

}

#endif // SFWPARAMETER_H
