/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef sfwinterface_h
#define sfwinterface_h

#include <QString>
#include <QStringList>
#include "servicemetadata_global.h"

namespace WRT {

    class METADATA_EXPORT SFWInterface
    {
    public:

        SFWInterface();

        virtual ~SFWInterface();

        QString name();

        QString version();

        QStringList capabalitiesList();

        QString capabalities();

        QString description();

        void setName(const QString& aName);

        void setVersion(const QString& aVersion);

        void setCapabilities(const QString& aCapabilities);

        void setDescription(const QString& description);

    private:
        QString m_name;
        QString m_version;
        QString m_capabilities;
        QString m_description;
    };

}

#endif /*sfwinterface_h*/
