#
# ============================================================================
#  Name        : servicefw.pro
#  Part of     : WRT / Service Framework
#  Description : Project definition file for service framework
#  Version     : %version: 17 % << Don't touch! Updated by Synergy at check-out.
#
# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

TEMPLATE = subdirs
CONFIG += ordered debug_and_release

include($$PWD/qtsfw.pri)
# Keep the build order
# servicemetadata, serviceresolution, servicedatabase, serviceresolver
# service handler, npsfwplugin, symbianeventloop, symbian plugin
#

SUBDIRS =     ./servicemetadata \ 
              ./serviceresolution \
              ./servicehandler \
              ./npsfwplugin/jsbinding/npjsbinding.pro \
              ./npsfwplugin \
              ./servicedatabase \
              ./serviceresolver


unix:!symbian {
    # We need to include cwrt.pri to get public header directory set.
    # Remove below cwrt.pri include if that causes problems. 
    # Installing service framework headers so that debianization can pick the right headers.
    include($$PWD/../cwrt.pri)
    headers.files += $$PWD/inc/*.h
    headers.path += $$CWRT_INSTALL_PUBLIC_HEADERS_DIR/servicefw
    INSTALLS += headers
}
